/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.scale.Scales;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.GeomLayerListUtil;
import jetbrains.datalore.plot.builder.Plot;
import jetbrains.datalore.plot.builder.PlotBuilder;
import jetbrains.datalore.plot.builder.assemble.GuideOptions;
import jetbrains.datalore.plot.builder.assemble.PlotAssemblerUtil;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.assemble.TypedScaleMap;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.layout.AxisLayout;
import jetbrains.datalore.plot.builder.layout.EmptyAxisLayout;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.LiveMapTileLayout;
import jetbrains.datalore.plot.builder.layout.PlotAxisLayout;
import jetbrains.datalore.plot.builder.layout.PlotLayout;
import jetbrains.datalore.plot.builder.layout.XYPlotTileLayout;
import jetbrains.datalore.plot.builder.theme.Theme;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 82\u00020\u0001:\u00018B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\"\u001a\u00020#JD\u0010$\u001a\u00020#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00052\b\b\u0002\u0010-\u001a\u00020\rH\u0002J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020/J\u0006\u00101\u001a\u00020/J\b\u00102\u001a\u00020\rH\u0002J\b\u00103\u001a\u00020\rH\u0002J\u001e\u00104\u001a\u00020/2\u0016\u00105\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u001d0\u001bJ\u0010\u00106\u001a\u00020/2\b\u00107\u001a\u0004\u0018\u00010!R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "", "scaleByAes", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "layersByTile", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "myCoordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "myTheme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "(Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;Ljava/util/List;Ljetbrains/datalore/plot/builder/coord/CoordProvider;Ljetbrains/datalore/plot/builder/theme/Theme;)V", "containsLiveMap", "", "getContainsLiveMap", "()Z", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "getFacets", "()Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "setFacets", "(Ljetbrains/datalore/plot/builder/assemble/PlotFacets;)V", "isFacetLayout", "getLayersByTile", "()Ljava/util/List;", "myAxisEnabled", "myGuideOptionsMap", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/builder/assemble/GuideOptions;", "myInteractionsEnabled", "myLegendsEnabled", "myTitle", "", "createPlot", "Ljetbrains/datalore/plot/builder/Plot;", "createXYPlot", "xScaleProto", "Ljetbrains/datalore/plot/base/Scale;", "", "yScaleProto", "plotLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayout;", "legendBoxInfos", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "hasLiveMap", "disableAxis", "", "disableInteractions", "disableLegends", "hasFacets", "hasLayers", "setGuideOptionsMap", "guideOptionsMap", "setTitle", "title", "Companion", "plot-builder-portable"})
public final class PlotAssembler {
    private final boolean containsLiveMap;
    @NotNull
    private PlotFacets facets;
    private String myTitle;
    private Map<Aes<?>, ? extends GuideOptions> myGuideOptionsMap;
    private boolean myAxisEnabled;
    private boolean myLegendsEnabled;
    private boolean myInteractionsEnabled;
    private final TypedScaleMap scaleByAes;
    @NotNull
    private final List<List<GeomLayer>> layersByTile;
    private final CoordProvider myCoordProvider;
    private final Theme myTheme;
    public static final Companion Companion = new Companion(null);

    public final boolean getContainsLiveMap() {
        return this.containsLiveMap;
    }

    @NotNull
    public final PlotFacets getFacets() {
        return this.facets;
    }

    public final void setFacets(@NotNull PlotFacets plotFacets) {
        Intrinsics.checkNotNullParameter((Object)plotFacets, (String)"<set-?>");
        this.facets = plotFacets;
    }

    private final boolean isFacetLayout() {
        return this.hasFacets();
    }

    public final void setTitle(@Nullable String title) {
        this.myTitle = title;
    }

    private final boolean hasFacets() {
        return this.facets.isDefined();
    }

    private final boolean hasLayers() {
        for (List<GeomLayer> tileLayers : this.layersByTile) {
            Collection collection2 = tileLayers;
            boolean bl = false;
            if (!(!collection2.isEmpty())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final Plot createPlot() {
        Scale<Double> yScaleProto;
        Preconditions.INSTANCE.checkState(this.hasLayers(), "No layers in plot");
        List<LegendBoxInfo> legendsBoxInfos = this.myLegendsEnabled ? PlotAssemblerUtil.INSTANCE.createLegends(this.layersByTile, this.myGuideOptionsMap, this.myTheme.legend()) : CollectionsKt.emptyList();
        Scale<Double> xScaleProto = GeomLayerListUtil.INSTANCE.anyBoundXScale(this.scaleByAes, this.layersByTile);
        if (xScaleProto == null) {
            xScaleProto = Scales.INSTANCE.continuousDomain("x", Aes.Companion.getX());
        }
        if ((yScaleProto = GeomLayerListUtil.INSTANCE.anyBoundYScale(this.scaleByAes, this.layersByTile)) == null) {
            yScaleProto = Scales.INSTANCE.continuousDomain("y", Aes.Companion.getY());
        }
        if (this.containsLiveMap) {
            PlotLayout plotLayout = PlotAssemblerUtil.INSTANCE.createPlotLayout(new LiveMapTileLayout(), this.isFacetLayout(), this.facets);
            return this.createXYPlot(xScaleProto, yScaleProto, plotLayout, legendsBoxInfos, true);
        }
        Map<Aes<?>, ClosedRange<Double>> rangeByAes = PlotAssemblerUtil.INSTANCE.rangeByNumericAes(this.layersByTile);
        ClosedRange<Double> xDomain = rangeByAes.get(Aes.Companion.getX());
        ClosedRange<Double> yDomain = rangeByAes.get(Aes.Companion.getY());
        Preconditions.INSTANCE.checkState(xDomain != null, "X domain not defined");
        Preconditions.INSTANCE.checkState(yDomain != null, "Y domain not defined");
        ClosedRange<Double> closedRange = xDomain;
        Intrinsics.checkNotNull(closedRange);
        Preconditions.INSTANCE.checkState(SeriesUtil.INSTANCE.isFinite(((Number)closedRange.getLowerEnd()).doubleValue()), "X domain lower end: " + ((Number)xDomain.getLowerEnd()).doubleValue());
        Preconditions.INSTANCE.checkState(SeriesUtil.INSTANCE.isFinite(((Number)xDomain.getUpperEnd()).doubleValue()), "X domain upper end: " + ((Number)xDomain.getUpperEnd()).doubleValue());
        ClosedRange<Double> closedRange2 = yDomain;
        Intrinsics.checkNotNull(closedRange2);
        Preconditions.INSTANCE.checkState(SeriesUtil.INSTANCE.isFinite(((Number)closedRange2.getLowerEnd()).doubleValue()), "Y domain lower end: " + ((Number)yDomain.getLowerEnd()).doubleValue());
        Preconditions.INSTANCE.checkState(SeriesUtil.INSTANCE.isFinite(((Number)yDomain.getUpperEnd()).doubleValue()), "Y domain upper end: " + ((Number)yDomain.getUpperEnd()).doubleValue());
        AxisLayout xAxisLayout = null;
        AxisLayout yAxisLayout = null;
        if (this.myAxisEnabled) {
            xAxisLayout = PlotAxisLayout.Companion.bottom(xScaleProto, xDomain, yDomain, this.myCoordProvider, this.myTheme.axisX());
            yAxisLayout = PlotAxisLayout.Companion.left(yScaleProto, xDomain, yDomain, this.myCoordProvider, this.myTheme.axisY());
        } else {
            xAxisLayout = EmptyAxisLayout.Companion.bottom(xDomain, yDomain);
            yAxisLayout = EmptyAxisLayout.Companion.left(xDomain, yDomain);
        }
        PlotLayout plotLayout = PlotAssemblerUtil.INSTANCE.createPlotLayout(new XYPlotTileLayout(xAxisLayout, yAxisLayout), this.isFacetLayout(), this.facets);
        if (!this.myAxisEnabled) {
            plotLayout.setPadding(0.0, 0.0, 0.0, 0.0);
        }
        return PlotAssembler.createXYPlot$default(this, xScaleProto, yScaleProto, plotLayout, legendsBoxInfos, false, 16, null);
    }

    private final Plot createXYPlot(Scale<Double> xScaleProto, Scale<Double> yScaleProto, PlotLayout plotLayout, List<? extends LegendBoxInfo> legendBoxInfos, boolean hasLiveMap) {
        PlotBuilder plotBuilder = new PlotBuilder(this.myTheme);
        plotBuilder.setTitle(this.myTitle);
        plotBuilder.scaleXProto(xScaleProto);
        plotBuilder.scaleYProto(yScaleProto);
        plotBuilder.setAxisTitleBottom(xScaleProto.getName());
        plotBuilder.setAxisTitleLeft(yScaleProto.getName());
        plotBuilder.setCoordProvider(this.myCoordProvider);
        for (LegendBoxInfo legendBoxInfo : legendBoxInfos) {
            plotBuilder.addLegendBoxInfo(legendBoxInfo);
        }
        for (List list2 : this.layersByTile) {
            plotBuilder.addTileLayers(list2);
        }
        plotBuilder.setPlotLayout(plotLayout);
        plotBuilder.axisEnabled(this.myAxisEnabled);
        plotBuilder.interactionsEnabled(this.myInteractionsEnabled);
        plotBuilder.setLiveMap(hasLiveMap);
        return plotBuilder.build();
    }

    static /* synthetic */ Plot createXYPlot$default(PlotAssembler plotAssembler, Scale scale, Scale scale2, PlotLayout plotLayout, List list2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return plotAssembler.createXYPlot(scale, scale2, plotLayout, list2, bl);
    }

    public final void setGuideOptionsMap(@NotNull Map<Aes<?>, ? extends GuideOptions> guideOptionsMap) {
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        this.myGuideOptionsMap = guideOptionsMap;
    }

    public final void disableAxis() {
        this.myAxisEnabled = false;
    }

    public final void disableLegends() {
        this.myLegendsEnabled = false;
    }

    public final void disableInteractions() {
        this.myInteractionsEnabled = false;
    }

    @NotNull
    public final List<List<GeomLayer>> getLayersByTile() {
        return this.layersByTile;
    }

    /*
     * WARNING - void declaration
     */
    private PlotAssembler(TypedScaleMap scaleByAes2, List<? extends List<? extends GeomLayer>> layersByTile, CoordProvider myCoordProvider, Theme myTheme) {
        boolean bl;
        boolean bl2;
        block3: {
            void $this$any$iv;
            this.scaleByAes = scaleByAes2;
            this.layersByTile = layersByTile;
            this.myCoordProvider = myCoordProvider;
            this.myTheme = myTheme;
            this.facets = PlotFacets.Companion.undefined();
            this.myGuideOptionsMap = new HashMap();
            this.myLegendsEnabled = true;
            this.myInteractionsEnabled = true;
            Iterable iterable = CollectionsKt.flatten((Iterable)this.layersByTile);
            PlotAssembler plotAssembler = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object receiver = element$iv = iterator2.next();
                    boolean bl3 = false;
                    if (!((GeomLayer)receiver).isLiveMap()) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        plotAssembler.containsLiveMap = bl = bl2;
        this.myAxisEnabled = !this.containsLiveMap;
    }

    public /* synthetic */ PlotAssembler(TypedScaleMap scaleByAes2, List layersByTile, CoordProvider myCoordProvider, Theme myTheme, DefaultConstructorMarker $constructor_marker) {
        this(scaleByAes2, layersByTile, myCoordProvider, myTheme);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ,\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/assemble/PlotAssembler$Companion;", "", "()V", "multiTile", "Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "scaleByAes", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "layersByTile", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "singleTile", "plotLayers", "plot-builder-portable"})
    public static final class Companion {
        @NotNull
        public final PlotAssembler singleTile(@NotNull TypedScaleMap scaleByAes2, @NotNull List<? extends GeomLayer> plotLayers, @NotNull CoordProvider coordProvider, @NotNull Theme theme) {
            Intrinsics.checkNotNullParameter((Object)scaleByAes2, (String)"scaleByAes");
            Intrinsics.checkNotNullParameter(plotLayers, (String)"plotLayers");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            ArrayList<List<? extends GeomLayer>> layersByTile = new ArrayList<List<? extends GeomLayer>>();
            layersByTile.add(plotLayers);
            return this.multiTile(scaleByAes2, (List<? extends List<? extends GeomLayer>>)layersByTile, coordProvider, theme);
        }

        @NotNull
        public final PlotAssembler multiTile(@NotNull TypedScaleMap scaleByAes2, @NotNull List<? extends List<? extends GeomLayer>> layersByTile, @NotNull CoordProvider coordProvider, @NotNull Theme theme) {
            Intrinsics.checkNotNullParameter((Object)scaleByAes2, (String)"scaleByAes");
            Intrinsics.checkNotNullParameter(layersByTile, (String)"layersByTile");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new PlotAssembler(scaleByAes2, layersByTile, coordProvider, theme, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

