/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.base.scale.breaks.ScaleBreaksUtil;
import jetbrains.datalore.plot.builder.assemble.ColorBarOptions;
import jetbrains.datalore.plot.builder.assemble.LegendAssemblerUtil;
import jetbrains.datalore.plot.builder.guide.ColorBarComponent;
import jetbrains.datalore.plot.builder.guide.ColorBarComponentLayout;
import jetbrains.datalore.plot.builder.guide.ColorBarComponentSpec;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.scale.GuideBreak;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0017\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/builder/assemble/ColorBarAssembler;", "", "legendTitle", "", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "scale", "Ljetbrains/datalore/plot/base/Scale;", "Ljetbrains/datalore/base/values/Color;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "(Ljava/lang/String;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/plot/builder/theme/LegendTheme;)V", "myOptions", "Ljetbrains/datalore/plot/builder/assemble/ColorBarOptions;", "createColorBar", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "setOptions", "", "options", "setOptions$plot_builder_portable", "Companion", "plot-builder-portable"})
public final class ColorBarAssembler {
    private ColorBarOptions myOptions;
    private final String legendTitle;
    private final ClosedRange<Double> domain;
    private final Scale<Color> scale;
    private final LegendTheme theme;
    private static final boolean DEBUG_DRAWING = false;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final LegendBoxInfo createColorBar() {
        Scale<Color> scale = this.scale;
        if (!scale.hasBreaks()) {
            scale = ScaleBreaksUtil.INSTANCE.withBreaks(scale, this.domain, 5);
        }
        ArrayList<GuideBreak<Double>> guideBreaks = new ArrayList<GuideBreak<Double>>();
        List<Double> breaks = ScaleUtil.INSTANCE.breaksTransformed(scale);
        Iterator<String> label = ScaleUtil.INSTANCE.labels(scale).iterator();
        Iterator<Double> iterator2 = breaks.iterator();
        while (iterator2.hasNext()) {
            double v = ((Number)iterator2.next()).doubleValue();
            guideBreaks.add(new GuideBreak<Double>(v, label.next()));
        }
        if (guideBreaks.isEmpty()) {
            return LegendBoxInfo.Companion.getEMPTY();
        }
        ColorBarComponentSpec spec = Companion.createColorBarSpec(this.legendTitle, this.domain, (List<GuideBreak<Double>>)guideBreaks, scale, this.theme, this.myOptions);
        return new LegendBoxInfo(spec, spec.getSize()){
            final /* synthetic */ ColorBarComponentSpec $spec;

            @NotNull
            public LegendBox createLegendBox() {
                ColorBarComponent c = new ColorBarComponent(this.$spec);
                c.setDebug(false);
                return c;
            }
            {
                this.$spec = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    public final void setOptions$plot_builder_portable(@Nullable ColorBarOptions options) {
        this.myOptions = options;
    }

    public ColorBarAssembler(@NotNull String legendTitle, @NotNull ClosedRange<Double> domain, @NotNull Scale<Color> scale, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)legendTitle, (String)"legendTitle");
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.legendTitle = legendTitle;
        this.domain = domain;
        this.scale = scale;
        this.theme = theme;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/builder/assemble/ColorBarAssembler$Companion;", "", "()V", "DEBUG_DRAWING", "", "createColorBarSpec", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentSpec;", "title", "", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breaks", "", "Ljetbrains/datalore/plot/builder/scale/GuideBreak;", "scale", "Ljetbrains/datalore/plot/base/Scale;", "Ljetbrains/datalore/base/values/Color;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "options", "Ljetbrains/datalore/plot/builder/assemble/ColorBarOptions;", "plot-builder-portable"})
    public static final class Companion {
        @NotNull
        public final ColorBarComponentSpec createColorBarSpec(@NotNull String title, @NotNull ClosedRange<Double> domain, @NotNull List<GuideBreak<Double>> breaks, @NotNull Scale<Color> scale, @NotNull LegendTheme theme, @Nullable ColorBarOptions options) {
            Integer binCount;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(scale, (String)"scale");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            LegendDirection legendDirection = LegendAssemblerUtil.INSTANCE.legendDirection(theme);
            ColorBarOptions colorBarOptions = options;
            Double width2 = colorBarOptions != null ? colorBarOptions.getWidth() : null;
            ColorBarOptions colorBarOptions2 = options;
            Double height = colorBarOptions2 != null ? colorBarOptions2.getHeight() : null;
            DoubleVector barSize = ColorBarComponentSpec.Companion.barAbsoluteSize$plot_builder_portable(legendDirection, theme);
            if (width2 != null) {
                barSize = new DoubleVector(width2, barSize.getY());
            }
            if (height != null) {
                barSize = new DoubleVector(barSize.getX(), height);
            }
            ColorBarComponentLayout layout = legendDirection == LegendDirection.HORIZONTAL ? ColorBarComponentLayout.Companion.horizontal(title, domain, breaks, barSize) : ColorBarComponentLayout.Companion.vertical(title, domain, breaks, barSize);
            ColorBarComponentSpec spec = new ColorBarComponentSpec(title, domain, breaks, scale, theme, layout);
            ColorBarOptions colorBarOptions3 = options;
            Integer n = binCount = colorBarOptions3 != null ? colorBarOptions3.getBinCount() : null;
            if (binCount != null) {
                spec.setBinCount$plot_builder_portable(binCount);
            }
            return spec;
        }

        public static /* synthetic */ ColorBarComponentSpec createColorBarSpec$default(Companion companion, String string, ClosedRange closedRange, List list2, Scale scale, LegendTheme legendTheme, ColorBarOptions colorBarOptions, int n, Object object) {
            if ((n & 0x20) != 0) {
                colorBarOptions = null;
            }
            return companion.createColorBarSpec(string, closedRange, list2, scale, legendTheme, colorBarOptions);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

