/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.List;
import jetbrains.datalore.base.event.MouseEvent;
import jetbrains.datalore.base.event.MouseEventSpec;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.event.EventHandler;
import jetbrains.datalore.base.observable.property.ReadableProperty;
import jetbrains.datalore.plot.builder.Plot;
import jetbrains.datalore.plot.builder.PlotContainerPortable;
import jetbrains.datalore.plot.builder.event.MouseEventPeer;
import jetbrains.datalore.plot.builder.interact.TooltipSpec;
import jetbrains.datalore.plot.builder.interact.render.TooltipLayer;
import jetbrains.datalore.vis.svg.SvgGElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0002R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/builder/PlotContainer;", "Ljetbrains/datalore/plot/builder/PlotContainerPortable;", "plot", "Ljetbrains/datalore/plot/builder/Plot;", "preferredSize", "Ljetbrains/datalore/base/observable/property/ReadableProperty;", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljetbrains/datalore/plot/builder/Plot;Ljetbrains/datalore/base/observable/property/ReadableProperty;)V", "mouseEventPeer", "Ljetbrains/datalore/plot/builder/event/MouseEventPeer;", "getMouseEventPeer", "()Ljetbrains/datalore/plot/builder/event/MouseEventPeer;", "myDecorationLayer", "Ljetbrains/datalore/vis/svg/SvgGElement;", "buildContent", "", "clearContent", "hookupInteractions", "plot-builder"})
public final class PlotContainer
extends PlotContainerPortable {
    private final SvgGElement myDecorationLayer;

    @NotNull
    public final MouseEventPeer getMouseEventPeer() {
        return this.getPlot().getMouseEventPeer();
    }

    @Override
    protected void buildContent() {
        super.buildContent();
        if (this.getPlot().isInteractionsEnabled()) {
            this.getSvg().children().add(this.myDecorationLayer);
            this.hookupInteractions();
        }
    }

    @Override
    public void clearContent() {
        this.myDecorationLayer.children().clear();
        super.clearContent();
    }

    private final void hookupInteractions() {
        Preconditions.INSTANCE.checkState(this.getPlot().isInteractionsEnabled());
        DoubleRectangle viewport = new DoubleRectangle(DoubleVector.Companion.getZERO(), (DoubleVector)this.getPlot().laidOutSize().get());
        TooltipLayer tooltipLayer = new TooltipLayer(this.myDecorationLayer, viewport, this.getPlot().getTooltipAnchor(), this.getPlot().getTooltipMinWidth());
        Function1 onMouseMoved2 = (Function1)new Function1<MouseEvent, Unit>(this, tooltipLayer){
            final /* synthetic */ PlotContainer this$0;
            final /* synthetic */ TooltipLayer $tooltipLayer;

            public final void invoke(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DoubleVector coord = new DoubleVector(e.getX(), e.getY());
                List<TooltipSpec> tooltipSpecs = this.this$0.getPlot().createTooltipSpecs(coord);
                DoubleRectangle geomBounds = this.this$0.getPlot().getGeomBounds(coord);
                this.$tooltipLayer.showTooltips(coord, tooltipSpecs, geomBounds);
            }
            {
                this.this$0 = plotContainer;
                this.$tooltipLayer = tooltipLayer;
                super(1);
            }
        };
        this.reg(this.getPlot().getMouseEventPeer().addEventHandler(MouseEventSpec.MOUSE_MOVED, (EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(onMouseMoved2){
            final /* synthetic */ Function1 $onMouseMoved;

            public void onEvent(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$onMouseMoved.invoke((Object)event);
            }
            {
                this.$onMouseMoved = $captured_local_variable$0;
            }
        }));
        this.reg(this.getPlot().getMouseEventPeer().addEventHandler(MouseEventSpec.MOUSE_DRAGGED, (EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(tooltipLayer){
            final /* synthetic */ TooltipLayer $tooltipLayer;

            public void onEvent(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$tooltipLayer.hideTooltip();
            }
            {
                this.$tooltipLayer = $captured_local_variable$0;
            }
        }));
        this.reg(this.getPlot().getMouseEventPeer().addEventHandler(MouseEventSpec.MOUSE_LEFT, (EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(tooltipLayer){
            final /* synthetic */ TooltipLayer $tooltipLayer;

            public void onEvent(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$tooltipLayer.hideTooltip();
            }
            {
                this.$tooltipLayer = $captured_local_variable$0;
            }
        }));
    }

    public PlotContainer(@NotNull Plot plot2, @NotNull ReadableProperty<DoubleVector> preferredSize) {
        Intrinsics.checkNotNullParameter((Object)plot2, (String)"plot");
        Intrinsics.checkNotNullParameter(preferredSize, (String)"preferredSize");
        super(plot2, preferredSize);
        this.myDecorationLayer = new SvgGElement();
    }
}

