/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.regression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.plot.base.stat.math3.Percentile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J2\u0010\r\u001a\u0012\u0012\u0004\u0012\u0002H\u000f0\u000ej\b\u0012\u0004\u0012\u0002H\u000f`\u0010\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00062\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/base/stat/regression/RegressionUtil;", "", "()V", "percentile", "", "data", "", "p", "sampleInt", "", "n", "", "m", "sampling", "Ljava/util/ArrayList;", "T", "Lkotlin/collections/ArrayList;", "plot-base-portable"})
public final class RegressionUtil {
    public static final RegressionUtil INSTANCE;

    @NotNull
    public final <T> ArrayList<T> sampling(@NotNull List<? extends T> data, int m) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        int[] index = this.sampleInt(data.size(), m);
        ArrayList<T> result = new ArrayList<T>();
        for (int i : index) {
            result.add(data.get(i));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final int[] sampleInt(int n, int m) {
        if (n < m || m < 0) {
            String string = "Sample " + m + " data from " + n + " data is impossible!";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int[] perm = new int[n];
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void i;
            perm[i] = i;
            ++i;
        }
        int[] result = new int[m];
        n3 = 0;
        int n4 = m;
        while (n3 < n4) {
            void j;
            void r = j + (int)(Random.Default.nextDouble() * (double)(n - j));
            result[j] = perm[r];
            perm[r] = perm[j];
            ++j;
        }
        return result;
    }

    public final double percentile(@NotNull List<Double> data, double p) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return Percentile.INSTANCE.evaluate(CollectionsKt.toDoubleArray((Collection)data), p * (double)100);
    }

    private RegressionUtil() {
    }

    static {
        RegressionUtil regressionUtil;
        INSTANCE = regressionUtil = new RegressionUtil();
    }
}

