/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.MathArrays;
import jetbrains.datalore.plot.base.stat.math3.PolynomialSplineFunction;
import jetbrains.datalore.plot.base.stat.math3.SplineInterpolator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J(\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/LoessInterpolator;", "", "bandwidth", "", "robustnessIters", "", "accuracy", "(DID)V", "checkAllFiniteReal", "", "values", "", "checkFinite", "x", "interpolate", "Ljetbrains/datalore/plot/base/stat/math3/PolynomialSplineFunction;", "xval", "yval", "nextNonzero", "weights", "i", "smooth", "tricube", "updateBandwidthInterval", "bandwidthInterval", "", "Companion", "plot-base-portable"})
public final class LoessInterpolator {
    private final double bandwidth;
    private final int robustnessIters;
    private final double accuracy;
    public static final double DEFAULT_BANDWIDTH = 0.3;
    public static final int DEFAULT_ROBUSTNESS_ITERS = 2;
    public static final double DEFAULT_ACCURACY = 1.0E-12;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final PolynomialSplineFunction interpolate(@NotNull double[] xval, @NotNull double[] yval) {
        Intrinsics.checkNotNullParameter((Object)xval, (String)"xval");
        Intrinsics.checkNotNullParameter((Object)yval, (String)"yval");
        return new SplineInterpolator().interpolate(xval, this.smooth(xval, yval));
    }

    /*
     * WARNING - void declaration
     */
    private final double[] smooth(double[] xval, double[] yval, double[] weights) {
        if (xval.length != yval.length) {
            String string = "Dimension mismatch of interpolation points: " + xval.length + " != " + yval.length;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int n = xval.length;
        if (n == 0) {
            String string = "No data to interpolate";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.checkAllFiniteReal(xval);
        this.checkAllFiniteReal(yval);
        this.checkAllFiniteReal(weights);
        MathArrays.INSTANCE.checkOrder(xval);
        if (n == 1) {
            return new double[]{yval[0]};
        }
        if (n == 2) {
            return new double[]{yval[0], yval[1]};
        }
        int bandwidthInPoints = (int)(this.bandwidth * (double)n);
        if (bandwidthInPoints < 2) {
            String string = "Number is too small: " + bandwidthInPoints + " < 2";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        double[] res = new double[n];
        double[] residuals = new double[n];
        double[] sortedResiduals = new double[n];
        double[] robustnessWeights = new double[n];
        ArraysKt.fill$default((double[])robustnessWeights, (double)1.0, (int)0, (int)0, (int)6, null);
        int n2 = 0;
        int n3 = this.robustnessIters;
        if (n2 <= n3) {
            while (true) {
                void iter;
                int[] bandwidthInterval = new int[]{0, bandwidthInPoints - 1};
                int n4 = 0;
                int n5 = n;
                while (n4 < n5) {
                    double xkw;
                    void i;
                    double x2 = xval[i];
                    if (i > 0) {
                        this.updateBandwidthInterval(xval, weights, (int)i, bandwidthInterval);
                    }
                    int ileft = bandwidthInterval[0];
                    int iright = bandwidthInterval[1];
                    int edge = 0;
                    edge = xval[i] - xval[ileft] > xval[iright] - xval[i] ? ileft : iright;
                    double sumWeights = 0.0;
                    double sumX = 0.0;
                    double sumXSquared = 0.0;
                    double sumY = 0.0;
                    double sumXY = 0.0;
                    double d = 1.0 / (xval[edge] - x2);
                    boolean bl = false;
                    double denom = Math.abs(d);
                    int n6 = ileft;
                    int n7 = iright;
                    if (n6 <= n7) {
                        while (true) {
                            void k;
                            double xk = xval[k];
                            double yk = yval[k];
                            double dist = k < i ? x2 - xk : xk - x2;
                            double w = this.tricube(dist * denom) * robustnessWeights[k] * weights[k];
                            xkw = xk * w;
                            sumWeights += w;
                            sumX += xkw;
                            sumXSquared += xk * xkw;
                            sumY += yk * w;
                            sumXY += yk * xkw;
                            if (k == n7) break;
                            ++k;
                        }
                    }
                    double meanX = sumX / sumWeights;
                    double meanY = sumY / sumWeights;
                    double meanXY = sumXY / sumWeights;
                    double meanXSquared = sumXSquared / sumWeights;
                    double beta = 0.0;
                    xkw = meanXSquared - meanX * meanX;
                    boolean bl2 = false;
                    xkw = Math.abs(xkw);
                    bl2 = false;
                    beta = Math.sqrt(xkw) < this.accuracy ? 0.0 : (meanXY - meanX * meanY) / (meanXSquared - meanX * meanX);
                    double alpha = meanY - beta * meanX;
                    res[i] = beta * x2 + alpha;
                    double d2 = yval[i] - res[i];
                    boolean bl3 = false;
                    residuals[i] = Math.abs(d2);
                    ++i;
                }
                if (iter == this.robustnessIters) break;
                ArraysKt.copyInto((double[])residuals, (double[])sortedResiduals, (int)0, (int)0, (int)n);
                ArraysKt.sort((double[])sortedResiduals);
                double medianResidual = sortedResiduals[n / 2];
                int x2 = 0;
                if (Math.abs(medianResidual) < this.accuracy) break;
                x2 = 0;
                int n8 = n;
                while (x2 < n8) {
                    void i;
                    double arg = residuals[i] / ((double)6 * medianResidual);
                    if (arg >= 1.0) {
                        robustnessWeights[i] = 0.0;
                    } else {
                        double w = 1.0 - arg * arg;
                        robustnessWeights[i] = w * w;
                    }
                    ++i;
                }
                if (iter == n3) break;
                ++iter;
            }
        }
        return res;
    }

    private final void updateBandwidthInterval(double[] xval, double[] weights, int i, int[] bandwidthInterval) {
        int left = bandwidthInterval[0];
        int right = bandwidthInterval[1];
        int nextRight = this.nextNonzero(weights, right);
        if (nextRight < xval.length && xval[nextRight] - xval[i] < xval[i] - xval[left]) {
            int nextLeft;
            bandwidthInterval[0] = nextLeft = this.nextNonzero(weights, bandwidthInterval[0]);
            bandwidthInterval[1] = nextRight;
        }
    }

    private final double tricube(double x2) {
        boolean bl = false;
        double absX = Math.abs(x2);
        if (absX >= 1.0) {
            return 0.0;
        }
        double tmp = 1.0 - absX * absX * absX;
        return tmp * tmp * tmp;
    }

    private final int nextNonzero(double[] weights, int i) {
        int j;
        for (j = i + 1; j < weights.length && weights[j] == 0.0; ++j) {
        }
        return j;
    }

    private final double[] smooth(double[] xval, double[] yval) {
        if (xval.length != yval.length) {
            String string = "Dimension mismatch: " + xval.length + " != " + yval.length;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        double[] unitWeights = new double[xval.length];
        ArraysKt.fill$default((double[])unitWeights, (double)1.0, (int)0, (int)0, (int)6, null);
        return this.smooth(xval, yval, unitWeights);
    }

    private final void checkFinite(double x2) {
        block3: {
            block2: {
                double d = x2;
                boolean bl = false;
                if (Double.isInfinite(d)) break block2;
                d = x2;
                bl = false;
                if (!Double.isNaN(d)) break block3;
            }
            String string = "Argument " + x2 + " is not a finite number";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAllFiniteReal(double[] values2) {
        int n = 0;
        int n2 = values2.length;
        while (n < n2) {
            void i;
            this.checkFinite(values2[i]);
            ++i;
        }
    }

    public LoessInterpolator(double bandwidth, int robustnessIters, double accuracy) {
        this.bandwidth = bandwidth;
        this.robustnessIters = robustnessIters;
        this.accuracy = accuracy;
        if (this.bandwidth <= 0.0 || this.bandwidth > 1.0) {
            String string = "Out of range of bandwidth value: " + this.bandwidth + " should be > 0 and <= 1";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.robustnessIters < 0) {
            String string = "Not positive Robutness iterationa: " + this.robustnessIters;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ LoessInterpolator(double d, int n, double d2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            d = 0.3;
        }
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            d2 = 1.0E-12;
        }
        this(d, n, d2);
    }

    public LoessInterpolator() {
        this(0.0, 0, 0.0, 7, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/LoessInterpolator$Companion;", "", "()V", "DEFAULT_ACCURACY", "", "DEFAULT_BANDWIDTH", "DEFAULT_ROBUSTNESS_ITERS", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

