/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.base.stat.CorrelationStat;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.base.stat.regression.RegressionUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00062\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\tJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\t\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/base/stat/CorrelationUtil;", "", "()V", "correlation", "", "lxs", "", "lys", "corrfn", "Lkotlin/Function2;", "", "correlationMatrix", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "type", "Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;", "plot-base-portable"})
public final class CorrelationUtil {
    public static final CorrelationUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final double correlation(@NotNull List<Double> lxs, @NotNull List<Double> lys, @NotNull Function2<? super double[], ? super double[], Double> corrfn) {
        void xs;
        Intrinsics.checkNotNullParameter(lxs, (String)"lxs");
        Intrinsics.checkNotNullParameter(lys, (String)"lys");
        Intrinsics.checkNotNullParameter(corrfn, (String)"corrfn");
        Pair<double[], double[]> pair2 = RegressionUtilKt.allFinite(lxs, lys);
        double[] dArray = (double[])pair2.component1();
        double[] ys = (double[])pair2.component2();
        return ((Number)corrfn.invoke((Object)xs, (Object)ys)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame correlationMatrix(@NotNull DataFrame data, @NotNull CorrelationStat.Type type, @NotNull Function2<? super double[], ? super double[], Double> corrfn) {
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(corrfn, (String)"corrfn");
        Iterable $this$filter$iv = data.variables();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv22 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            DataFrame.Variable it = (DataFrame.Variable)element$iv$iv;
            boolean bl = false;
            if (!DataFrameUtil.INSTANCE.isNumeric(data, it.getName())) continue;
            destination$iv$iv22.add(element$iv$iv);
        }
        List numerics = (List)destination$iv$iv22;
        $i$f$filter = false;
        ArrayList<String> var1 = new ArrayList<String>();
        boolean $this$filterTo$iv$iv2 = false;
        ArrayList<String> var2 = new ArrayList<String>();
        boolean destination$iv$iv22 = false;
        ArrayList<Double> corr = new ArrayList<Double>();
        destination$iv$iv22 = false;
        for (DataFrame.Variable vx : (Iterable)numerics) {
            void i;
            var1.add(vx.getLabel());
            var2.add(vx.getLabel());
            corr.add(1.0);
            List<Double> xs = data.getNumeric(vx);
            boolean it = false;
            void var13_18 = i;
            while (it < var13_18) {
                void j;
                DataFrame.Variable vy = (DataFrame.Variable)numerics.get((int)j);
                List<Double> ys = data.getNumeric(vy);
                double c = this.correlation(xs, ys, corrfn);
                if (type == CorrelationStat.Type.FULL || type == CorrelationStat.Type.LOWER) {
                    var1.add(vx.getLabel());
                    var2.add(vy.getLabel());
                    corr.add(c);
                }
                if (type == CorrelationStat.Type.FULL || type == CorrelationStat.Type.UPPER) {
                    var1.add(vy.getLabel());
                    var2.add(vx.getLabel());
                    corr.add(c);
                }
                ++j;
            }
            ++i;
        }
        return new DataFrame.Builder().putDiscrete(Stats.INSTANCE.getX(), (List)var1).putDiscrete(Stats.INSTANCE.getY(), (List)var2).putNumeric(Stats.INSTANCE.getCORR(), (List<Double>)corr).build();
    }

    private CorrelationUtil() {
    }

    static {
        CorrelationUtil correlationUtil;
        INSTANCE = correlationUtil = new CorrelationUtil();
    }
}

