/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.breaks;

import jetbrains.datalore.base.function.Function;
import jetbrains.datalore.base.numberFormat.NumberFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0002H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/base/scale/breaks/NumericBreakFormatter;", "Ljetbrains/datalore/base/function/Function;", "", "", "value", "", "step", "allowMetricPrefix", "", "(DDZ)V", "myFormatter", "Ljetbrains/datalore/base/numberFormat/NumberFormat;", "apply", "plot-base-portable"})
public final class NumericBreakFormatter
implements Function<Object, String> {
    private NumberFormat myFormatter;

    @Override
    @NotNull
    public String apply(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.myFormatter.apply((Number)value);
    }

    public NumericBreakFormatter(double value, double step, boolean allowMetricPrefix) {
        double step2 = step;
        String type = "f";
        String delimiter = "";
        if (value == 0.0) {
            this.myFormatter = new NumberFormat("d");
        } else {
            boolean bl = false;
            if ((step2 = Math.abs(step2)) == 0.0) {
                step2 = value / (double)10;
            }
            boolean bl2 = false;
            double domain10Power = Math.log10(value);
            boolean bl3 = false;
            double step10Power = Math.log10(step2);
            double precision = -step10Power;
            boolean scientificNotation = false;
            if (domain10Power < 0.0 && step10Power < (double)-4) {
                scientificNotation = true;
                type = "e";
                precision = domain10Power - step10Power;
            } else if (domain10Power > (double)7 && step10Power > (double)2) {
                scientificNotation = true;
                precision = domain10Power - step10Power;
            }
            if (precision < 0.0) {
                precision = 0.0;
                type = "d";
            }
            boolean bl4 = false;
            precision = Math.ceil(precision);
            if (scientificNotation) {
                type = domain10Power > 0.0 && allowMetricPrefix ? "s" : "e";
            } else {
                delimiter = ",";
            }
            this.myFormatter = new NumberFormat(delimiter + '.' + (int)precision + type);
        }
    }
}

