/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale;

import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.Transform;
import jetbrains.datalore.plot.base.scale.AbstractScale;
import jetbrains.datalore.plot.base.scale.transform.Transforms;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\"B/\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0015\b\u0012\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016R\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017\u00a8\u0006#"}, d2={"Ljetbrains/datalore/plot/base/scale/ContinuousScale;", "T", "Ljetbrains/datalore/plot/base/scale/AbstractScale;", "", "name", "", "mapper", "Lkotlin/Function1;", "continuousOutput", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Z)V", "b", "Ljetbrains/datalore/plot/base/scale/ContinuousScale$MyBuilder;", "(Ljetbrains/datalore/plot/base/scale/ContinuousScale$MyBuilder;)V", "defaultTransform", "Ljetbrains/datalore/plot/base/Transform;", "getDefaultTransform", "()Ljetbrains/datalore/plot/base/Transform;", "domainLimits", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "getDomainLimits", "()Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "isContinuous", "()Z", "isContinuousDomain", "asNumber", "input", "", "(Ljava/lang/Object;)Ljava/lang/Double;", "hasDomainLimits", "isInDomainLimits", "v", "with", "Ljetbrains/datalore/plot/base/Scale$Builder;", "MyBuilder", "plot-base-portable"})
public final class ContinuousScale<T>
extends AbstractScale<Double, T> {
    private final boolean isContinuous;
    private final boolean isContinuousDomain;
    @Nullable
    private final ClosedRange<Double> domainLimits;

    @Override
    public boolean isContinuous() {
        return this.isContinuous;
    }

    @Override
    public boolean isContinuousDomain() {
        return this.isContinuousDomain;
    }

    @Override
    @Nullable
    public ClosedRange<Double> getDomainLimits() {
        return this.domainLimits;
    }

    @Override
    @NotNull
    protected Transform getDefaultTransform() {
        return Transforms.INSTANCE.getIDENTITY();
    }

    @Override
    public boolean isInDomainLimits(@NotNull Object v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Object object = v;
        if (!(object instanceof Number)) {
            object = null;
        }
        Number number = (Number)object;
        if (number != null) {
            Number number2 = number;
            boolean bl = false;
            boolean bl2 = false;
            Number $this$run = number2;
            boolean bl3 = false;
            ClosedRange<Double> closedRange = this.getDomainLimits();
            return closedRange != null ? closedRange.contains((Double)((Comparable)Double.valueOf(((Number)v).doubleValue()))) : true;
        }
        return false;
    }

    @Override
    public boolean hasDomainLimits() {
        return this.getDomainLimits() != null;
    }

    @Override
    @Nullable
    public Double asNumber(@Nullable Object input) {
        if (input == null || input instanceof Double) {
            return (Double)input;
        }
        throw (Throwable)new IllegalArgumentException("Double is expected but was " + Reflection.getOrCreateKotlinClass(input.getClass()).getSimpleName() + " : " + input.toString());
    }

    @Override
    @NotNull
    public Scale.Builder<T> with() {
        return new MyBuilder(this);
    }

    public ContinuousScale(@NotNull String name, @NotNull Function1<? super Double, ? extends T> mapper2, boolean continuousOutput) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(mapper2, (String)"mapper");
        super(name, mapper2);
        this.isContinuousDomain = true;
        this.isContinuous = continuousOutput;
        this.domainLimits = null;
        this.setMultiplicativeExpand(0.05);
        this.setAdditiveExpand(0.0);
    }

    private ContinuousScale(MyBuilder<T> b) {
        super((AbstractScale.AbstractBuilder)b);
        ClosedRange<Comparable> closedRange;
        this.isContinuousDomain = true;
        this.isContinuous = b.getMyContinuousOutput$plot_base_portable();
        Double lower = b.getMyLowerLimit$plot_base_portable();
        Double upper = b.getMyUpperLimit$plot_base_portable();
        if (lower != null || upper != null) {
            Double d = lower;
            Double d2 = upper;
            closedRange = new ClosedRange<Comparable>(Double.valueOf(d != null ? d : Double.NEGATIVE_INFINITY), Double.valueOf(d2 != null ? d2 : Double.POSITIVE_INFINITY));
        } else {
            closedRange = null;
        }
        this.domainLimits = closedRange;
    }

    public /* synthetic */ ContinuousScale(MyBuilder b, DefaultConstructorMarker $constructor_marker) {
        this(b);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000f\u00a8\u0006 "}, d2={"Ljetbrains/datalore/plot/base/scale/ContinuousScale$MyBuilder;", "T", "Ljetbrains/datalore/plot/base/scale/AbstractScale$AbstractBuilder;", "", "scale", "Ljetbrains/datalore/plot/base/scale/ContinuousScale;", "(Ljetbrains/datalore/plot/base/scale/ContinuousScale;)V", "myContinuousOutput", "", "getMyContinuousOutput$plot_base_portable", "()Z", "myLowerLimit", "getMyLowerLimit$plot_base_portable", "()Ljava/lang/Double;", "setMyLowerLimit$plot_base_portable", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "myUpperLimit", "getMyUpperLimit$plot_base_portable", "setMyUpperLimit$plot_base_portable", "build", "Ljetbrains/datalore/plot/base/Scale;", "continuousTransform", "Ljetbrains/datalore/plot/base/Scale$Builder;", "v", "Ljetbrains/datalore/plot/base/Transform;", "limits", "domainValues", "", "", "lowerLimit", "upperLimit", "plot-base-portable"})
    private static final class MyBuilder<T>
    extends AbstractScale.AbstractBuilder<Double, T> {
        private final boolean myContinuousOutput;
        @Nullable
        private Double myLowerLimit;
        @Nullable
        private Double myUpperLimit;

        public final boolean getMyContinuousOutput$plot_base_portable() {
            return this.myContinuousOutput;
        }

        @Nullable
        public final Double getMyLowerLimit$plot_base_portable() {
            return this.myLowerLimit;
        }

        public final void setMyLowerLimit$plot_base_portable(@Nullable Double d) {
            this.myLowerLimit = d;
        }

        @Nullable
        public final Double getMyUpperLimit$plot_base_portable() {
            return this.myUpperLimit;
        }

        public final void setMyUpperLimit$plot_base_portable(@Nullable Double d) {
            this.myUpperLimit = d;
        }

        @Override
        @NotNull
        public Scale.Builder<T> lowerLimit(double v) {
            double d = v;
            boolean bl = false;
            boolean bl2 = !Double.isNaN(d);
            boolean bl3 = false;
            bl = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "`lower` can't be " + v;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.myLowerLimit = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder<T> upperLimit(double v) {
            double d = v;
            boolean bl = false;
            boolean bl2 = !Double.isNaN(d);
            boolean bl3 = false;
            bl = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "`upper` can't be " + v;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.myUpperLimit = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder<T> limits(@NotNull List<? extends Object> domainValues) {
            Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
            throw (Throwable)new IllegalArgumentException("Can't apply discrete limits to scale with continuous domain");
        }

        @Override
        @NotNull
        public Scale.Builder<T> continuousTransform(@NotNull Transform v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return this.transform(v);
        }

        @Override
        @NotNull
        public Scale<T> build() {
            return new ContinuousScale(this, null);
        }

        public MyBuilder(@NotNull ContinuousScale<T> scale) {
            Intrinsics.checkNotNullParameter(scale, (String)"scale");
            super((AbstractScale)scale);
            this.myContinuousOutput = scale.isContinuous();
            ClosedRange<Double> closedRange = scale.getDomainLimits();
            this.myLowerLimit = closedRange != null ? closedRange.getLowerEnd() : null;
            ClosedRange<Double> closedRange2 = scale.getDomainLimits();
            this.myUpperLimit = closedRange2 != null ? closedRange2.getUpperEnd() : null;
        }
    }
}

