/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.algorithms.GeometryKt;
import jetbrains.datalore.base.gcommon.collect.Ordering;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.Colors;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.aes.AestheticsUtil;
import jetbrains.datalore.plot.base.geom.StepGeom;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.LinesHelper;
import jetbrains.datalore.plot.base.geom.util.MultiPointData;
import jetbrains.datalore.plot.base.geom.util.MultiPointDataConstructor;
import jetbrains.datalore.plot.base.render.linetype.LineType;
import jetbrains.datalore.plot.base.render.svg.LinePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001:\u00013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJF\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00160\f2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00160\fJ0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00160\fJ1\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u001c\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\u001e\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u001fJ:\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00160\f2\u0006\u0010\u001e\u001a\u00020\nH\u0002J)\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\nH\u0004J\u0018\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0014H\u0002J$\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u001b2\u0012\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001b0\u0013H\u0002J\u000e\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\nJ\u001e\u0010/\u001a\u00020&2\u0016\u00100\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\fJ\u001e\u00101\u001a\u00020&2\u0016\u00102\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\fR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Ljetbrains/datalore/plot/base/geom/util/LinesHelper;", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "(Ljetbrains/datalore/plot/base/PositionAdjustment;Ljetbrains/datalore/plot/base/CoordinateSystem;Ljetbrains/datalore/plot/base/GeomContext;)V", "myAlphaEnabled", "", "myAlphaFilter", "Lkotlin/Function1;", "", "myWidthFilter", "createBands", "", "Ljetbrains/datalore/plot/base/render/svg/LinePath;", "dataPoints", "", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "toLocationUpper", "Ljetbrains/datalore/base/geometry/DoubleVector;", "toLocationLower", "createLines", "toLocation", "createPaths", "", "aes", "points", "closePath", "createPaths$plot_base_portable", "createSteps", "Ljetbrains/datalore/plot/base/geom/util/LinesHelper$PathInfo;", "dir", "Ljetbrains/datalore/plot/base/geom/StepGeom$Direction;", "createSteps$plot_base_portable", "decorate", "", "path", "p", "filled", "decorateFillingPart", "insertPathSeparators", "rings", "setAlphaEnabled", "b", "setAlphaFilter", "alphaFilter", "setWidthFilter", "widthFilter", "PathInfo", "plot-base-portable"})
public class LinesHelper
extends GeomHelper {
    private Function1<? super Double, Double> myAlphaFilter;
    private Function1<? super Double, Double> myWidthFilter;
    private boolean myAlphaEnabled;

    private final List<DoubleVector> insertPathSeparators(Iterable<? extends List<DoubleVector>> rings) {
        ArrayList<DoubleVector> result = new ArrayList<DoubleVector>();
        for (List<DoubleVector> list2 : rings) {
            if (!result.isEmpty()) {
                result.add(LinePath.Companion.getEND_OF_SUBPATH());
            }
            result.addAll((Collection)list2);
        }
        return result;
    }

    public final void setAlphaEnabled(boolean b) {
        this.myAlphaEnabled = b;
    }

    @NotNull
    public final List<LinePath> createLines(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocation) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocation, (String)"toLocation");
        return this.createPaths(dataPoints2, toLocation, false);
    }

    private final List<LinePath> createPaths(Iterable<? extends DataPointAesthetics> dataPoints2, Function1<? super DataPointAesthetics, DoubleVector> toLocation, boolean closePath) {
        ArrayList paths = new ArrayList();
        List<MultiPointData> multiPointDataList2 = MultiPointDataConstructor.INSTANCE.createMultiPointDataByGroup(dataPoints2, MultiPointDataConstructor.INSTANCE.singlePointAppender(this.toClientLocation$plot_base_portable((Function1<? super DataPointAesthetics, DoubleVector>)((Function1)new Function1<DataPointAesthetics, DoubleVector>(toLocation){
            final /* synthetic */ Function1 $toLocation;

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (DoubleVector)this.$toLocation.invoke((Object)it);
            }
            {
                this.$toLocation = function1;
                super(1);
            }
        }))), MultiPointDataConstructor.INSTANCE.reducer(0.999, closePath));
        for (MultiPointData multiPointData : multiPointDataList2) {
            paths.addAll(this.createPaths$plot_base_portable(multiPointData.getAes(), multiPointData.getPoints(), closePath));
        }
        return paths;
    }

    @NotNull
    public final List<LinePath> createPaths$plot_base_portable(@NotNull DataPointAesthetics aes, @NotNull List<DoubleVector> points2, boolean closePath) {
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        Intrinsics.checkNotNullParameter(points2, (String)"points");
        ArrayList<LinePath> paths = new ArrayList<LinePath>();
        if (closePath) {
            paths.add(LinePath.Companion.polygon((Iterable<DoubleVector>)this.insertPathSeparators((Iterable<? extends List<DoubleVector>>)GeometryKt.splitRings(points2))));
        } else {
            paths.add(LinePath.Companion.line((Iterable<DoubleVector>)points2));
        }
        Iterable $this$forEach$iv = paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LinePath path2 = (LinePath)element$iv;
            boolean bl = false;
            this.decorate(path2, aes, closePath);
        }
        return paths;
    }

    @NotNull
    public final List<PathInfo> createSteps$plot_base_portable(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull StepGeom.Direction dir) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter((Object)((Object)dir), (String)"dir");
        ArrayList<PathInfo> pathInfos = new ArrayList<PathInfo>();
        List<MultiPointData> multiPointDataList2 = MultiPointDataConstructor.INSTANCE.createMultiPointDataByGroup(dataPoints2, MultiPointDataConstructor.INSTANCE.singlePointAppender(this.toClientLocation$plot_base_portable(GeomUtil.INSTANCE.getTO_LOCATION_X_Y())), MultiPointDataConstructor.INSTANCE.reducer(0.999, false));
        for (MultiPointData multiPointData : multiPointDataList2) {
            List<DoubleVector> points2 = multiPointData.getPoints();
            if (points2.isEmpty()) continue;
            ArrayList<DoubleVector> newPoints = new ArrayList<DoubleVector>();
            DoubleVector prev = null;
            for (DoubleVector point2 : points2) {
                if (prev != null) {
                    double x2 = dir == StepGeom.Direction.HV ? point2.getX() : prev.getX();
                    double y2 = dir == StepGeom.Direction.HV ? prev.getY() : point2.getY();
                    newPoints.add(new DoubleVector(x2, y2));
                }
                newPoints.add(point2);
                prev = point2;
            }
            LinePath path2 = LinePath.Companion.line((Iterable<DoubleVector>)newPoints);
            this.decorate(path2, multiPointData.getAes(), false);
            pathInfos.add(new PathInfo(path2));
        }
        return pathInfos;
    }

    @NotNull
    public final List<LinePath> createBands(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationUpper, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationLower) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocationUpper, (String)"toLocationUpper");
        Intrinsics.checkNotNullParameter(toLocationLower, (String)"toLocationLower");
        ArrayList<LinePath> lines = new ArrayList<LinePath>();
        Map<Integer, List<DataPointAesthetics>> pointsByGroup = GeomUtil.INSTANCE.createGroups(dataPoints2);
        Iterator iterator2 = Ordering.Companion.natural().sortedCopy(pointsByGroup.keySet()).iterator();
        while (iterator2.hasNext()) {
            List<DataPointAesthetics> groupDataPoints;
            int group2 = ((Number)iterator2.next()).intValue();
            List<DataPointAesthetics> list2 = groupDataPoints = pointsByGroup.get(group2);
            Intrinsics.checkNotNull(list2);
            ArrayList points2 = new ArrayList(this.project((Iterable<? extends DataPointAesthetics>)list2, (Function1<? super DataPointAesthetics, DoubleVector>)((Function1)new Function1<DataPointAesthetics, DoubleVector>(toLocationUpper){
                final /* synthetic */ Function1 $toLocationUpper;

                @Nullable
                public final DoubleVector invoke(@NotNull DataPointAesthetics it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (DoubleVector)this.$toLocationUpper.invoke((Object)it);
                }
                {
                    this.$toLocationUpper = function1;
                    super(1);
                }
            })));
            List lowerPoints = CollectionsKt.reversed((Iterable)groupDataPoints);
            points2.addAll(this.project(lowerPoints, (Function1<? super DataPointAesthetics, DoubleVector>)((Function1)new Function1<DataPointAesthetics, DoubleVector>(toLocationLower){
                final /* synthetic */ Function1 $toLocationLower;

                @Nullable
                public final DoubleVector invoke(@NotNull DataPointAesthetics it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (DoubleVector)this.$toLocationLower.invoke((Object)it);
                }
                {
                    this.$toLocationLower = function1;
                    super(1);
                }
            })));
            if (points2.isEmpty()) continue;
            LinePath path2 = LinePath.Companion.polygon(points2);
            this.decorateFillingPart(path2, groupDataPoints.get(0));
            lines.add(path2);
        }
        return lines;
    }

    protected final void decorate(@NotNull LinePath path2, @NotNull DataPointAesthetics p, boolean filled) {
        Color stroke;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Color color = stroke = p.color();
        Intrinsics.checkNotNull((Object)color);
        Object object = this.myAlphaFilter.invoke((Object)AestheticsUtil.INSTANCE.alpha(color, p));
        Intrinsics.checkNotNull((Object)object);
        double strokeAlpha = ((Number)object).doubleValue();
        path2.color().set(Colors.INSTANCE.withOpacity(stroke, strokeAlpha));
        if (filled || !this.myAlphaEnabled) {
            path2.color().set(stroke);
        }
        if (filled) {
            this.decorateFillingPart(path2, p);
        }
        Object object2 = this.myWidthFilter.invoke((Object)AesScaling.INSTANCE.strokeWidth(p));
        Intrinsics.checkNotNull((Object)object2);
        double size2 = ((Number)object2).doubleValue();
        path2.width().set(size2);
        LineType lineType = p.lineType();
        if (!lineType.isBlank() && !lineType.isSolid()) {
            path2.dashArray().set(lineType.getDashArray());
        }
    }

    private final void decorateFillingPart(LinePath path2, DataPointAesthetics p) {
        Color fill2;
        Color color = fill2 = p.fill();
        Intrinsics.checkNotNull((Object)color);
        Object object = this.myAlphaFilter.invoke((Object)AestheticsUtil.INSTANCE.alpha(color, p));
        Intrinsics.checkNotNull((Object)object);
        double fillAlpha = ((Number)object).doubleValue();
        path2.fill().set(Colors.INSTANCE.withOpacity(fill2, fillAlpha));
    }

    public final void setAlphaFilter(@NotNull Function1<? super Double, Double> alphaFilter) {
        Intrinsics.checkNotNullParameter(alphaFilter, (String)"alphaFilter");
        this.myAlphaFilter = alphaFilter;
    }

    public final void setWidthFilter(@NotNull Function1<? super Double, Double> widthFilter) {
        Intrinsics.checkNotNullParameter(widthFilter, (String)"widthFilter");
        this.myWidthFilter = widthFilter;
    }

    public LinesHelper(@NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        super(pos, coord, ctx2);
        this.myAlphaFilter = myAlphaFilter.1.INSTANCE;
        this.myWidthFilter = myWidthFilter.1.INSTANCE;
        this.myAlphaEnabled = true;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/base/geom/util/LinesHelper$PathInfo;", "", "path", "Ljetbrains/datalore/plot/base/render/svg/LinePath;", "(Ljetbrains/datalore/plot/base/render/svg/LinePath;)V", "getPath", "()Ljetbrains/datalore/plot/base/render/svg/LinePath;", "plot-base-portable"})
    public static final class PathInfo {
        @NotNull
        private final LinePath path;

        @NotNull
        public final LinePath getPath() {
            return this.path;
        }

        public PathInfo(@NotNull LinePath path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.path = path2;
        }
    }
}

