/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom.util;

import java.util.HashMap;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.HintsCollection$WhenMappings;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0010\u001a\u00020\u00002\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013J\u001c\u0010\u0014\u001a\u00020\n2\n\u0010\u0011\u001a\u00060\u0012R\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0002R!\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\u000ej\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/base/geom/util/HintsCollection;", "", "myPoint", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "myHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "(Ljetbrains/datalore/plot/base/DataPointAesthetics;Ljetbrains/datalore/plot/base/geom/util/GeomHelper;)V", "hints", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/interact/TipLayoutHint;", "getHints", "()Ljava/util/Map;", "myHints", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "addHint", "hintConfig", "Ljetbrains/datalore/plot/base/geom/util/HintsCollection$HintConfigFactory$HintConfig;", "Ljetbrains/datalore/plot/base/geom/util/HintsCollection$HintConfigFactory;", "createHint", "coord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getCoord", "HintConfigFactory", "plot-base-portable"})
public final class HintsCollection {
    private final HashMap<Aes<?>, TipLayoutHint> myHints;
    private final DataPointAesthetics myPoint;
    private final GeomHelper myHelper;

    @NotNull
    public final Map<Aes<?>, TipLayoutHint> getHints() {
        return this.myHints;
    }

    @NotNull
    public final HintsCollection addHint(@NotNull HintConfigFactory.HintConfig hintConfig) {
        Intrinsics.checkNotNullParameter((Object)hintConfig, (String)"hintConfig");
        DoubleVector coord = this.getCoord(hintConfig);
        if (coord != null) {
            this.getHints().put(hintConfig.getAes(), this.createHint(hintConfig, coord));
        }
        return this;
    }

    private final DoubleVector getCoord(HintConfigFactory.HintConfig hintConfig) {
        DoubleVector doubleVector;
        if (hintConfig.getX() == null) {
            throw (Throwable)new IllegalArgumentException("x coord is not set");
        }
        Aes<Double> aes = hintConfig.getAes();
        if (!this.myPoint.defined(aes)) {
            doubleVector = null;
        } else {
            Double d = hintConfig.getX();
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = this.myPoint.get(aes);
            Intrinsics.checkNotNull((Object)d3);
            doubleVector = this.myHelper.toClient(new DoubleVector(d2, ((Number)d3).doubleValue()), this.myPoint);
        }
        return doubleVector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final TipLayoutHint createHint(HintConfigFactory.HintConfig hintConfig, DoubleVector coord) {
        Double objectRadius = hintConfig.getObjectRadius();
        Color color = hintConfig.getColor$plot_base_portable();
        if (objectRadius == null) {
            throw (Throwable)new IllegalArgumentException("object radius is not set");
        }
        TipLayoutHint.Kind kind = hintConfig.getKind();
        if (kind == null) throw (Throwable)new IllegalArgumentException("Unknown hint kind: " + (Object)((Object)hintConfig.getKind()));
        switch (HintsCollection$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                TipLayoutHint tipLayoutHint = TipLayoutHint.Companion.verticalTooltip$default(TipLayoutHint.Companion, coord, objectRadius, color, null, 8, null);
                return tipLayoutHint;
            }
            case 2: {
                TipLayoutHint tipLayoutHint = TipLayoutHint.Companion.horizontalTooltip$default(TipLayoutHint.Companion, coord, objectRadius, color, null, 8, null);
                return tipLayoutHint;
            }
            case 3: {
                TipLayoutHint tipLayoutHint = TipLayoutHint.Companion.cursorTooltip$default(TipLayoutHint.Companion, coord, color, null, 4, null);
                return tipLayoutHint;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unknown hint kind: " + (Object)((Object)hintConfig.getKind()));
            }
        }
    }

    public HintsCollection(@NotNull DataPointAesthetics myPoint, @NotNull GeomHelper myHelper) {
        Intrinsics.checkNotNullParameter((Object)myPoint, (String)"myPoint");
        Intrinsics.checkNotNullParameter((Object)myHelper, (String)"myHelper");
        this.myPoint = myPoint;
        this.myHelper = myHelper;
        this.myHints = new HashMap();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00060\fR\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eJ\u001d\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/base/geom/util/HintsCollection$HintConfigFactory;", "", "()V", "myDefaultColor", "Ljetbrains/datalore/base/values/Color;", "myDefaultKind", "Ljetbrains/datalore/plot/base/interact/TipLayoutHint$Kind;", "myDefaultObjectRadius", "", "Ljava/lang/Double;", "myDefaultX", "create", "Ljetbrains/datalore/plot/base/geom/util/HintsCollection$HintConfigFactory$HintConfig;", "aes", "Ljetbrains/datalore/plot/base/Aes;", "defaultColor", "v", "alpha", "(Ljetbrains/datalore/base/values/Color;Ljava/lang/Double;)Ljetbrains/datalore/plot/base/geom/util/HintsCollection$HintConfigFactory;", "defaultKind", "kind", "defaultObjectRadius", "defaultX", "HintConfig", "plot-base-portable"})
    public static final class HintConfigFactory {
        private Double myDefaultObjectRadius;
        private Double myDefaultX;
        private Color myDefaultColor;
        private TipLayoutHint.Kind myDefaultKind;

        @NotNull
        public final HintConfigFactory defaultObjectRadius(double defaultObjectRadius) {
            this.myDefaultObjectRadius = defaultObjectRadius;
            return this;
        }

        @NotNull
        public final HintConfigFactory defaultX(double defaultX) {
            this.myDefaultX = defaultX;
            return this;
        }

        @NotNull
        public final HintConfigFactory defaultColor(@NotNull Color v, @Nullable Double alpha) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.myDefaultColor = alpha != null ? v.changeAlpha((int)((double)255 * alpha)) : v;
            return this;
        }

        @NotNull
        public final HintConfig create(@NotNull Aes<Double> aes) {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            return new HintConfig(aes);
        }

        @NotNull
        public final HintConfigFactory defaultKind(@NotNull TipLayoutHint.Kind kind) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            this.myDefaultKind = kind;
            return this;
        }

        public static final /* synthetic */ void access$setMyDefaultObjectRadius$p(HintConfigFactory $this, Double d) {
            $this.myDefaultObjectRadius = d;
        }

        public static final /* synthetic */ void access$setMyDefaultX$p(HintConfigFactory $this, Double d) {
            $this.myDefaultX = d;
        }

        public static final /* synthetic */ void access$setMyDefaultKind$p(HintConfigFactory $this, TipLayoutHint.Kind kind) {
            $this.myDefaultKind = kind;
        }

        public static final /* synthetic */ void access$setMyDefaultColor$p(HintConfigFactory $this, Color color) {
            $this.myDefaultColor = color;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\n\u001a\u00060\u0000R\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tJ\u0012\u0010\u0011\u001a\u00060\u0000R\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004J\u0012\u0010\u0015\u001a\u00060\u0000R\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/base/geom/util/HintsCollection$HintConfigFactory$HintConfig;", "", "aes", "Ljetbrains/datalore/plot/base/Aes;", "", "(Ljetbrains/datalore/plot/base/geom/util/HintsCollection$HintConfigFactory;Ljetbrains/datalore/plot/base/Aes;)V", "getAes", "()Ljetbrains/datalore/plot/base/Aes;", "<set-?>", "Ljetbrains/datalore/base/values/Color;", "color", "getColor$plot_base_portable", "()Ljetbrains/datalore/base/values/Color;", "kind", "Ljetbrains/datalore/plot/base/interact/TipLayoutHint$Kind;", "getKind", "()Ljetbrains/datalore/plot/base/interact/TipLayoutHint$Kind;", "objectRadius", "getObjectRadius", "()Ljava/lang/Double;", "Ljava/lang/Double;", "x", "getX", "Ljetbrains/datalore/plot/base/geom/util/HintsCollection$HintConfigFactory;", "v", "plot-base-portable"})
        public final class HintConfig {
            @Nullable
            private final TipLayoutHint.Kind kind;
            @Nullable
            private Double objectRadius;
            @Nullable
            private Double x;
            @Nullable
            private Color color;
            @NotNull
            private final Aes<Double> aes;

            @Nullable
            public final TipLayoutHint.Kind getKind() {
                return this.kind;
            }

            @Nullable
            public final Double getObjectRadius() {
                return this.objectRadius;
            }

            @Nullable
            public final Double getX() {
                return this.x;
            }

            @Nullable
            public final Color getColor$plot_base_portable() {
                return this.color;
            }

            @NotNull
            public final HintConfig objectRadius(double v) {
                this.objectRadius = v;
                return this;
            }

            @NotNull
            public final HintConfig x(double v) {
                this.x = v;
                return this;
            }

            @NotNull
            public final HintConfig color(@NotNull Color v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                this.color = v;
                return this;
            }

            @NotNull
            public final Aes<Double> getAes() {
                return this.aes;
            }

            public HintConfig(Aes<Double> aes) {
                Intrinsics.checkNotNullParameter(aes, (String)"aes");
                this.aes = aes;
                this.objectRadius = HintConfigFactory.this.myDefaultObjectRadius;
                this.x = HintConfigFactory.this.myDefaultX;
                this.kind = HintConfigFactory.this.myDefaultKind;
                this.color = HintConfigFactory.this.myDefaultColor;
            }
        }
    }
}

