/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.gcommon.base.Strings;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.aes.AestheticsUtil;
import jetbrains.datalore.plot.base.geom.util.GeomCoord;
import jetbrains.datalore.plot.base.render.linetype.LineType;
import jetbrains.datalore.plot.base.render.svg.StrokeDashArraySupport;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgShape;
import jetbrains.datalore.vis.svg.slim.SvgSlimShape;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u0016\u0018\u0000 )2\u00020\u0001:\u0002)*B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\r\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001dH\u0004J\u0016\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J'\u0010\u001e\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\"J\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\u0010\u001a\u00020\u0011J1\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001d2\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001dH\u0000\u00a2\u0006\u0002\b&J-\u0010'\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001dH\u0000\u00a2\u0006\u0002\b(R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "", "myPos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "(Ljetbrains/datalore/plot/base/PositionAdjustment;Ljetbrains/datalore/plot/base/CoordinateSystem;Ljetbrains/datalore/plot/base/GeomContext;)V", "getCtx", "()Ljetbrains/datalore/plot/base/GeomContext;", "myGeomCoord", "Ljetbrains/datalore/plot/base/geom/util/GeomCoord;", "adjust", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "r", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "pos", "Ljetbrains/datalore/base/geometry/DoubleVector;", "location", "createSvgElementHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper$SvgElementHelper;", "fromClient", "project", "", "dataPoints", "", "projection", "Lkotlin/Function1;", "toClient", "x", "", "y", "(Ljava/lang/Double;Ljava/lang/Double;Ljetbrains/datalore/plot/base/DataPointAesthetics;)Ljetbrains/datalore/base/geometry/DoubleVector;", "locations", "toClientLocation", "aesMapper", "toClientLocation$plot_base_portable", "toClientRect", "toClientRect$plot_base_portable", "Companion", "SvgElementHelper", "plot-base-portable"})
public class GeomHelper {
    private final GeomCoord myGeomCoord;
    private final PositionAdjustment myPos;
    @NotNull
    private final GeomContext ctx;
    @NotNull
    private static final Map<Object, TextLabel.HorizontalAnchor> HJUST_MAP;
    @NotNull
    private static final Map<Object, TextLabel.VerticalAnchor> VJUST_MAP;
    private static final Set<String> FONT_WEIGHT_SET;
    private static final Set<String> FONT_STYLE_SET;
    private static final Map<String, String> FONT_FAMILY_MAP;
    public static final Companion Companion;

    @NotNull
    public final DoubleVector toClient(@NotNull DoubleVector location, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.myGeomCoord.toClient(this.adjust(location, p, this.myPos, this.ctx));
    }

    @NotNull
    public final DoubleVector toClient(@Nullable Double x2, @Nullable Double y2, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Double d = x2;
        Intrinsics.checkNotNull((Object)d);
        double d2 = d;
        Double d3 = y2;
        Intrinsics.checkNotNull((Object)d3);
        DoubleVector location = new DoubleVector(d2, d3);
        return this.myGeomCoord.toClient(this.adjust(location, p, this.myPos, this.ctx));
    }

    @NotNull
    public final DoubleRectangle toClient(@NotNull DoubleRectangle r, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleRectangle clientRect = this.myGeomCoord.toClient(this.adjust(r, p, this.myPos, this.ctx));
        if (clientRect.getWidth() == 0.0) {
            clientRect = new DoubleRectangle(clientRect.getOrigin().getX(), clientRect.getOrigin().getY(), 0.1, clientRect.getHeight());
        }
        if (clientRect.getHeight() == 0.0) {
            clientRect = new DoubleRectangle(clientRect.getOrigin().getX(), clientRect.getOrigin().getY(), clientRect.getWidth(), 0.1);
        }
        return clientRect;
    }

    @NotNull
    public final DoubleVector fromClient(@NotNull DoubleVector location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.myGeomCoord.fromClient$plot_base_portable(location);
    }

    private final DoubleVector adjust(DoubleVector location, DataPointAesthetics p, PositionAdjustment pos, GeomContext ctx2) {
        return pos.translate(location, p, ctx2);
    }

    @Nullable
    public final DoubleRectangle toClientRect$plot_base_portable(@NotNull DataPointAesthetics p, @NotNull Function1<? super DataPointAesthetics, DoubleRectangle> aesMapper) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(aesMapper, (String)"aesMapper");
        DoubleRectangle doubleRectangle = (DoubleRectangle)aesMapper.invoke((Object)p);
        if (doubleRectangle == null) {
            return null;
        }
        DoubleRectangle r = doubleRectangle;
        return this.toClient(r, p);
    }

    private final DoubleRectangle adjust(DoubleRectangle r, DataPointAesthetics p, PositionAdjustment pos, GeomContext ctx2) {
        DoubleVector leftTop = pos.translate(r.getOrigin(), p, ctx2);
        DoubleVector rightBottom = pos.translate(r.getOrigin().add(r.getDimension()), p, ctx2);
        return DoubleRectangle.Companion.span(leftTop, rightBottom);
    }

    @NotNull
    protected final List<DoubleVector> project(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> projection) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(projection, (String)"projection");
        ArrayList<DoubleVector> points2 = new ArrayList<DoubleVector>();
        for (DataPointAesthetics dataPointAesthetics : dataPoints2) {
            DoubleVector location = (DoubleVector)projection.invoke((Object)dataPointAesthetics);
            if (location == null) continue;
            DoubleVector pp = this.toClient(location, dataPointAesthetics);
            points2.add(pp);
        }
        return points2;
    }

    @NotNull
    public final Function1<DataPointAesthetics, DoubleVector> toClientLocation$plot_base_portable(@NotNull Function1<? super DataPointAesthetics, DoubleVector> aesMapper) {
        Intrinsics.checkNotNullParameter(aesMapper, (String)"aesMapper");
        return (Function1)new Function1<DataPointAesthetics, DoubleVector>(this, aesMapper){
            final /* synthetic */ GeomHelper this$0;
            final /* synthetic */ Function1 $aesMapper;

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics aes) {
                Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
                DoubleVector location = (DoubleVector)this.$aesMapper.invoke((Object)aes);
                return location != null ? this.this$0.toClient(location, aes) : null;
            }
            {
                this.this$0 = geomHelper;
                this.$aesMapper = function1;
                super(1);
            }
        };
    }

    @NotNull
    public final SvgElementHelper createSvgElementHelper() {
        return new SvgElementHelper();
    }

    @NotNull
    public final List<DoubleVector> toClient(@NotNull List<DoubleVector> locations, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        ArrayList<DoubleVector> localLocations = new ArrayList<DoubleVector>();
        for (DoubleVector location : locations) {
            localLocations.add(this.toClient(location, p));
        }
        return localLocations;
    }

    @NotNull
    protected final GeomContext getCtx() {
        return this.ctx;
    }

    public GeomHelper(@NotNull PositionAdjustment myPos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)myPos, (String)"myPos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        this.myPos = myPos;
        this.ctx = ctx2;
        this.myGeomCoord = new GeomCoord(coord);
    }

    static {
        Companion = new Companion(null);
        HJUST_MAP = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"right", (Object)((Object)TextLabel.HorizontalAnchor.RIGHT)), TuplesKt.to((Object)"middle", (Object)((Object)TextLabel.HorizontalAnchor.MIDDLE)), TuplesKt.to((Object)"left", (Object)((Object)TextLabel.HorizontalAnchor.LEFT)), TuplesKt.to((Object)0.0, (Object)((Object)TextLabel.HorizontalAnchor.RIGHT)), TuplesKt.to((Object)0.5, (Object)((Object)TextLabel.HorizontalAnchor.MIDDLE)), TuplesKt.to((Object)1.0, (Object)((Object)TextLabel.HorizontalAnchor.LEFT))});
        VJUST_MAP = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"bottom", (Object)((Object)TextLabel.VerticalAnchor.BOTTOM)), TuplesKt.to((Object)"center", (Object)((Object)TextLabel.VerticalAnchor.CENTER)), TuplesKt.to((Object)"top", (Object)((Object)TextLabel.VerticalAnchor.TOP)), TuplesKt.to((Object)0.0, (Object)((Object)TextLabel.VerticalAnchor.BOTTOM)), TuplesKt.to((Object)0.5, (Object)((Object)TextLabel.VerticalAnchor.CENTER)), TuplesKt.to((Object)1.0, (Object)((Object)TextLabel.VerticalAnchor.TOP))});
        FONT_WEIGHT_SET = SetsKt.setOf((Object[])new String[]{"bold", "bolder", "lighter"});
        FONT_STYLE_SET = SetsKt.setOf((Object[])new String[]{"italic", "oblique"});
        FONT_FAMILY_MAP = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"sans", (Object)"sans-serif"), TuplesKt.to((Object)"serif", (Object)"serif"), TuplesKt.to((Object)"mono", (Object)"monospace")});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/base/geom/util/GeomHelper$SvgElementHelper;", "", "(Ljetbrains/datalore/plot/base/geom/util/GeomHelper;)V", "createLine", "Ljetbrains/datalore/vis/svg/SvgLineElement;", "start", "Ljetbrains/datalore/base/geometry/DoubleVector;", "end", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "plot-base-portable"})
    public final class SvgElementHelper {
        @NotNull
        public final SvgLineElement createLine(@NotNull DoubleVector start, @NotNull DoubleVector end, @NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            DoubleVector start2 = GeomHelper.this.toClient(start, p);
            DoubleVector end2 = GeomHelper.this.toClient(end, p);
            SvgLineElement line2 = new SvgLineElement(start2.getX(), start2.getY(), end2.getX(), end2.getY());
            Companion.decorate(line2, p);
            return line2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001d\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170!2\u0006\u0010\"\u001a\u00020\u0005J5\u0010#\u001a\u0002H$\"\u0004\b\u0000\u0010$2\u0006\u0010%\u001a\u00020\u00012\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H$0\u00042\u0006\u0010'\u001a\u0002H$\u00a2\u0006\u0002\u0010(R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006)"}, d2={"Ljetbrains/datalore/plot/base/geom/util/GeomHelper$Companion;", "", "()V", "FONT_FAMILY_MAP", "", "", "FONT_STYLE_SET", "", "FONT_WEIGHT_SET", "HJUST_MAP", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "getHJUST_MAP", "()Ljava/util/Map;", "VJUST_MAP", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "getVJUST_MAP", "decorate", "", "label", "Ljetbrains/datalore/plot/base/render/svg/TextLabel;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "scale", "", "node", "Ljetbrains/datalore/vis/svg/SvgNode;", "decorateShape", "shape", "Ljetbrains/datalore/vis/svg/SvgShape;", "decorateSlimShape", "Ljetbrains/datalore/vis/svg/slim/SvgSlimShape;", "decorateSlimShape$plot_base_portable", "getSizeUnitAes", "Ljetbrains/datalore/plot/base/Aes;", "sizeUnitName", "textLabelAnchor", "T", "o", "conversionMap", "def", "(Ljava/lang/Object;Ljava/util/Map;Ljava/lang/Object;)Ljava/lang/Object;", "plot-base-portable"})
    public static final class Companion {
        @NotNull
        public final Map<Object, TextLabel.HorizontalAnchor> getHJUST_MAP() {
            return HJUST_MAP;
        }

        @NotNull
        public final Map<Object, TextLabel.VerticalAnchor> getVJUST_MAP() {
            return VJUST_MAP;
        }

        public final void decorate(@NotNull TextLabel label, @NotNull DataPointAesthetics p, double scale) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            label.textColor().set(p.color());
            label.textOpacity().set(p.alpha());
            label.setFontSize(AesScaling.INSTANCE.textSize(p) * scale);
            String family = p.family();
            if (FONT_FAMILY_MAP.containsKey(family)) {
                Object v = FONT_FAMILY_MAP.get(family);
                Intrinsics.checkNotNull(v);
                family = (String)v;
            }
            label.setFontFamily(family);
            String fontface = p.fontface();
            if (!Strings.INSTANCE.isNullOrEmpty(fontface)) {
                List list2;
                CharSequence charSequence = fontface;
                String string = " ";
                int n = 0;
                string = new Regex(string);
                n = 0;
                boolean bl = false;
                List $this$dropLastWhile$iv = string.split(charSequence, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        CharSequence charSequence2 = it;
                        boolean bl3 = false;
                        if (charSequence2.length() == 0) continue;
                        list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                for (String s2 : stringArray) {
                    if (FONT_WEIGHT_SET.contains(s2)) {
                        label.setFontWeight(s2);
                        continue;
                    }
                    if (!FONT_STYLE_SET.contains(s2)) continue;
                    label.setFontStyle(s2);
                }
            }
            TextLabel.HorizontalAnchor hAnchor = this.textLabelAnchor(p.hjust(), this.getHJUST_MAP(), TextLabel.HorizontalAnchor.MIDDLE);
            TextLabel.VerticalAnchor vAnchor = this.textLabelAnchor(p.vjust(), this.getVJUST_MAP(), TextLabel.VerticalAnchor.CENTER);
            if (hAnchor != TextLabel.HorizontalAnchor.LEFT) {
                label.setHorizontalAnchor(hAnchor);
            }
            if (vAnchor != TextLabel.VerticalAnchor.BOTTOM) {
                label.setVerticalAnchor(vAnchor);
            }
            Double d = p.angle();
            Intrinsics.checkNotNull((Object)d);
            double angle = d;
            if (angle != 0.0) {
                angle = (double)360 - angle % (double)360;
                label.rotate(angle);
            }
        }

        public static /* synthetic */ void decorate$default(Companion companion, TextLabel textLabel, DataPointAesthetics dataPointAesthetics, double d, int n, Object object) {
            if ((n & 4) != 0) {
                d = 1.0;
            }
            companion.decorate(textLabel, dataPointAesthetics, d);
        }

        public final <T> T textLabelAnchor(@NotNull Object o, @NotNull Map<Object, ? extends T> conversionMap, T def) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            Intrinsics.checkNotNullParameter(conversionMap, (String)"conversionMap");
            Map<Object, T> map2 = conversionMap;
            boolean bl = false;
            T t = map2.get(o);
            if (t == null) {
                boolean bl2 = false;
                t = def;
            }
            return t;
        }

        public final void decorate(@NotNull SvgNode node, @NotNull DataPointAesthetics p) {
            LineType lineType;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            if (node instanceof SvgShape) {
                this.decorateShape((SvgShape)((Object)node), p);
            }
            if (node instanceof SvgElement && !(lineType = p.lineType()).isBlank() && !lineType.isSolid()) {
                StrokeDashArraySupport.INSTANCE.apply((SvgElement)node, AesScaling.INSTANCE.strokeWidth(p), lineType.getDashArray());
            }
        }

        private final void decorateShape(SvgShape shape, DataPointAesthetics p) {
            AestheticsUtil.INSTANCE.updateStroke(shape, p);
            AestheticsUtil.INSTANCE.updateFill(shape, p);
            shape.strokeWidth().set(AesScaling.INSTANCE.strokeWidth(p));
        }

        public final void decorateSlimShape$plot_base_portable(@NotNull SvgSlimShape shape, @NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Color color = p.color();
            Intrinsics.checkNotNull((Object)color);
            Color stroke = color;
            double strokeAlpha = AestheticsUtil.INSTANCE.alpha(stroke, p);
            Color color2 = p.fill();
            Intrinsics.checkNotNull((Object)color2);
            Color fill2 = color2;
            double fillAlpha = AestheticsUtil.INSTANCE.alpha(fill2, p);
            shape.setFill(fill2, fillAlpha);
            shape.setStroke(stroke, strokeAlpha);
            shape.setStrokeWidth(AesScaling.INSTANCE.strokeWidth(p));
        }

        @NotNull
        public final Aes<Double> getSizeUnitAes(@NotNull String sizeUnitName) {
            Aes<Double> aes;
            Intrinsics.checkNotNullParameter((Object)sizeUnitName, (String)"sizeUnitName");
            String string = sizeUnitName;
            boolean bl = false;
            String string2 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            switch (string2) {
                case "x": {
                    aes = Aes.Companion.getX();
                    break;
                }
                case "y": {
                    aes = Aes.Companion.getY();
                    break;
                }
                default: {
                    String string3 = "Size unit value must be either 'x' or 'y', but was " + sizeUnitName + '.';
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
            }
            return aes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

