/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import jetbrains.datalore.base.gcommon.base.Strings;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.stringFormat.StringFormat;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.TextLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010$\u001a\u00020\u000e2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006("}, d2={"Ljetbrains/datalore/plot/base/geom/TextGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "formatter", "Ljetbrains/datalore/base/stringFormat/StringFormat;", "getFormatter", "()Ljetbrains/datalore/base/stringFormat/StringFormat;", "setFormatter", "(Ljetbrains/datalore/base/stringFormat/StringFormat;)V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "naValue", "", "getNaValue", "()Ljava/lang/String;", "setNaValue", "(Ljava/lang/String;)V", "sizeUnit", "getSizeUnit", "setSizeUnit", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "getSizeUnitRatio", "", "toString", "label", "", "Companion", "plot-base-portable"})
public final class TextGeom
extends GeomBase {
    @Nullable
    private StringFormat formatter;
    @NotNull
    private String naValue = "n/a";
    @Nullable
    private String sizeUnit;
    @NotNull
    public static final String DEF_NA_VALUE = "n/a";
    public static final boolean HANDLES_GROUPS = false;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final StringFormat getFormatter() {
        return this.formatter;
    }

    public final void setFormatter(@Nullable StringFormat stringFormat) {
        this.formatter = stringFormat;
    }

    @NotNull
    public final String getNaValue() {
        return this.naValue;
    }

    public final void setNaValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.naValue = string;
    }

    @Nullable
    public final String getSizeUnit() {
        return this.sizeUnit;
    }

    public final void setSizeUnit(@Nullable String string) {
        this.sizeUnit = string;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new TextLegendKeyElementFactory();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper helper = new GeomHelper(pos, coord, ctx2);
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx2);
        for (DataPointAesthetics p : aesthetics.dataPoints()) {
            Double x2 = p.x();
            Double y2 = p.y();
            String text = this.toString(p.label());
            if (!SeriesUtil.INSTANCE.allFinite(x2, y2) || Strings.INSTANCE.isNullOrEmpty(text)) continue;
            TextLabel label = new TextLabel(text);
            GeomHelper.Companion.decorate(label, p, this.getSizeUnitRatio(ctx2));
            DoubleVector loc = helper.toClient(x2, y2, p);
            label.moveTo(loc);
            root.add(label.getRootGroup());
            GeomTargetCollector.DefaultImpls.addPoint$default(targetCollector, p.index(), loc, AesScaling.INSTANCE.textSize(p) / (double)2, GeomTargetCollector.TooltipParams.Companion.params().setColor(HintColorUtil.INSTANCE.fromColor(p)).setStemLength(TipLayoutHint.StemLength.NONE), null, 16, null);
        }
    }

    private final double getSizeUnitRatio(GeomContext ctx2) {
        double d;
        if (this.sizeUnit != null) {
            double textWidth = 6.0;
            String string = this.sizeUnit;
            Intrinsics.checkNotNull((Object)string);
            double unitRes = ctx2.getUnitResolution(GeomHelper.Companion.getSizeUnitAes(string));
            d = unitRes / textWidth;
        } else {
            d = 1.0;
        }
        return d;
    }

    private final String toString(Object label) {
        String string;
        if (label == null) {
            string = this.naValue;
        } else if (this.formatter != null) {
            StringFormat stringFormat = this.formatter;
            Intrinsics.checkNotNull((Object)stringFormat);
            string = stringFormat.format(label);
        } else {
            string = label.toString();
        }
        return string;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/base/geom/TextGeom$Companion;", "", "()V", "DEF_NA_VALUE", "", "HANDLES_GROUPS", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

