/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.geom.util.HintsCollection;
import jetbrains.datalore.plot.base.geom.util.LinesHelper;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/base/geom/ErrorBarGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "buildHints", "", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "geomHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "buildIntern", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "dataPoints", "", "Companion", "MyLegendKeyElementFactory", "plot-base-portable"})
public final class ErrorBarGeom
extends GeomBase {
    public static final boolean HANDLES_GROUPS = false;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new MyLegendKeyElementFactory();
    }

    private final Iterable<DataPointAesthetics> dataPoints(Aesthetics aesthetics) {
        return GeomUtil.INSTANCE.with_X(aesthetics.dataPoints());
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        LinesHelper helper = new LinesHelper(pos, coord, ctx2);
        Iterable<DataPointAesthetics> dataPoints2 = this.dataPoints(aesthetics);
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        for (DataPointAesthetics p : dataPoints2) {
            Double ymax;
            Double ymin;
            Double x2 = p.x();
            if (!SeriesUtil.INSTANCE.allFinite(x2, ymin = p.ymin(), ymax = p.ymax())) continue;
            Double d = p.width();
            Intrinsics.checkNotNull((Object)d);
            double width2 = d;
            width2 *= ctx2.getResolution(Aes.Companion.getX());
            Double d2 = ymax;
            Intrinsics.checkNotNull((Object)d2);
            double d3 = d2;
            Double d4 = ymin;
            Intrinsics.checkNotNull((Object)d4);
            double height = d3 - d4;
            Double d5 = x2;
            Intrinsics.checkNotNull((Object)d5);
            DoubleRectangle r = new DoubleRectangle(d5 - width2 / (double)2, ymin, width2, height);
            SvgGElement g = ErrorBarGeom.Companion.errorBarShape(helper.toClient(r, p), p);
            root.add(g);
            this.buildHints(new DoubleRectangle(r.getCenter(), new DoubleVector(width2, 0.0)), p, ctx2, geomHelper);
        }
    }

    private final void buildHints(DoubleRectangle rect2, DataPointAesthetics p, GeomContext ctx2, GeomHelper geomHelper) {
        DoubleRectangle clientRect = geomHelper.toClient(rect2, p);
        HintsCollection.HintConfigFactory hintConfigFactory = new HintsCollection.HintConfigFactory().defaultObjectRadius(clientRect.getWidth() / 2.0);
        Double d = p.x();
        Intrinsics.checkNotNull((Object)d);
        HintsCollection.HintConfigFactory hint = hintConfigFactory.defaultX(d).defaultKind(TipLayoutHint.Kind.HORIZONTAL_TOOLTIP);
        Map<Aes<?>, TipLayoutHint> hints = new HintsCollection(p, geomHelper).addHint(hint.create(Aes.Companion.getYMAX())).addHint(hint.create(Aes.Companion.getYMIN())).getHints();
        GeomTargetCollector.DefaultImpls.addRectangle$default(ctx2.getTargetCollector(), p.index(), clientRect, GeomTargetCollector.TooltipParams.Companion.params().setTipLayoutHints(hints).setColor(HintColorUtil.INSTANCE.fromColor(p)), null, 8, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/geom/ErrorBarGeom$MyLegendKeyElementFactory;", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "()V", "createKeyElement", "Ljetbrains/datalore/vis/svg/SvgGElement;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "size", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plot-base-portable"})
    private static final class MyLegendKeyElementFactory
    implements LegendKeyElementFactory {
        @Override
        @NotNull
        public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size2) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            double strokeWidth = AesScaling.INSTANCE.strokeWidth(p);
            Double d = p.width();
            Intrinsics.checkNotNull((Object)d);
            double width2 = d * (size2.getX() - strokeWidth);
            double height = size2.getY() - strokeWidth;
            double x2 = (size2.getX() - width2) / (double)2;
            double y2 = strokeWidth / (double)2;
            return Companion.errorBarShape(new DoubleRectangle(x2, y2, width2, height), p);
        }

        @Override
        @NotNull
        public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return LegendKeyElementFactory.DefaultImpls.minimumKeySize(this, p);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/base/geom/ErrorBarGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "errorBarShape", "Ljetbrains/datalore/vis/svg/SvgGElement;", "r", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "plot-base-portable"})
    public static final class Companion {
        private final SvgGElement errorBarShape(DoubleRectangle r, DataPointAesthetics p) {
            double left = r.getLeft();
            double top = r.getTop();
            double right = r.getRight();
            double bottom = r.getBottom();
            double center = left + r.getWidth() / (double)2;
            ArrayList<SvgLineElement> shapeLines = new ArrayList<SvgLineElement>();
            shapeLines.add(new SvgLineElement(left, top, right, top));
            shapeLines.add(new SvgLineElement(left, bottom, right, bottom));
            shapeLines.add(new SvgLineElement(center, top, center, bottom));
            SvgGElement g = new SvgGElement();
            Iterator iterator2 = shapeLines.iterator();
            while (iterator2.hasNext()) {
                SvgLineElement shapeLine;
                SvgLineElement svgLineElement = shapeLine = (SvgLineElement)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)svgLineElement, (String)"shapeLine");
                GeomHelper.Companion.decorate(svgLineElement, p);
                g.children().add(shapeLine);
            }
            return g;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

