/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.config.BunchConfig;
import jetbrains.datalore.plot.config.OptionsAccessor;
import jetbrains.datalore.plot.config.PlotConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0002J\u0015\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001cJ\u0016\u0010\u001f\u001a\u00020\u00042\u000e\u0010 \u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eJ\u001a\u0010!\u001a\u0004\u0018\u00010\u00062\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0002J\u0016\u0010#\u001a\u00020\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0%H\u0002J\u0016\u0010#\u001a\u00020\u00062\u000e\u0010&\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eJ0\u0010'\u001a\u00020\u00062\u000e\u0010(\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\b\u0010)\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ljetbrains/datalore/plot/PlotSizeHelper;", "", "()V", "ASPECT_RATIO", "", "DEF_LIVE_MAP_SIZE", "Ljetbrains/datalore/base/geometry/DoubleVector;", "DEF_LIVE_MAP_WIDTH", "DEF_PLOT_SIZE", "DEF_PLOT_WIDTH", "bunchItemBoundsList", "", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "bunchSpec", "", "bunchItemSize", "bunchItem", "Ljetbrains/datalore/plot/config/BunchConfig$BunchItem;", "bunchItemSize$plot_config_portable", "defaultSinglePlotSize", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "containsLiveMap", "", "extractDouble", "regex", "Lkotlin/text/Regex;", "text", "", "fetchPlotSizeFromSvg", "svg", "figureAspectRatio", "figureFpec", "getSizeOptionOrNull", "singlePlotSpec", "plotBunchSize", "bunchItemBoundsIterable", "", "plotBunchFpec", "singlePlotSize", "plotSpec", "plotSize", "plot-config-portable"})
public final class PlotSizeHelper {
    private static final double ASPECT_RATIO = 1.5;
    private static final double DEF_PLOT_WIDTH = 500.0;
    private static final double DEF_LIVE_MAP_WIDTH = 800.0;
    private static final DoubleVector DEF_PLOT_SIZE;
    private static final DoubleVector DEF_LIVE_MAP_SIZE;
    public static final PlotSizeHelper INSTANCE;

    @NotNull
    public final DoubleVector singlePlotSize(@NotNull Map<?, ?> plotSpec, @Nullable DoubleVector plotSize, @NotNull PlotFacets facets, boolean containsLiveMap) {
        DoubleVector plotSizeSpec;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        return plotSize != null ? plotSize : ((plotSizeSpec = this.getSizeOptionOrNull(plotSpec)) != null ? plotSizeSpec : this.defaultSinglePlotSize(facets, containsLiveMap));
    }

    private final List<DoubleRectangle> bunchItemBoundsList(Map<?, ?> bunchSpec) {
        BunchConfig bunchConfig = new BunchConfig(bunchSpec);
        if (bunchConfig.getBunchItems().isEmpty()) {
            throw (Throwable)new IllegalArgumentException("No plots in the bunch");
        }
        ArrayList<DoubleRectangle> plotBounds = new ArrayList<DoubleRectangle>();
        for (BunchConfig.BunchItem bunchItem : bunchConfig.getBunchItems()) {
            plotBounds.add(new DoubleRectangle(new DoubleVector(bunchItem.getX(), bunchItem.getY()), this.bunchItemSize$plot_config_portable(bunchItem)));
        }
        return plotBounds;
    }

    @NotNull
    public final DoubleVector bunchItemSize$plot_config_portable(@NotNull BunchConfig.BunchItem bunchItem) {
        Intrinsics.checkNotNullParameter((Object)bunchItem, (String)"bunchItem");
        return bunchItem.hasSize() ? bunchItem.getSize() : this.singlePlotSize(bunchItem.getFeatureSpec(), null, PlotFacets.Companion.undefined(), false);
    }

    private final DoubleVector defaultSinglePlotSize(PlotFacets facets, boolean containsLiveMap) {
        DoubleVector plotSize = DEF_PLOT_SIZE;
        if (facets.isDefined()) {
            List<?> list2 = facets.getXLevels();
            Intrinsics.checkNotNull(list2);
            List<?> xLevels = list2;
            List<?> list3 = facets.getYLevels();
            Intrinsics.checkNotNull(list3);
            List<?> yLevels = list3;
            int columns = xLevels.isEmpty() ? 1 : xLevels.size();
            int rows = yLevels.isEmpty() ? 1 : yLevels.size();
            double panelWidth = DEF_PLOT_SIZE.getX() * (0.5 + 0.5 / (double)columns);
            double panelHeight = DEF_PLOT_SIZE.getY() * (0.5 + 0.5 / (double)rows);
            plotSize = new DoubleVector(panelWidth * (double)columns, panelHeight * (double)rows);
        } else if (containsLiveMap) {
            plotSize = DEF_LIVE_MAP_SIZE;
        }
        return plotSize;
    }

    private final DoubleVector getSizeOptionOrNull(Map<?, ?> singlePlotSpec) {
        Map<?, ?> map2 = singlePlotSpec;
        String string = "ggsize";
        boolean bl = false;
        Map<?, ?> map3 = map2;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (!map3.containsKey(string)) {
            return null;
        }
        Map<?, ?> map4 = OptionsAccessor.Companion.over(singlePlotSpec).getMap("ggsize");
        OptionsAccessor sizeSpec = OptionsAccessor.Companion.over(map4);
        Double width2 = sizeSpec.getDouble("width");
        Double height = sizeSpec.getDouble("height");
        if (width2 == null || height == null) {
            return null;
        }
        return new DoubleVector(width2, height);
    }

    public final double figureAspectRatio(@NotNull Map<?, ?> figureFpec) {
        double d;
        Intrinsics.checkNotNullParameter(figureFpec, (String)"figureFpec");
        if (PlotConfig.Companion.isPlotSpec(figureFpec)) {
            DoubleVector doubleVector = this.getSizeOptionOrNull(figureFpec);
            if (doubleVector != null) {
                DoubleVector doubleVector2 = doubleVector;
                boolean bl = false;
                boolean bl2 = false;
                DoubleVector it = doubleVector2;
                boolean bl3 = false;
                d = it.getX() / it.getY();
            } else {
                d = 1.5;
            }
        } else if (PlotConfig.Companion.isGGBunchSpec(figureFpec)) {
            DoubleVector bunchSize = this.plotBunchSize(figureFpec);
            d = bunchSize.getX() / bunchSize.getY();
        } else {
            throw (Throwable)new RuntimeException("Unexpected plot spec kind: " + PlotConfig.Companion.specKind(figureFpec));
        }
        return d;
    }

    @NotNull
    public final DoubleVector plotBunchSize(@NotNull Map<?, ?> plotBunchFpec) {
        Intrinsics.checkNotNullParameter(plotBunchFpec, (String)"plotBunchFpec");
        boolean bl = PlotConfig.Companion.isGGBunchSpec(plotBunchFpec);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Plot Bunch is expected but was kind: " + PlotConfig.Companion.specKind(plotBunchFpec);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.plotBunchSize((Iterable<DoubleRectangle>)this.bunchItemBoundsList(plotBunchFpec));
    }

    /*
     * WARNING - void declaration
     */
    private final DoubleVector plotBunchSize(Iterable<DoubleRectangle> bunchItemBoundsIterable) {
        void $this$fold$iv;
        Iterable<DoubleRectangle> iterable = bunchItemBoundsIterable;
        DoubleRectangle initial$iv = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        boolean $i$f$fold = false;
        DoubleRectangle accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bounds;
            DoubleRectangle doubleRectangle = (DoubleRectangle)element$iv;
            DoubleRectangle acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.union((DoubleRectangle)bounds);
        }
        return accumulator$iv.getDimension();
    }

    @NotNull
    public final DoubleVector fetchPlotSizeFromSvg(@NotNull String svg) {
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        MatchResult svgTagMatch = Regex.find$default((Regex)new Regex("<svg (.*)>"), (CharSequence)svg, (int)0, (int)2, null);
        boolean bl = svgTagMatch != null && svgTagMatch.getGroupValues().size() == 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Couldn't find 'svg' tag";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String svgTag = (String)svgTagMatch.getGroupValues().get(1);
        double width2 = this.extractDouble(new Regex(".*width=\"(\\d+)\\.?(\\d+)?\""), svgTag);
        double height = this.extractDouble(new Regex(".*height=\"(\\d+)\\.?(\\d+)?\""), svgTag);
        return new DoubleVector(width2, height);
    }

    private final double extractDouble(Regex regex, String text) {
        double d;
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)text, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        MatchResult matchResult2 = matchResult;
        List values2 = matchResult2.getGroupValues();
        if (values2.size() < 3) {
            String string = String.valueOf(values2.get(1));
            boolean bl = false;
            d = Double.parseDouble(string);
        } else {
            String string = (String)values2.get(1) + '.' + (String)values2.get(2);
            boolean bl = false;
            d = Double.parseDouble(string);
        }
        return d;
    }

    private PlotSizeHelper() {
    }

    static {
        PlotSizeHelper plotSizeHelper;
        INSTANCE = plotSizeHelper = new PlotSizeHelper();
        DEF_PLOT_SIZE = new DoubleVector(500.0, 333.3333333333333);
        DEF_LIVE_MAP_SIZE = new DoubleVector(800.0, 533.3333333333334);
    }
}

