/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.mapper.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.observable.event.ListenerCaller;
import jetbrains.datalore.base.observable.event.Listeners;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.mapper.core.Mapper;
import jetbrains.datalore.mapper.core.Mappers;
import jetbrains.datalore.mapper.core.MappingContextListener;
import jetbrains.datalore.mapper.core.MappingContextProperty;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\tJ\u001f\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\t\u00a2\u0006\u0002\u0010\u0012J9\u0010\u0013\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0014\"\u0004\b\u0000\u0010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u0017\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0000\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00140\u001aJ/\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0000\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00010\u00140\u001a\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0017\u001a\u0002H\u0015H\u0002\u00a2\u0006\u0002\u0010\u001bJ=\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0000\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00010\u00140\u001a\"\u0004\b\u0000\u0010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u0017\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010\u001cJ)\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\t2\b\u0010\u001f\u001a\u0004\u0018\u0001H\u0011\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\u001e2\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014J\u001f\u0010#\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010$\u001a\u00020\u001e2\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0001\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ljetbrains/datalore/mapper/core/MappingContext;", "", "()V", "myListeners", "Ljetbrains/datalore/base/observable/event/Listeners;", "Ljetbrains/datalore/mapper/core/MappingContextListener;", "myMappers", "", "myProperties", "Ljetbrains/datalore/mapper/core/MappingContextProperty;", "addListener", "Ljetbrains/datalore/base/registration/Registration;", "l", "contains", "", "property", "get", "ValueT", "(Ljetbrains/datalore/mapper/core/MappingContextProperty;)Ljava/lang/Object;", "getMapper", "Ljetbrains/datalore/mapper/core/Mapper;", "S", "ancestor", "source", "(Ljetbrains/datalore/mapper/core/Mapper;Ljava/lang/Object;)Ljetbrains/datalore/mapper/core/Mapper;", "getMappers", "", "(Ljava/lang/Object;)Ljava/util/Set;", "(Ljetbrains/datalore/mapper/core/Mapper;Ljava/lang/Object;)Ljava/util/Set;", "put", "", "value", "(Ljetbrains/datalore/mapper/core/MappingContextProperty;Ljava/lang/Object;)V", "register", "mapper", "remove", "unregister", "mapper-core"})
public final class MappingContext {
    private final Map<? super Object, ? super Object> myMappers;
    private final Listeners<MappingContextListener> myListeners;
    private final Map<MappingContextProperty<?>, Object> myProperties;

    @NotNull
    public final Registration addListener(@NotNull MappingContextListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        return this.myListeners.add(l);
    }

    public final void register(@NotNull Mapper<?, ?> mapper2) {
        Intrinsics.checkNotNullParameter(mapper2, (String)"mapper");
        if (mapper2.isFindable()) {
            Object source = mapper2.getSource();
            if (!this.myMappers.containsKey(source)) {
                this.myMappers.put(source, mapper2);
            } else {
                Object ms = this.myMappers.get(source);
                if (ms instanceof Set) {
                    Set mappers = TypeIntrinsics.asMutableSet((Object)ms);
                    mappers.add(mapper2);
                } else {
                    Object object = ms;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.mapper.core.Mapper<*, *>");
                    }
                    Mapper m = (Mapper)object;
                    Set mappers = SetsKt.mutableSetOf((Object[])new Mapper[]{m, mapper2});
                    this.myMappers.put(source, mappers);
                }
            }
        }
        this.myListeners.fire(new ListenerCaller<MappingContextListener>(mapper2){
            final /* synthetic */ Mapper $mapper;

            public void call(@NotNull MappingContextListener l) {
                Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                l.onMapperRegistered(this.$mapper);
            }
            {
                this.$mapper = $captured_local_variable$0;
            }
        });
    }

    public final void unregister(@NotNull Mapper<?, ?> mapper2) {
        Intrinsics.checkNotNullParameter(mapper2, (String)"mapper");
        if (mapper2.isFindable()) {
            Object source = mapper2.getSource();
            if (!this.myMappers.containsKey(source)) {
                throw (Throwable)new IllegalStateException();
            }
            Object ms = this.myMappers.get(source);
            if (ms instanceof Set) {
                Set mappers = TypeIntrinsics.asMutableSet((Object)ms);
                mappers.remove(mapper2);
                if (mappers.size() == 1) {
                    this.myMappers.put(source, mappers.iterator().next());
                }
            } else {
                if (Intrinsics.areEqual((Object)ms, mapper2) ^ true) {
                    throw (Throwable)new IllegalStateException();
                }
                this.myMappers.remove(source);
            }
        }
        this.myListeners.fire(new ListenerCaller<MappingContextListener>(mapper2){
            final /* synthetic */ Mapper $mapper;

            public void call(@NotNull MappingContextListener l) {
                Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                l.onMapperUnregistered(this.$mapper);
            }
            {
                this.$mapper = $captured_local_variable$0;
            }
        });
    }

    @Nullable
    public final <S> Mapper<? super S, Object> getMapper(@NotNull Mapper<?, ?> ancestor, S source) {
        Intrinsics.checkNotNullParameter(ancestor, (String)"ancestor");
        Set<Mapper<S, Object>> result = this.getMappers(ancestor, source);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw (Throwable)new IllegalStateException("There are more than one mapper for " + source);
        }
        return result.iterator().next();
    }

    @NotNull
    public final <S> Set<Mapper<? super S, Object>> getMappers(@NotNull Mapper<?, ?> ancestor, S source) {
        Intrinsics.checkNotNullParameter(ancestor, (String)"ancestor");
        Set<Mapper<S, Object>> mappers = this.getMappers(source);
        Set result = null;
        for (Mapper<S, Object> m : mappers) {
            if (!Mappers.INSTANCE.isDescendant(ancestor, m)) continue;
            if (result == null) {
                if (mappers.size() == 1) {
                    return SetsKt.setOf(m);
                }
                boolean bl = false;
                result = new LinkedHashSet();
            }
            result.add(m);
        }
        if (result == null) {
            boolean bl = false;
            return SetsKt.emptySet();
        }
        return result;
    }

    public final <ValueT> void put(@NotNull MappingContextProperty<ValueT> property2, @Nullable ValueT value) {
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        if (this.myProperties.containsKey(property2)) {
            throw (Throwable)new IllegalStateException("Property " + property2 + " is already defined");
        }
        if (value == null) {
            throw (Throwable)new IllegalArgumentException("Trying to set null as a value of " + property2);
        }
        this.myProperties.put(property2, value);
    }

    public final <ValueT> ValueT get(@NotNull MappingContextProperty<ValueT> property2) {
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        Object object = this.myProperties.get(property2);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Property " + property2 + " wasn't found");
        }
        Object value = object;
        return (ValueT)value;
    }

    public final boolean contains(@NotNull MappingContextProperty<Object> property2) {
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        return this.myProperties.containsKey(property2);
    }

    public final <ValueT> ValueT remove(@NotNull MappingContextProperty<Object> property2) {
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        if (!this.myProperties.containsKey(property2)) {
            throw (Throwable)new IllegalStateException("Property " + property2 + " wasn't found");
        }
        return (ValueT)this.myProperties.remove(property2);
    }

    @NotNull
    public final Set<Mapper<? super Object, Object>> getMappers() {
        boolean bl = false;
        Set mappers = new LinkedHashSet();
        for (Object object : this.myMappers.keySet()) {
            mappers.addAll((Collection)this.getMappers(object));
        }
        return mappers;
    }

    private final <S> Set<Mapper<? super S, Object>> getMappers(S source) {
        if (!this.myMappers.containsKey(source)) {
            boolean bl = false;
            return SetsKt.emptySet();
        }
        Object mappersObject = this.myMappers.get(source);
        if (mappersObject instanceof Mapper) {
            Mapper mapper2 = (Mapper)mappersObject;
            return SetsKt.setOf((Object)mapper2);
        }
        boolean bl = false;
        Set result = new LinkedHashSet();
        Object object = mappersObject;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Set<jetbrains.datalore.mapper.core.Mapper<in S, kotlin.Any>>");
        }
        Set mapperSet = (Set)object;
        for (Mapper m : mapperSet) {
            result.add(m);
        }
        return result;
    }

    public MappingContext() {
        boolean bl = false;
        this.myMappers = new LinkedHashMap();
        this.myListeners = new Listeners();
        bl = false;
        this.myProperties = new LinkedHashMap();
    }
}

