/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.spatial.LonLat;
import jetbrains.datalore.base.spatial.LongitudeSegment;
import jetbrains.datalore.base.typedGeometry.FunctionsKt;
import jetbrains.datalore.base.typedGeometry.Rect;
import jetbrains.datalore.base.typedGeometry.Vec;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0005\u001a\u00020\u0003J\u0013\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002J\u0006\u0010\u0006\u001a\u00020\u0003J\u0006\u0010\u0004\u001a\u00020\u0003J\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018J\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/base/spatial/GeoRectangle;", "", "startLongitude", "", "minLatitude", "endLongitude", "maxLatitude", "(DDDD)V", "isEmpty", "", "()Z", "myLatitudeRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "myLongitudeSegment", "Ljetbrains/datalore/base/spatial/LongitudeSegment;", "encloses", "rect", "equals", "other", "hashCode", "", "latitudeRangeIsEmpty", "range", "splitByAntiMeridian", "", "Ljetbrains/datalore/base/typedGeometry/Rect;", "Ljetbrains/datalore/base/spatial/LonLat;", "base-portable"})
public final class GeoRectangle {
    private final LongitudeSegment myLongitudeSegment;
    private final ClosedRange<Double> myLatitudeRange;

    public final boolean isEmpty() {
        return this.myLongitudeSegment.isEmpty() && this.latitudeRangeIsEmpty(this.myLatitudeRange);
    }

    private final boolean latitudeRangeIsEmpty(ClosedRange<Double> range2) {
        return ((Number)range2.getUpperEnd()).doubleValue() == ((Number)range2.getLowerEnd()).doubleValue();
    }

    public final double startLongitude() {
        return this.myLongitudeSegment.start();
    }

    public final double endLongitude() {
        return this.myLongitudeSegment.end();
    }

    public final double minLatitude() {
        return ((Number)this.myLatitudeRange.getLowerEnd()).doubleValue();
    }

    public final double maxLatitude() {
        return ((Number)this.myLatitudeRange.getUpperEnd()).doubleValue();
    }

    public final boolean encloses(@NotNull GeoRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return this.myLongitudeSegment.encloses(rect2.myLongitudeSegment) && this.myLatitudeRange.encloses(rect2.myLatitudeRange);
    }

    @NotNull
    public final List<Rect<LonLat>> splitByAntiMeridian() {
        ArrayList rects = new ArrayList();
        List<ClosedRange<Double>> longitudeRanges = this.myLongitudeSegment.splitByAntiMeridian();
        for (ClosedRange<Double> longitudeRange : longitudeRanges) {
            rects.add(FunctionsKt.newSpanRectangle(new Vec(((Number)longitudeRange.getLowerEnd()).doubleValue(), ((Number)this.myLatitudeRange.getLowerEnd()).doubleValue()), new Vec(((Number)longitudeRange.getUpperEnd()).doubleValue(), ((Number)this.myLatitudeRange.getUpperEnd()).doubleValue())));
        }
        return rects;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass())) ^ true) {
            return false;
        }
        GeoRectangle that = (GeoRectangle)other;
        return Intrinsics.areEqual((Object)this.myLongitudeSegment, (Object)that.myLongitudeSegment) && Intrinsics.areEqual(this.myLatitudeRange, that.myLatitudeRange);
    }

    public int hashCode() {
        return ((Object)CollectionsKt.listOf((Object[])new Object[]{this.myLongitudeSegment, this.myLatitudeRange})).hashCode();
    }

    public GeoRectangle(double startLongitude, double minLatitude, double endLongitude, double maxLatitude) {
        boolean bl = minLatitude <= maxLatitude;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid latitude range: [" + minLatitude + ".." + maxLatitude + ']';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.myLongitudeSegment = new LongitudeSegment(startLongitude, endLongitude);
        this.myLatitudeRange = new ClosedRange<Comparable>(Double.valueOf(minLatitude), Double.valueOf(maxLatitude));
    }
}

