/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import java.util.List;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.spatial.GeoBoundingBoxCalculator;
import jetbrains.datalore.base.spatial.GeoRectangle;
import jetbrains.datalore.base.typedGeometry.FunctionsKt;
import jetbrains.datalore.base.typedGeometry.Rect;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u001aL\u0010\b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0002j\u0002`\u00030\t2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n2\u0012\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\f\u001a\u00020\u000b\u001a*\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u001a*\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012\u001a0\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u000e0\u0012\"%\u0010\u0000\u001a\u00020\u0001*\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0002j\u0002`\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"%\u0010\u0006\u001a\u00020\u0001*\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0002j\u0002`\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005*\"\u0010\u0017\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00022\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0002\u00a8\u0006\u0018"}, d2={"end", "", "Lkotlin/Pair;", "Ljetbrains/datalore/base/spatial/Segment;", "getEnd", "(Lkotlin/Pair;)D", "start", "getStart", "makeSegments", "Lkotlin/sequences/Sequence;", "Lkotlin/Function1;", "", "size", "geoRectsBBox", "Ljetbrains/datalore/base/typedGeometry/Rect;", "T", "Ljetbrains/datalore/base/spatial/GeoBoundingBoxCalculator;", "rectangles", "", "Ljetbrains/datalore/base/spatial/GeoRectangle;", "pointsBBox", "xyCoords", "union", "Segment", "base-portable"})
public final class GeoBoundingBoxCalculatorKt {
    public static final double getStart(@NotNull Pair<Double, Double> $this$start) {
        Intrinsics.checkNotNullParameter($this$start, (String)"$this$start");
        return ((Number)$this$start.getFirst()).doubleValue();
    }

    public static final double getEnd(@NotNull Pair<Double, Double> $this$end) {
        Intrinsics.checkNotNullParameter($this$end, (String)"$this$end");
        return ((Number)$this$end.getSecond()).doubleValue();
    }

    @NotNull
    public static final Sequence<Pair<Double, Double>> makeSegments(@NotNull Function1<? super Integer, Double> start, @NotNull Function1<? super Integer, Double> end, int size2) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)size2))), (Function1)((Function1)new Function1<Integer, Pair<? extends Double, ? extends Double>>(start, end){
            final /* synthetic */ Function1 $start;
            final /* synthetic */ Function1 $end;

            @NotNull
            public final Pair<Double, Double> invoke(int it) {
                return new Pair(this.$start.invoke((Object)it), this.$end.invoke((Object)it));
            }
            {
                this.$start = function1;
                this.$end = function12;
                super(1);
            }
        }));
    }

    @NotNull
    public static final <T> Rect<T> geoRectsBBox(@NotNull GeoBoundingBoxCalculator<T> $this$geoRectsBBox, @NotNull List<GeoRectangle> rectangles) {
        Intrinsics.checkNotNullParameter($this$geoRectsBBox, (String)"$this$geoRectsBBox");
        Intrinsics.checkNotNullParameter(rectangles, (String)"rectangles");
        return $this$geoRectsBBox.calculateBoundingBox(GeoBoundingBoxCalculatorKt.makeSegments((Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(rectangles){
            final /* synthetic */ List $rectangles;

            public final double invoke(int it) {
                return ((GeoRectangle)this.$rectangles.get(it)).startLongitude();
            }
            {
                this.$rectangles = list2;
                super(1);
            }
        }), (Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(rectangles){
            final /* synthetic */ List $rectangles;

            public final double invoke(int it) {
                return ((GeoRectangle)this.$rectangles.get(it)).endLongitude();
            }
            {
                this.$rectangles = list2;
                super(1);
            }
        }), rectangles.size()), GeoBoundingBoxCalculatorKt.makeSegments((Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(rectangles){
            final /* synthetic */ List $rectangles;

            public final double invoke(int it) {
                return ((GeoRectangle)this.$rectangles.get(it)).minLatitude();
            }
            {
                this.$rectangles = list2;
                super(1);
            }
        }), (Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(rectangles){
            final /* synthetic */ List $rectangles;

            public final double invoke(int it) {
                return ((GeoRectangle)this.$rectangles.get(it)).maxLatitude();
            }
            {
                this.$rectangles = list2;
                super(1);
            }
        }), rectangles.size()));
    }

    @NotNull
    public static final <T> Rect<T> pointsBBox(@NotNull GeoBoundingBoxCalculator<T> $this$pointsBBox, @NotNull List<Double> xyCoords) {
        Intrinsics.checkNotNullParameter($this$pointsBBox, (String)"$this$pointsBBox");
        Intrinsics.checkNotNullParameter(xyCoords, (String)"xyCoords");
        Preconditions.INSTANCE.checkArgument(xyCoords.size() % 2 == 0, "Longitude-Latitude list is not even-numbered.");
        Function1 x2 = (Function1)new Function1<Integer, Double>(xyCoords){
            final /* synthetic */ List $xyCoords;

            public final double invoke(int index) {
                return ((Number)this.$xyCoords.get(2 * index)).doubleValue();
            }
            {
                this.$xyCoords = list2;
                super(1);
            }
        };
        Function1 y2 = (Function1)new Function1<Integer, Double>(xyCoords){
            final /* synthetic */ List $xyCoords;

            public final double invoke(int index) {
                return ((Number)this.$xyCoords.get(2 * index + 1)).doubleValue();
            }
            {
                this.$xyCoords = list2;
                super(1);
            }
        };
        int i = xyCoords.size() / 2;
        return $this$pointsBBox.calculateBoundingBox(GeoBoundingBoxCalculatorKt.makeSegments((Function1<? super Integer, Double>)x2, (Function1<? super Integer, Double>)x2, i), GeoBoundingBoxCalculatorKt.makeSegments((Function1<? super Integer, Double>)y2, (Function1<? super Integer, Double>)y2, i));
    }

    @NotNull
    public static final <T> Rect<T> union(@NotNull GeoBoundingBoxCalculator<T> $this$union, @NotNull List<Rect<T>> rectangles) {
        Intrinsics.checkNotNullParameter($this$union, (String)"$this$union");
        Intrinsics.checkNotNullParameter(rectangles, (String)"rectangles");
        return $this$union.calculateBoundingBox(GeoBoundingBoxCalculatorKt.makeSegments((Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(rectangles){
            final /* synthetic */ List $rectangles;

            public final double invoke(int it) {
                return FunctionsKt.getLeft((Rect)this.$rectangles.get(it));
            }
            {
                this.$rectangles = list2;
                super(1);
            }
        }), (Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(rectangles){
            final /* synthetic */ List $rectangles;

            public final double invoke(int it) {
                return FunctionsKt.getRight((Rect)this.$rectangles.get(it));
            }
            {
                this.$rectangles = list2;
                super(1);
            }
        }), rectangles.size()), GeoBoundingBoxCalculatorKt.makeSegments((Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(rectangles){
            final /* synthetic */ List $rectangles;

            public final double invoke(int it) {
                return FunctionsKt.getTop((Rect)this.$rectangles.get(it));
            }
            {
                this.$rectangles = list2;
                super(1);
            }
        }), (Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(rectangles){
            final /* synthetic */ List $rectangles;

            public final double invoke(int it) {
                return FunctionsKt.getBottom((Rect)this.$rectangles.get(it));
            }
            {
                this.$rectangles = list2;
                super(1);
            }
        }), rectangles.size()));
    }
}

