/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.observable.collections;

import jetbrains.datalore.base.observable.collections.CollectionListener;
import jetbrains.datalore.base.observable.event.ListenerEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002:\u0001\u001dB)\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/base/observable/collections/CollectionItemEvent;", "ItemT", "Ljetbrains/datalore/base/observable/event/ListenerEvent;", "Ljetbrains/datalore/base/observable/collections/CollectionListener;", "oldItem", "newItem", "index", "", "type", "Ljetbrains/datalore/base/observable/collections/CollectionItemEvent$EventType;", "(Ljava/lang/Object;Ljava/lang/Object;ILjetbrains/datalore/base/observable/collections/CollectionItemEvent$EventType;)V", "getIndex", "()I", "getNewItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getOldItem", "getType", "()Ljetbrains/datalore/base/observable/collections/CollectionItemEvent$EventType;", "dispatch", "", "l", "equals", "", "other", "", "hashCode", "toString", "", "EventType", "base-portable"})
public final class CollectionItemEvent<ItemT>
implements ListenerEvent<CollectionListener<ItemT>> {
    @Nullable
    private final ItemT oldItem;
    @Nullable
    private final ItemT newItem;
    private final int index;
    @NotNull
    private final EventType type;

    @Override
    public void dispatch(@NotNull CollectionListener<ItemT> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        if (EventType.ADD == this.type) {
            l.onItemAdded(this);
        } else if (EventType.SET == this.type) {
            l.onItemSet(this);
        } else {
            l.onItemRemoved(this);
        }
    }

    @NotNull
    public String toString() {
        return EventType.ADD == this.type ? String.valueOf(this.newItem) + " added at " + this.index : (EventType.SET == this.type ? String.valueOf(this.oldItem) + " replaced with " + this.newItem + " at " + this.index : String.valueOf(this.oldItem) + " removed at " + this.index);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass())) ^ true) {
            return false;
        }
        CollectionItemEvent cfr_ignored_0 = (CollectionItemEvent)other;
        if (Intrinsics.areEqual(this.oldItem, ((CollectionItemEvent)other).oldItem) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.newItem, ((CollectionItemEvent)other).newItem) ^ true) {
            return false;
        }
        if (this.index != ((CollectionItemEvent)other).index) {
            return false;
        }
        return this.type == ((CollectionItemEvent)other).type;
    }

    public int hashCode() {
        ItemT ItemT = this.oldItem;
        int result = ItemT != null ? ItemT.hashCode() : 0;
        ItemT ItemT2 = this.newItem;
        result = 31 * result + (ItemT2 != null ? ItemT2.hashCode() : 0);
        result = 31 * result + this.index;
        result = 31 * result + this.type.hashCode();
        return result;
    }

    @Nullable
    public final ItemT getOldItem() {
        return this.oldItem;
    }

    @Nullable
    public final ItemT getNewItem() {
        return this.newItem;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final EventType getType() {
        return this.type;
    }

    public CollectionItemEvent(@Nullable ItemT oldItem, @Nullable ItemT newItem, int index, @NotNull EventType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.oldItem = oldItem;
        this.newItem = newItem;
        this.index = index;
        this.type = type;
        if (EventType.ADD == this.type && this.oldItem != null || EventType.REMOVE == this.type && this.newItem != null) {
            throw (Throwable)new IllegalStateException();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/base/observable/collections/CollectionItemEvent$EventType;", "", "(Ljava/lang/String;I)V", "ADD", "SET", "REMOVE", "base-portable"})
    public static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType ADD;
        public static final /* enum */ EventType SET;
        public static final /* enum */ EventType REMOVE;
        private static final /* synthetic */ EventType[] $VALUES;

        static {
            EventType[] eventTypeArray = new EventType[3];
            EventType[] eventTypeArray2 = eventTypeArray;
            eventTypeArray[0] = ADD = new EventType();
            eventTypeArray[1] = SET = new EventType();
            eventTypeArray[2] = REMOVE = new EventType();
            $VALUES = eventTypeArray;
        }

        public static EventType[] values() {
            return (EventType[])$VALUES.clone();
        }

        public static EventType valueOf(String string) {
            return Enum.valueOf(EventType.class, string);
        }
    }
}

