/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.json.JsonLexer;
import jetbrains.datalore.base.json.JsonParser$WhenMappings;
import jetbrains.datalore.base.json.JsonSupportKt;
import jetbrains.datalore.base.json.Token;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u0004\u0018\u00010\u0001J\u001e\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/base/json/JsonParser;", "", "json", "", "(Ljava/lang/String;)V", "parseArray", "", "lexer", "Ljetbrains/datalore/base/json/JsonLexer;", "parseJson", "parseObject", "", "parseValue", "require", "", "current", "Ljetbrains/datalore/base/json/Token;", "expected", "messagePrefix", "JsonException", "base-portable"})
public final class JsonParser {
    private final String json;

    @Nullable
    public final Object parseJson() {
        JsonLexer lexer = new JsonLexer(this.json);
        return this.parseValue(lexer);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Object parseValue(JsonLexer lexer) {
        Token token = lexer.getCurrentToken();
        if (token != null) {
            switch (JsonParser$WhenMappings.$EnumSwitchMapping$0[token.ordinal()]) {
                case 1: {
                    String string = JsonSupportKt.unescape(lexer.tokenValue());
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string;
                    boolean bl3 = false;
                    lexer.nextToken();
                    Object object2 = string;
                    return object2;
                }
                case 2: {
                    Object object = lexer.tokenValue();
                    boolean bl = false;
                    object = Double.parseDouble((String)object);
                    bl = false;
                    boolean bl4 = false;
                    double it = ((Number)object).doubleValue();
                    boolean bl5 = false;
                    lexer.nextToken();
                    Object object2 = object;
                    return object2;
                }
                case 3: {
                    Boolean bl = false;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    boolean it = bl;
                    boolean bl8 = false;
                    lexer.nextToken();
                    Object object2 = bl;
                    return object2;
                }
                case 4: {
                    Boolean bl = true;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    boolean it = bl;
                    boolean bl11 = false;
                    lexer.nextToken();
                    Object object2 = bl;
                    return object2;
                }
                case 5: {
                    Object var2_6 = null;
                    boolean bl = false;
                    boolean bl12 = false;
                    Void it = var2_6;
                    boolean bl13 = false;
                    lexer.nextToken();
                    Object object2 = var2_6;
                    return object2;
                }
                case 6: {
                    Object object2 = this.parseObject(lexer);
                    return object2;
                }
                case 7: {
                    Object object2 = this.parseArray(lexer);
                    return object2;
                }
            }
        }
        String string = "Invalid token: " + (Object)((Object)lexer.getCurrentToken());
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private final List<Object> parseArray(JsonLexer lexer) {
        Function1<Token, Unit> $fun$checkCurrentToken$1 = new Function1<Token, Unit>(this, lexer){
            final /* synthetic */ JsonParser this$0;
            final /* synthetic */ JsonLexer $lexer;

            public final void invoke(@NotNull Token token) {
                Intrinsics.checkNotNullParameter((Object)((Object)token), (String)"token");
                JsonParser.access$require(this.this$0, this.$lexer.getCurrentToken(), token, "[Arr] ");
            }
            {
                this.this$0 = jsonParser;
                this.$lexer = jsonLexer;
                super(1);
            }
        };
        boolean bl = false;
        List list2 = new ArrayList();
        $fun$checkCurrentToken$1.invoke(Token.LEFT_BRACKET);
        lexer.nextToken();
        while (lexer.getCurrentToken() != Token.RIGHT_BRACKET) {
            Collection collection2 = list2;
            boolean bl2 = false;
            if (!collection2.isEmpty()) {
                $fun$checkCurrentToken$1.invoke(Token.COMMA);
                lexer.nextToken();
            }
            list2.add(this.parseValue(lexer));
        }
        $fun$checkCurrentToken$1.invoke(Token.RIGHT_BRACKET);
        lexer.nextToken();
        return list2;
    }

    private final Map<String, Object> parseObject(JsonLexer lexer) {
        Function1<Token, Unit> $fun$checkCurrentToken$1 = new Function1<Token, Unit>(this, lexer){
            final /* synthetic */ JsonParser this$0;
            final /* synthetic */ JsonLexer $lexer;

            public final void invoke(@NotNull Token token) {
                Intrinsics.checkNotNullParameter((Object)((Object)token), (String)"token");
                JsonParser.access$require(this.this$0, this.$lexer.getCurrentToken(), token, "[Obj] ");
            }
            {
                this.this$0 = jsonParser;
                this.$lexer = jsonLexer;
                super(1);
            }
        };
        boolean bl = false;
        Map map2 = new LinkedHashMap();
        $fun$checkCurrentToken$1.invoke(Token.LEFT_BRACE);
        lexer.nextToken();
        while (lexer.getCurrentToken() != Token.RIGHT_BRACE) {
            Map map3 = map2;
            boolean bl2 = false;
            if (!map3.isEmpty()) {
                $fun$checkCurrentToken$1.invoke(Token.COMMA);
                lexer.nextToken();
            }
            $fun$checkCurrentToken$1.invoke(Token.STRING);
            String key = JsonSupportKt.unescape(lexer.tokenValue());
            lexer.nextToken();
            $fun$checkCurrentToken$1.invoke(Token.COLON);
            lexer.nextToken();
            Object value = this.parseValue(lexer);
            map2.put(key, value);
        }
        $fun$checkCurrentToken$1.invoke(Token.RIGHT_BRACE);
        lexer.nextToken();
        return map2;
    }

    private final void require(Token current, Token expected, String messagePrefix) {
        if (current != expected) {
            throw (Throwable)new JsonException(Intrinsics.stringPlus((String)messagePrefix, (Object)("Expected token: " + (Object)((Object)expected) + ", actual: " + (Object)((Object)current))));
        }
    }

    static /* synthetic */ void require$default(JsonParser jsonParser, Token token, Token token2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        jsonParser.require(token, token2, string);
    }

    public JsonParser(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.json = json;
    }

    public static final /* synthetic */ void access$require(JsonParser $this, Token current, Token expected, String messagePrefix) {
        $this.require(current, expected, messagePrefix);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/base/json/JsonParser$JsonException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "base-portable"})
    public static final class JsonException
    extends Exception {
        public JsonException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

