/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tasks.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.kover.gradle.plugin.commons.ArtifactContent;
import kotlinx.kover.gradle.plugin.commons.ArtifactsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="The task action is so quick that cache does not provide a benefit")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b!\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0016\u0010\r\u001a\u00020\u000e8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lkotlinx/kover/gradle/plugin/tasks/services/KoverArtifactGenerationTask;", "Lorg/gradle/api/DefaultTask;", "()V", "additionalArtifacts", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAdditionalArtifacts", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "artifactFile", "Lorg/gradle/api/file/RegularFileProperty;", "getArtifactFile", "()Lorg/gradle/api/file/RegularFileProperty;", "outputDirs", "getOutputDirs", "projectPath", "", "getProjectPath$kover_gradle_plugin", "()Ljava/lang/String;", "reports", "getReports", "rootDir", "Ljava/io/File;", "sources", "getSources", "generate", "", "kover-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nKoverArtifactGenerationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoverArtifactGenerationTask.kt\nkotlinx/kover/gradle/plugin/tasks/services/KoverArtifactGenerationTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1563#2:57\n1634#2,3:58\n*S KotlinDebug\n*F\n+ 1 KoverArtifactGenerationTask.kt\nkotlinx/kover/gradle/plugin/tasks/services/KoverArtifactGenerationTask\n*L\n52#1:57\n52#1:58,3\n*E\n"})
public abstract class KoverArtifactGenerationTask
extends DefaultTask {
    @NotNull
    private final File rootDir;
    @NotNull
    private final String projectPath;

    public KoverArtifactGenerationTask() {
        File file = this.getProject().getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
        this.rootDir = file;
        String string = this.getProject().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        this.projectPath = string;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getSources();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getOutputDirs();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getReports();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getAdditionalArtifacts();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getArtifactFile();

    @Input
    @NotNull
    public final String getProjectPath$kover_gradle_plugin() {
        return this.projectPath;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void generate() {
        void $this$mapTo$iv$iv;
        ArtifactContent mainContent = new ArtifactContent(this.projectPath, CollectionsKt.toSet((Iterable)((Iterable)this.getSources())), CollectionsKt.toSet((Iterable)((Iterable)this.getOutputDirs())), CollectionsKt.toSet((Iterable)((Iterable)this.getReports())));
        Set set = this.getAdditionalArtifacts().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"additionalArtifacts.files");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(ArtifactsKt.parseArtifactFile((File)it, this.rootDir));
        }
        List additional = (List)destination$iv$iv;
        ArtifactContent artifactContent = mainContent.joinWith(additional);
        File file = ((RegularFile)this.getArtifactFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifactFile.get().asFile");
        ArtifactsKt.write(artifactContent, file, this.rootDir);
    }
}

