/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tasks.reports;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.dsl.tasks.KoverXmlReport;
import kotlinx.kover.gradle.plugin.tasks.reports.AbstractKoverReportTask;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b!\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0006\u001a\u00020\u00078aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0003\u001a\u00020\u00048\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lkotlinx/kover/gradle/plugin/tasks/reports/KoverXmlTask;", "Lkotlinx/kover/gradle/plugin/tasks/reports/AbstractKoverReportTask;", "Lkotlinx/kover/gradle/plugin/dsl/tasks/KoverXmlReport;", "variantName", "", "(Ljava/lang/String;)V", "reportFile", "Lorg/gradle/api/file/RegularFileProperty;", "getReportFile$kover_gradle_plugin", "()Lorg/gradle/api/file/RegularFileProperty;", "title", "Lorg/gradle/api/provider/Property;", "getTitle", "()Lorg/gradle/api/provider/Property;", "getVariantName", "()Ljava/lang/String;", "generate", "", "kover-gradle-plugin"})
public abstract class KoverXmlTask
extends AbstractKoverReportTask
implements KoverXmlReport {
    @NotNull
    private final String variantName;

    @Inject
    public KoverXmlTask(@NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        this.variantName = variantName;
    }

    @Override
    @Internal
    @NotNull
    public String getVariantName() {
        return this.variantName;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getReportFile$kover_gradle_plugin();

    @Input
    @NotNull
    public abstract Property<String> getTitle();

    @TaskAction
    public final void generate() {
        File file = ((RegularFile)this.getReportFile$kover_gradle_plugin().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"reportFile.get().asFile");
        File xmlFile = file;
        xmlFile.getParentFile().mkdirs();
        CoverageTool coverageTool = (CoverageTool)this.getTool().get();
        Object object = this.getTitle().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"title.get()");
        coverageTool.xmlReport(xmlFile, (String)object, this.context());
    }
}

