/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tasks.reports;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.KoverVerificationException;
import kotlinx.kover.gradle.plugin.dsl.tasks.KoverVerifyReport;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b!\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u0014\u0010\u0006\u001a\u00020\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0003\u001a\u00020\u00048\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lkotlinx/kover/gradle/plugin/tasks/reports/KoverVerifyTask;", "Lorg/gradle/api/DefaultTask;", "Lkotlinx/kover/gradle/plugin/dsl/tasks/KoverVerifyReport;", "variantName", "", "(Ljava/lang/String;)V", "errorFile", "Lorg/gradle/api/file/RegularFileProperty;", "getErrorFile", "()Lorg/gradle/api/file/RegularFileProperty;", "getVariantName", "()Ljava/lang/String;", "warningInsteadOfFailure", "Lorg/gradle/api/provider/Property;", "", "getWarningInsteadOfFailure", "()Lorg/gradle/api/provider/Property;", "verify", "", "kover-gradle-plugin"})
public abstract class KoverVerifyTask
extends DefaultTask
implements KoverVerifyReport {
    @NotNull
    private final String variantName;

    @Inject
    public KoverVerifyTask(@NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        this.variantName = variantName;
    }

    @Override
    @Internal
    @NotNull
    public String getVariantName() {
        return this.variantName;
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getWarningInsteadOfFailure();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getErrorFile();

    @TaskAction
    public final void verify() {
        File file = ((RegularFile)this.getErrorFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"errorFile.get().asFile");
        String errorMessage = FilesKt.readText$default((File)file, null, (int)1, null);
        if (((CharSequence)errorMessage).length() == 0) {
            return;
        }
        Object object = this.getWarningInsteadOfFailure().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"warningInsteadOfFailure.get()");
        if (!((Boolean)object).booleanValue()) {
            throw new KoverVerificationException(errorMessage);
        }
        this.getLogger().warn("Kover Verification Error\n" + errorMessage);
    }
}

