/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tasks.reports;

import java.io.File;
import javax.annotation.Nullable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.dsl.AggregationType;
import kotlinx.kover.gradle.plugin.dsl.CoverageUnit;
import kotlinx.kover.gradle.plugin.dsl.GroupingEntityType;
import kotlinx.kover.gradle.plugin.dsl.tasks.KoverLogReport;
import kotlinx.kover.gradle.plugin.tasks.reports.AbstractKoverReportTask;
import kotlinx.kover.gradle.plugin.tools.CoverageRequest;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b!\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0007R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0003\u001a\u00020\u00048\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lkotlinx/kover/gradle/plugin/tasks/reports/KoverFormatCoverageTask;", "Lkotlinx/kover/gradle/plugin/tasks/reports/AbstractKoverReportTask;", "Lkotlinx/kover/gradle/plugin/dsl/tasks/KoverLogReport;", "variantName", "", "(Ljava/lang/String;)V", "aggregationForGroup", "Lorg/gradle/api/provider/Property;", "Lkotlinx/kover/gradle/plugin/dsl/AggregationType;", "getAggregationForGroup", "()Lorg/gradle/api/provider/Property;", "coverageUnits", "Lkotlinx/kover/gradle/plugin/dsl/CoverageUnit;", "getCoverageUnits", "groupBy", "Lkotlinx/kover/gradle/plugin/dsl/GroupingEntityType;", "getGroupBy", "header", "getHeader", "lineFormat", "getLineFormat", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "getVariantName", "()Ljava/lang/String;", "formatToFile", "", "kover-gradle-plugin"})
public abstract class KoverFormatCoverageTask
extends AbstractKoverReportTask
implements KoverLogReport {
    @NotNull
    private final String variantName;

    @Inject
    public KoverFormatCoverageTask(@NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        this.variantName = variantName;
    }

    @Override
    @Internal
    @NotNull
    public String getVariantName() {
        return this.variantName;
    }

    @Input
    @Optional
    @Nullable
    @NotNull
    public abstract Property<String> getHeader();

    @Input
    @NotNull
    public abstract Property<String> getLineFormat();

    @Input
    @NotNull
    public abstract Property<GroupingEntityType> getGroupBy();

    @Input
    @NotNull
    public abstract Property<CoverageUnit> getCoverageUnits();

    @Input
    @NotNull
    public abstract Property<AggregationType> getAggregationForGroup();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @TaskAction
    public final void formatToFile() {
        Object object = this.getGroupBy().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"groupBy.get()");
        GroupingEntityType groupingEntityType = (GroupingEntityType)((Object)object);
        Object object2 = this.getCoverageUnits().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"coverageUnits.get()");
        CoverageUnit coverageUnit = (CoverageUnit)((Object)object2);
        Object object3 = this.getAggregationForGroup().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"aggregationForGroup.get()");
        AggregationType aggregationType = (AggregationType)((Object)object3);
        String string = (String)this.getHeader().getOrNull();
        Object object4 = this.getLineFormat().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"lineFormat.get()");
        CoverageRequest request = new CoverageRequest(groupingEntityType, coverageUnit, aggregationType, string, (String)object4);
        CoverageTool coverageTool = (CoverageTool)this.getTool().get();
        File file = ((RegularFile)this.getOutputFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputFile.get().asFile");
        coverageTool.collectCoverage(request, file, this.context());
    }
}

