/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.dsl.internal;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.KoverIllegalConfigException;
import kotlinx.kover.gradle.plugin.dsl.KoverVariantCreateConfig;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverVariantConfigImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.MergingOptionality;
import org.gradle.api.model.ObjectFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J)\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0010\"\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J)\u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0010\"\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0018\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lkotlinx/kover/gradle/plugin/dsl/internal/KoverVariantCreateConfigImpl;", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverVariantConfigImpl;", "Lkotlinx/kover/gradle/plugin/dsl/KoverVariantCreateConfig;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "variantName", "", "(Lorg/gradle/api/model/ObjectFactory;Ljava/lang/String;)V", "variantsByName", "", "Lkotlinx/kover/gradle/plugin/dsl/internal/MergingOptionality;", "getVariantsByName$kover_gradle_plugin", "()Ljava/util/Map;", "add", "", "variantNames", "", "optional", "", "([Ljava/lang/String;Z)V", "", "addByName", "addedVariantName", "withDependencies", "addWithDependencies", "kover-gradle-plugin"})
public abstract class KoverVariantCreateConfigImpl
extends KoverVariantConfigImpl
implements KoverVariantCreateConfig {
    @NotNull
    private final ObjectFactory objects;
    @NotNull
    private final String variantName;
    @NotNull
    private final Map<String, MergingOptionality> variantsByName;

    @Inject
    public KoverVariantCreateConfigImpl(@NotNull ObjectFactory objects, @NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        super(objects);
        this.objects = objects;
        this.variantName = variantName;
        this.variantsByName = new LinkedHashMap();
    }

    @NotNull
    public final Map<String, MergingOptionality> getVariantsByName$kover_gradle_plugin() {
        return this.variantsByName;
    }

    @Override
    public void add(@NotNull String[] variantNames, boolean optional) {
        Intrinsics.checkNotNullParameter((Object)variantNames, (String)"variantNames");
        this.add(CollectionsKt.listOf((Object[])Arrays.copyOf(variantNames, variantNames.length)), optional);
    }

    @Override
    public void addWithDependencies(@NotNull String[] variantNames, boolean optional) {
        Intrinsics.checkNotNullParameter((Object)variantNames, (String)"variantNames");
        this.addWithDependencies(CollectionsKt.listOf((Object[])Arrays.copyOf(variantNames, variantNames.length)), optional);
    }

    @Override
    public void add(@NotNull Iterable<String> variantNames, boolean optional) {
        Intrinsics.checkNotNullParameter(variantNames, (String)"variantNames");
        for (String addedVariantName : variantNames) {
            this.addByName(addedVariantName, this.variantName, optional, false);
        }
    }

    @Override
    public void addWithDependencies(@NotNull Iterable<String> variantNames, boolean optional) {
        Intrinsics.checkNotNullParameter(variantNames, (String)"variantNames");
        for (String addedVariantName : variantNames) {
            this.addByName(addedVariantName, this.variantName, optional, true);
        }
    }

    private final void addByName(String addedVariantName, String variantName, boolean optional, boolean withDependencies) {
        MergingOptionality variant = this.variantsByName.get(addedVariantName);
        if (variant != null && variant.getOptional() != optional) {
            throw new KoverIllegalConfigException("It is not possible to merge variant '" + addedVariantName + "' to '" + variantName + "' with a different optionality. Merging dependency should be either optional or non-optional.");
        }
        this.variantsByName.put(addedVariantName, new MergingOptionality(optional, withDependencies));
    }
}

