/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.appliers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.kover.gradle.plugin.appliers.KoverContext;
import kotlinx.kover.gradle.plugin.appliers.artifacts.AbstractVariantArtifacts;
import kotlinx.kover.gradle.plugin.appliers.artifacts.AndroidVariantArtifacts;
import kotlinx.kover.gradle.plugin.appliers.artifacts.CustomVariantArtifacts;
import kotlinx.kover.gradle.plugin.appliers.artifacts.JvmVariantArtifacts;
import kotlinx.kover.gradle.plugin.appliers.artifacts.TotalVariantArtifacts;
import kotlinx.kover.gradle.plugin.appliers.instrumentation.JvmTestTaskConfiguratorKt;
import kotlinx.kover.gradle.plugin.appliers.origin.AllVariantOrigins;
import kotlinx.kover.gradle.plugin.appliers.origin.AndroidVariantOrigin;
import kotlinx.kover.gradle.plugin.appliers.origin.JvmVariantOrigin;
import kotlinx.kover.gradle.plugin.appliers.tasks.VariantReportsSet;
import kotlinx.kover.gradle.plugin.commons.KoverCriticalException;
import kotlinx.kover.gradle.plugin.commons.KoverIllegalConfigException;
import kotlinx.kover.gradle.plugin.commons.ReportVariantType;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverReportSetConfigImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverVariantCreateConfigImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.MergingOptionality;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a$\u0010\u0000\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"createVariant", "Lkotlinx/kover/gradle/plugin/appliers/artifacts/AndroidVariantArtifacts;", "Lkotlinx/kover/gradle/plugin/appliers/origin/AndroidVariantOrigin;", "koverContext", "Lkotlinx/kover/gradle/plugin/appliers/KoverContext;", "config", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverVariantCreateConfigImpl;", "Lkotlinx/kover/gradle/plugin/appliers/artifacts/JvmVariantArtifacts;", "Lkotlinx/kover/gradle/plugin/appliers/origin/JvmVariantOrigin;", "variantName", "", "finalizing", "", "origins", "Lkotlinx/kover/gradle/plugin/appliers/origin/AllVariantOrigins;", "reportsConfig", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverReportSetConfigImpl;", "projectPath", "variantConfig", "kover-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nFinalizeKover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FinalizeKover.kt\nkotlinx/kover/gradle/plugin/appliers/FinalizeKoverKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n*L\n1#1,192:1\n1869#2,2:193\n1563#2:195\n1634#2,3:196\n1869#2,2:199\n1563#2:201\n1634#2,3:202\n1869#2,2:205\n1869#2,2:207\n1869#2,2:209\n1869#2,2:219\n216#3,2:211\n216#3:213\n216#3,2:214\n217#3:216\n216#3,2:217\n216#3,2:221\n50#4:223\n*S KotlinDebug\n*F\n+ 1 FinalizeKover.kt\nkotlinx/kover/gradle/plugin/appliers/FinalizeKoverKt\n*L\n30#1:193,2\n38#1:195\n38#1:196,3\n42#1:199,2\n54#1:201\n54#1:202,3\n59#1:205,2\n60#1:207,2\n64#1:209,2\n127#1:219,2\n67#1:211,2\n73#1:213\n84#1:214,2\n73#1:216\n112#1:217,2\n139#1:221,2\n148#1:223\n*E\n"})
public final class FinalizeKoverKt {
    /*
     * WARNING - void declaration
     */
    public static final void finalizing(@NotNull KoverContext $this$finalizing, @NotNull AllVariantOrigins origins) {
        Object element$iv;
        AbstractVariantArtifacts it;
        void $this$mapTo$iv$iv;
        Object element$iv22;
        Collection collection;
        Iterator $this$mapTo$iv$iv2;
        Object element$iv32;
        Intrinsics.checkNotNullParameter((Object)$this$finalizing, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)origins, (String)"origins");
        Iterable $this$forEach$iv = $this$finalizing.getProjectExtension().getFinalizeActions$kover_gradle_plugin();
        boolean $i$f$forEach = false;
        for (Object element$iv32 : $this$forEach$iv) {
            Function0 action = (Function0)element$iv32;
            boolean bl = false;
            try {
                action.invoke();
            }
            catch (Exception e) {
                throw new KoverCriticalException("An error occurred while executing before Kover finalize action", e);
            }
        }
        Iterable $this$map$iv = origins.getJvm();
        boolean $i$f$map = false;
        element$iv32 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator e = $this$mapTo$iv$iv2.iterator();
        while (e.hasNext()) {
            void providedDetails;
            Object item$iv$iv = e.next();
            JvmVariantOrigin jvmVariantOrigin = (JvmVariantOrigin)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FinalizeKoverKt.createVariant((JvmVariantOrigin)providedDetails, providedDetails.getTargetName(), $this$finalizing, FinalizeKoverKt.variantConfig($this$finalizing, providedDetails.getTargetName())));
        }
        List jvmVariants = (List)destination$iv$iv;
        Iterable $this$forEach$iv2 = jvmVariants;
        boolean $i$f$forEach2 = false;
        for (Object element$iv22 : $this$forEach$iv2) {
            JvmVariantArtifacts variant = (JvmVariantArtifacts)element$iv22;
            boolean bl = false;
            Project project = $this$finalizing.getProject();
            String string = variant.getVariantName();
            Provider<CoverageTool> provider = $this$finalizing.getToolProvider();
            String string2 = variant.getVariantName();
            String string3 = $this$finalizing.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.path");
            new VariantReportsSet(project, string, ReportVariantType.JVM, provider, FinalizeKoverKt.reportsConfig($this$finalizing, string2, string3), $this$finalizing.getReporterClasspath(), (Provider<Boolean>)((Provider)$this$finalizing.getProjectExtension().getKoverDisabled$kover_gradle_plugin())).assign$kover_gradle_plugin(variant);
        }
        Iterable $this$map$iv2 = origins.getAndroid();
        boolean $i$f$map2 = false;
        element$iv22 = $this$map$iv2;
        Iterator destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void providedDetails;
            AndroidVariantOrigin bl = (AndroidVariantOrigin)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(FinalizeKoverKt.createVariant((AndroidVariantOrigin)providedDetails, $this$finalizing, FinalizeKoverKt.variantConfig($this$finalizing, providedDetails.getBuildVariant().getBuildVariant())));
        }
        List androidVariants = (List)((Object)destination$iv$iv2);
        Map variantArtifacts = new LinkedHashMap();
        Iterable $this$forEach$iv3 = jvmVariants;
        boolean $i$f$forEach3 = false;
        for (Object element$iv4 : $this$forEach$iv3) {
            it = (JvmVariantArtifacts)element$iv4;
            boolean bl = false;
            variantArtifacts.put(it.getVariantName(), it);
        }
        $this$forEach$iv3 = androidVariants;
        $i$f$forEach3 = false;
        for (Object element$iv5 : $this$forEach$iv3) {
            it = (AndroidVariantArtifacts)element$iv5;
            boolean bl = false;
            variantArtifacts.put(it.getVariantName(), it);
        }
        TotalVariantArtifacts totalVariant = new TotalVariantArtifacts($this$finalizing.getProject(), $this$finalizing.getToolProvider(), $this$finalizing.getKoverBucketConfiguration(), FinalizeKoverKt.variantConfig($this$finalizing, ""), $this$finalizing.getProjectExtension());
        Map<String, KoverReportSetConfigImpl> $this$forEach$iv4 = variantArtifacts.values();
        boolean $i$f$forEach4 = false;
        Iterator<Object> iterator = $this$forEach$iv4.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            AbstractVariantArtifacts it2 = (AbstractVariantArtifacts)element$iv;
            boolean bl = false;
            totalVariant.mergeWith(it2);
        }
        $this$finalizing.getTotalReports().assign$kover_gradle_plugin(totalVariant);
        $this$forEach$iv4 = $this$finalizing.getProjectExtension().getCurrentProject().getProvidedVariants$kover_gradle_plugin();
        $i$f$forEach4 = false;
        iterator = $this$forEach$iv4.entrySet().iterator();
        while (iterator.hasNext()) {
            Object it2 = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String name = (String)it2.getKey();
            if (variantArtifacts.containsKey(name)) continue;
            throw new KoverIllegalConfigException("It is unacceptable to configure provided variant '" + name + "', since there is no such variant in the project.\nAcceptable variants: " + variantArtifacts.keySet());
        }
        $this$forEach$iv4 = $this$finalizing.getProjectExtension().getCurrentProject().getCustomVariants$kover_gradle_plugin();
        $i$f$forEach4 = false;
        iterator = $this$forEach$iv4.entrySet().iterator();
        while (iterator.hasNext()) {
            Object it2 = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String name = (String)it2.getKey();
            KoverVariantCreateConfigImpl config = (KoverVariantCreateConfigImpl)it2.getValue();
            if (Intrinsics.areEqual((Object)name, (Object)"jvm")) {
                throw new KoverIllegalConfigException("It is unacceptable to create a custom reports variant 'jvm', because this name is reserved for JVM code");
            }
            if (variantArtifacts.containsKey(name)) {
                throw new KoverIllegalConfigException("It is unacceptable to create a custom reports variant '" + name + "', because this name is reserved for provided Android reports variant.");
            }
            CustomVariantArtifacts customVariant = new CustomVariantArtifacts($this$finalizing.getProject(), name, $this$finalizing.getToolProvider(), $this$finalizing.getKoverBucketConfiguration(), config, $this$finalizing.getProjectExtension());
            Map<String, MergingOptionality> $this$forEach$iv5 = config.getVariantsByName$kover_gradle_plugin();
            boolean $i$f$forEach5 = false;
            Iterator<Map.Entry<String, MergingOptionality>> iterator2 = $this$forEach$iv5.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, MergingOptionality> element$iv6;
                Map.Entry<String, MergingOptionality> entry = element$iv6 = iterator2.next();
                boolean bl3 = false;
                String mergedName = entry.getKey();
                MergingOptionality optionality = entry.getValue();
                AbstractVariantArtifacts mergedVariant = (AbstractVariantArtifacts)variantArtifacts.get(mergedName);
                if (mergedVariant != null) {
                    if (optionality.getWithDependencies()) {
                        customVariant.mergeWithDependencies(mergedVariant);
                        continue;
                    }
                    customVariant.mergeWith(mergedVariant);
                    continue;
                }
                if (optionality.getOptional()) continue;
                throw new KoverIllegalConfigException("Could not find the provided variant '" + mergedName + "' to create a custom variant '" + name + "'.\nSpecify an existing 'jvm' variant or Android build variant name, or delete the merge.");
            }
            variantArtifacts.put(name, customVariant);
            Project project = $this$finalizing.getProject();
            Provider<CoverageTool> provider = $this$finalizing.getToolProvider();
            String string = $this$finalizing.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
            new VariantReportsSet(project, name, ReportVariantType.CUSTOM, provider, FinalizeKoverKt.reportsConfig($this$finalizing, name, string), $this$finalizing.getReporterClasspath(), (Provider<Boolean>)((Provider)$this$finalizing.getProjectExtension().getKoverDisabled$kover_gradle_plugin())).assign$kover_gradle_plugin(customVariant);
        }
        $this$forEach$iv4 = $this$finalizing.getProjectExtension().getCurrentProject().getVariantsToCopy$kover_gradle_plugin();
        $i$f$forEach4 = false;
        iterator = $this$forEach$iv4.entrySet().iterator();
        while (iterator.hasNext()) {
            AbstractVariantArtifacts originalVariant;
            Object it2 = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String name = (String)it2.getKey();
            String originVariantName = (String)it2.getValue();
            if ((AbstractVariantArtifacts)variantArtifacts.get(originVariantName) == null) {
                throw new KoverIllegalConfigException("Cannot create a variant '" + name + "': the original variant '" + originVariantName + "' does not exist.");
            }
            Project project = $this$finalizing.getProject();
            Provider<CoverageTool> provider = $this$finalizing.getToolProvider();
            String string = $this$finalizing.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
            new VariantReportsSet(project, name, ReportVariantType.CUSTOM, provider, FinalizeKoverKt.reportsConfig($this$finalizing, name, string), $this$finalizing.getReporterClasspath(), (Provider<Boolean>)((Provider)$this$finalizing.getProjectExtension().getKoverDisabled$kover_gradle_plugin())).assign$kover_gradle_plugin(originalVariant);
        }
        $this$forEach$iv4 = androidVariants;
        $i$f$forEach4 = false;
        iterator = $this$forEach$iv4.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            AndroidVariantArtifacts androidVariant = (AndroidVariantArtifacts)element$iv;
            boolean bl = false;
            Project project = $this$finalizing.getProject();
            String string = androidVariant.getVariantName();
            Provider<CoverageTool> provider = $this$finalizing.getToolProvider();
            String string4 = androidVariant.getVariantName();
            String string5 = $this$finalizing.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"project.path");
            new VariantReportsSet(project, string, ReportVariantType.ANDROID, provider, FinalizeKoverKt.reportsConfig($this$finalizing, string4, string5), $this$finalizing.getReporterClasspath(), (Provider<Boolean>)((Provider)$this$finalizing.getProjectExtension().getKoverDisabled$kover_gradle_plugin())).assign$kover_gradle_plugin(androidVariant);
        }
        $this$forEach$iv4 = $this$finalizing.getProjectExtension().getReports().getByName$kover_gradle_plugin();
        $i$f$forEach4 = false;
        iterator = $this$forEach$iv4.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String requestedVariant = (String)object.getKey();
            if (variantArtifacts.containsKey(requestedVariant) || $this$finalizing.getProjectExtension().getCurrentProject().getVariantsToCopy$kover_gradle_plugin().containsKey(requestedVariant)) continue;
            throw new KoverIllegalConfigException("It is not possible to configure the '" + requestedVariant + "' variant because it does not exist");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final KoverVariantCreateConfigImpl variantConfig(KoverContext $this$variantConfig, String variantName) {
        KoverVariantCreateConfigImpl koverVariantCreateConfigImpl = $this$variantConfig.getProjectExtension().getCurrentProject().getCustomVariants$kover_gradle_plugin().get(variantName);
        if (koverVariantCreateConfigImpl == null) {
            void $this$newInstance$iv;
            boolean bl = false;
            ObjectFactory objectFactory = $this$variantConfig.getProjectExtension().getCurrentProject().getObjects();
            Object[] objectArray = new Object[]{variantName};
            Object[] parameters$iv = objectArray;
            boolean $i$f$newInstance = false;
            Object object = $this$newInstance$iv.newInstance(KoverVariantCreateConfigImpl.class, Arrays.copyOf(parameters$iv, parameters$iv.length));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newInstance(...)");
            KoverVariantCreateConfigImpl variantConfig = (KoverVariantCreateConfigImpl)object;
            variantConfig.deriveFrom$kover_gradle_plugin($this$variantConfig.getProjectExtension().getCurrentProject());
            koverVariantCreateConfigImpl = variantConfig;
        }
        return koverVariantCreateConfigImpl;
    }

    private static final KoverReportSetConfigImpl reportsConfig(KoverContext $this$reportsConfig, String variantName, String projectPath) {
        KoverReportSetConfigImpl koverReportSetConfigImpl = $this$reportsConfig.getProjectExtension().getReports().getByName$kover_gradle_plugin().get(variantName);
        if (koverReportSetConfigImpl == null) {
            boolean bl = false;
            koverReportSetConfigImpl = $this$reportsConfig.getProjectExtension().getReports().createReportSet$kover_gradle_plugin(variantName, projectPath);
        }
        return koverReportSetConfigImpl;
    }

    private static final JvmVariantArtifacts createVariant(JvmVariantOrigin $this$createVariant, String variantName, KoverContext koverContext, KoverVariantCreateConfigImpl config) {
        JvmTestTaskConfiguratorKt.instrument($this$createVariant.getTests(), koverContext, (Provider<Boolean>)((Provider)koverContext.getProjectExtension().getKoverDisabled$kover_gradle_plugin()), koverContext.getProjectExtension().getCurrentProject());
        return new JvmVariantArtifacts(variantName, koverContext.getProject(), koverContext.getToolProvider(), koverContext.getKoverBucketConfiguration(), $this$createVariant, config, koverContext.getProjectExtension());
    }

    private static final AndroidVariantArtifacts createVariant(AndroidVariantOrigin $this$createVariant, KoverContext koverContext, KoverVariantCreateConfigImpl config) {
        JvmTestTaskConfiguratorKt.instrument($this$createVariant.getTests(), koverContext, (Provider<Boolean>)((Provider)koverContext.getProjectExtension().getKoverDisabled$kover_gradle_plugin()), koverContext.getProjectExtension().getCurrentProject());
        return new AndroidVariantArtifacts(koverContext.getProject(), $this$createVariant.getBuildVariant().getBuildVariant(), koverContext.getToolProvider(), koverContext.getKoverBucketConfiguration(), $this$createVariant, config, koverContext.getProjectExtension());
    }
}

