/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.appliers.FinalizeKoverKt;
import kotlinx.kover.gradle.plugin.appliers.KoverContext;
import kotlinx.kover.gradle.plugin.appliers.KoverMergeKt;
import kotlinx.kover.gradle.plugin.appliers.PrepareKoverKt;
import kotlinx.kover.gradle.plugin.appliers.origin.AllVariantOrigins;
import kotlinx.kover.gradle.plugin.locators.ProvidedVariantsLocator;
import kotlinx.kover.gradle.plugin.util.SemVer;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lkotlinx/kover/gradle/plugin/KoverGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "target", "checkVersion", "Lorg/gradle/api/invocation/Gradle;", "kover-gradle-plugin"})
public final class KoverGradlePlugin
implements Plugin<Project> {
    public void apply(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Gradle gradle = target.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"target.gradle");
        this.checkVersion(gradle);
        KoverContext context = PrepareKoverKt.prepare(target);
        target.afterEvaluate(new Action(context){
            final /* synthetic */ KoverContext $context;
            {
                this.$context = $context;
            }

            public final void execute(Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                KoverMergeKt.prepareMerging(this.$context);
            }
        });
        new ProvidedVariantsLocator(target, (Function1<? super AllVariantOrigins, Unit>)((Function1)new Function1<AllVariantOrigins, Unit>(context){
            final /* synthetic */ KoverContext $context;
            {
                this.$context = $context;
                super(1);
            }

            public final void invoke(AllVariantOrigins provided) {
                Intrinsics.checkNotNullParameter((Object)provided, (String)"provided");
                FinalizeKoverKt.finalizing(this.$context, provided);
            }
        }));
    }

    private final void checkVersion(Gradle $this$checkVersion) {
        String string = $this$checkVersion.getGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gradleVersion");
        SemVer semVer = SemVer.Companion.ofVariableOrNull(string);
        Intrinsics.checkNotNull((Object)semVer);
        SemVer current = semVer;
        SemVer semVer2 = SemVer.Companion.ofVariableOrNull("6.8");
        Intrinsics.checkNotNull((Object)semVer2);
        SemVer min = semVer2;
        if (current.compareTo(min) < 0) {
            throw new GradleException("Gradle version '" + $this$checkVersion.getGradleVersion() + "' is not supported by Kover Plugin. Minimal supported version is '6.8'");
        }
    }
}

