/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.JsonParserKt;
import kotlinx.serialization.json.JsonParsingException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0005\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\fH\u0002J\u0018\u0010%\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\fH\u0002J \u0010&\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\fH\u0002J\u0018\u0010)\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\fH\u0002J\u0018\u0010*\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\fH\u0002J\u0006\u0010+\u001a\u00020 J$\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020\u00162\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030/H\u0080\b\u00a2\u0006\u0002\b0J\u0006\u00101\u001a\u00020 J\u0006\u00102\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000f\"\u0004\b\u001e\u0010\u0011\u00a8\u00063"}, d2={"Lkotlinx/serialization/json/Parser;", "", "source", "", "(Ljava/lang/String;)V", "buf", "", "canBeginValue", "", "getCanBeginValue", "()Z", "<set-?>", "", "curPos", "getCurPos", "()I", "setCurPos", "(I)V", "length", "offset", "getSource", "()Ljava/lang/String;", "", "tc", "getTc", "()B", "setTc", "(B)V", "tokenPos", "getTokenPos", "setTokenPos", "append", "", "ch", "", "appendEsc", "startPos", "appendHex", "appendRange", "fromIndex", "toIndex", "nextLiteral", "nextString", "nextToken", "requireTc", "expected", "lazyErrorMsg", "Lkotlin/Function0;", "requireTc$kotlinx_serialization_runtime", "skipElement", "takeStr", "kotlinx-serialization-runtime"})
public final class Parser {
    private int curPos;
    private int tokenPos;
    private byte tc;
    private int offset;
    private int length;
    private char[] buf;
    @NotNull
    private final String source;

    public final int getCurPos() {
        return this.curPos;
    }

    private final void setCurPos(int n) {
        this.curPos = n;
    }

    public final int getTokenPos() {
        return this.tokenPos;
    }

    private final void setTokenPos(int n) {
        this.tokenPos = n;
    }

    public final byte getTc() {
        return this.tc;
    }

    private final void setTc(byte by) {
        this.tc = by;
    }

    /*
     * WARNING - void declaration
     */
    public final void requireTc$kotlinx_serialization_runtime(byte expected, @NotNull Function0<String> lazyErrorMsg) {
        Intrinsics.checkParameterIsNotNull(lazyErrorMsg, (String)"lazyErrorMsg");
        if (this.getTc() != expected) {
            void pos$iv;
            int n = this.getTokenPos();
            String msg$iv = (String)lazyErrorMsg.invoke();
            throw (Throwable)new JsonParsingException((int)pos$iv, msg$iv);
        }
    }

    public final boolean getCanBeginValue() {
        boolean bl;
        switch (this.tc) {
            case 0: 
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String takeStr() {
        String string;
        int n;
        int n2;
        Object object;
        if (this.tc != 0 && this.tc != 1) {
            void pos$iv;
            int n3 = this.tokenPos;
            String msg$iv = "Expected string or non-null literal";
            throw (Throwable)new JsonParsingException((int)pos$iv, msg$iv);
        }
        if (this.offset < 0) {
            object = this.buf;
            n2 = 0;
            n = this.length;
            string = new String((char[])object, n2, n);
        } else {
            object = this.source;
            n2 = this.offset;
            n = this.offset + this.length;
            Object object2 = object;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)object2).substring(n2, n);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        String prevStr = string;
        this.nextToken();
        return prevStr;
    }

    private final void append(char ch) {
        if (this.length >= this.buf.length) {
            char[] cArray = this.buf;
            int n = 2 * this.buf.length;
            Parser parser = this;
            char[] cArray2 = Arrays.copyOf(cArray, n);
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            char[] cArray3 = cArray2;
            parser.buf = cArray3;
        }
        int n = this.length;
        this.length = n + 1;
        this.buf[n] = ch;
    }

    /*
     * WARNING - void declaration
     */
    private final void appendRange(String source, int fromIndex, int toIndex) {
        int n;
        int oldLen = this.length;
        int addLen = toIndex - fromIndex;
        int newLen = oldLen + addLen;
        if (newLen > this.buf.length) {
            char[] cArray = this.buf;
            n = RangesKt.coerceAtLeast((int)newLen, (int)(2 * this.buf.length));
            Parser parser = this;
            char[] cArray2 = Arrays.copyOf(cArray, n);
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            char[] cArray3 = cArray2;
            parser.buf = cArray3;
        }
        int n2 = 0;
        n = addLen;
        while (n2 < n) {
            void i;
            this.buf[oldLen + i] = source.charAt(fromIndex + i);
            ++i;
        }
        this.length += addLen;
    }

    public final void nextToken() {
        byte tc;
        String source = this.source;
        int curPos = this.curPos;
        int maxLen = source.length();
        block5: while (true) {
            if (curPos >= maxLen) {
                this.tokenPos = curPos;
                this.tc = (byte)12;
                return;
            }
            char ch = source.charAt(curPos);
            tc = JsonParserKt.charToTokenClass(ch);
            switch (tc) {
                case 3: {
                    ++curPos;
                    continue block5;
                }
                case 0: {
                    this.nextLiteral(source, curPos);
                    return;
                }
                case 1: {
                    this.nextString(source, curPos);
                    return;
                }
            }
            break;
        }
        this.tokenPos = curPos;
        this.tc = tc;
        this.curPos = curPos + 1;
    }

    private final void nextLiteral(String source, int startPos) {
        this.tokenPos = startPos;
        this.offset = startPos;
        int curPos = startPos;
        int maxLen = source.length();
        while (++curPos < maxLen && JsonParserKt.charToTokenClass(source.charAt(curPos)) == 0) {
        }
        this.curPos = curPos;
        this.length = curPos - this.offset;
        this.tc = (byte)(JsonParserKt.access$rangeEquals(source, this.offset, this.length, "null") ? 10 : 0);
    }

    private final void nextString(String source, int startPos) {
        int curPos;
        this.tokenPos = startPos;
        this.length = 0;
        int lastPos = curPos = startPos + 1;
        int maxLen = source.length();
        while (true) {
            if (curPos >= maxLen) {
                String msg$iv = "Unexpected end in string";
                throw (Throwable)new JsonParsingException(curPos, msg$iv);
            }
            if (source.charAt(curPos) == '\"') break;
            if (source.charAt(curPos) == '\\') {
                int newPos;
                this.appendRange(source, lastPos, curPos);
                curPos = newPos = this.appendEsc(source, curPos + 1);
                lastPos = newPos;
                continue;
            }
            ++curPos;
        }
        if (lastPos == startPos + 1) {
            this.offset = lastPos;
            this.length = curPos - lastPos;
        } else {
            this.appendRange(source, lastPos, curPos);
            this.offset = -1;
        }
        this.curPos = curPos + 1;
        this.tc = 1;
    }

    private final int appendEsc(String source, int startPos) {
        char curChar;
        boolean condition$iv;
        int curPos = startPos;
        boolean bl = condition$iv = curPos < source.length();
        if (!condition$iv) {
            String msg$iv$iv = "Unexpected end after escape char";
            throw (Throwable)new JsonParsingException(curPos, msg$iv$iv);
        }
        if ((curChar = source.charAt(curPos++)) == 'u') {
            curPos = this.appendHex(source, curPos);
        } else {
            boolean condition$iv2;
            char c = JsonParserKt.escapeToChar(curChar);
            boolean bl2 = condition$iv2 = c != '\u0000';
            if (!condition$iv2) {
                String msg$iv$iv = "Invalid escaped char '" + curChar + '\'';
                throw (Throwable)new JsonParsingException(curPos, msg$iv$iv);
            }
            this.append(c);
        }
        return curPos;
    }

    private final int appendHex(String source, int startPos) {
        int curPos = startPos;
        this.append((char)((JsonParserKt.access$fromHexChar(source, curPos++) << 12) + (JsonParserKt.access$fromHexChar(source, curPos++) << 8) + (JsonParserKt.access$fromHexChar(source, curPos++) << 4) + JsonParserKt.access$fromHexChar(source, curPos++)));
        return curPos;
    }

    public final void skipElement() {
        Collection collection;
        if (this.tc != 6 && this.tc != 8) {
            this.nextToken();
            return;
        }
        List tokenStack = new ArrayList();
        do {
            switch (this.tc) {
                case 6: 
                case 8: {
                    tokenStack.add(this.tc);
                    break;
                }
                case 9: {
                    if (((Number)CollectionsKt.last((List)tokenStack)).byteValue() != 8) {
                        throw (Throwable)new JsonParsingException(this.curPos, "found ] instead of }");
                    }
                    tokenStack.remove(tokenStack.size() - 1);
                    break;
                }
                case 7: {
                    if (((Number)CollectionsKt.last((List)tokenStack)).byteValue() != 6) {
                        throw (Throwable)new JsonParsingException(this.curPos, "found } instead of ]");
                    }
                    tokenStack.remove(tokenStack.size() - 1);
                }
            }
            this.nextToken();
        } while (!(collection = (Collection)tokenStack).isEmpty());
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    public Parser(@NotNull String source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.source = source;
        this.tc = (byte)12;
        this.offset = -1;
        this.buf = new char[16];
        this.nextToken();
    }

    public static final /* synthetic */ byte access$getTc$p(Parser $this) {
        return $this.tc;
    }

    public static final /* synthetic */ void access$setTc$p(Parser $this, byte by) {
        $this.tc = by;
    }

    public static final /* synthetic */ int access$getTokenPos$p(Parser $this) {
        return $this.tokenPos;
    }

    public static final /* synthetic */ void access$setTokenPos$p(Parser $this, int n) {
        $this.tokenPos = n;
    }
}

