/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.Parser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\tH\u0002J\u0006\u0010\u000b\u001a\u00020\tJ\b\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/json/JsonTreeParser;", "", "input", "", "(Ljava/lang/String;)V", "p", "Lkotlinx/serialization/json/Parser;", "(Lkotlinx/serialization/json/Parser;)V", "read", "Lkotlinx/serialization/json/JsonElement;", "readArray", "readFully", "readObject", "readValue", "isString", "", "kotlinx-serialization-runtime"})
public final class JsonTreeParser {
    private final Parser p;

    /*
     * WARNING - void declaration
     */
    private final JsonElement readObject() {
        void this_$iv;
        void this_$iv2;
        Parser parser = this.p;
        byte expected$iv = 6;
        if (this_$iv2.getTc() != expected$iv) {
            void pos$iv$iv;
            int n = this_$iv2.getTokenPos();
            String msg$iv$iv = "Expected start of object";
            throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv$iv + ": " + msg$iv$iv);
        }
        this.p.nextToken();
        Map result = new HashMap();
        while (true) {
            void this_$iv3;
            if (this.p.getTc() == 4) {
                this.p.nextToken();
            }
            if (!this.p.getCanBeginValue()) break;
            String key = this.p.takeStr();
            Parser pos$iv$iv = this.p;
            byte expected$iv22 = 5;
            if (this_$iv3.getTc() != expected$iv22) {
                void pos$iv$iv2;
                int msg$iv$iv = this_$iv3.getTokenPos();
                String msg$iv$iv2 = "Expected ':'";
                throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv$iv2 + ": " + msg$iv$iv2);
            }
            this.p.nextToken();
            JsonElement elem = this.read();
            Map expected$iv22 = result;
            JsonElement pos$iv$iv2 = elem;
            expected$iv22.put(key, pos$iv$iv2);
        }
        Parser key = this.p;
        byte expected$iv2 = 7;
        if (this_$iv.getTc() != expected$iv2) {
            void pos$iv$iv;
            int expected$iv22 = this_$iv.getTokenPos();
            String msg$iv$iv = "Expected end of object";
            throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv$iv + ": " + msg$iv$iv);
        }
        this.p.nextToken();
        return new JsonObject(result);
    }

    private final JsonElement readValue(boolean isString) {
        String str = this.p.takeStr();
        return new JsonLiteral(str, isString);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonElement readArray() {
        void this_$iv;
        void this_$iv2;
        Parser parser = this.p;
        byte expected$iv = 8;
        if (this_$iv2.getTc() != expected$iv) {
            void pos$iv$iv;
            int n = this_$iv2.getTokenPos();
            String msg$iv$iv = "Expected start of array";
            throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv$iv + ": " + msg$iv$iv);
        }
        this.p.nextToken();
        List result = new ArrayList();
        while (true) {
            if (this.p.getTc() == 4) {
                this.p.nextToken();
            }
            if (!this.p.getCanBeginValue()) break;
            JsonElement elem = this.read();
            result.add(elem);
        }
        Parser elem = this.p;
        byte expected$iv2 = 9;
        if (this_$iv.getTc() != expected$iv2) {
            void pos$iv$iv;
            int $i$a$1$requireTc = this_$iv.getTokenPos();
            String msg$iv$iv = "Expected end of array";
            throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv$iv + ": " + msg$iv$iv);
        }
        this.p.nextToken();
        return new JsonArray(result);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonElement read() {
        JsonElement jsonElement;
        if (!this.p.getCanBeginValue()) {
            void pos$iv;
            int n = this.p.getCurPos();
            String msg$iv = "Can't begin reading value from here";
            throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv + ": " + msg$iv);
        }
        byte tc = this.p.getTc();
        switch (tc) {
            case 10: {
                JsonNull msg$iv;
                JsonNull it = msg$iv = JsonNull.INSTANCE;
                this.p.nextToken();
                jsonElement = msg$iv;
                break;
            }
            case 1: {
                jsonElement = this.readValue(true);
                break;
            }
            case 0: {
                jsonElement = this.readValue(false);
                break;
            }
            case 6: {
                jsonElement = this.readObject();
                break;
            }
            case 8: {
                jsonElement = this.readArray();
                break;
            }
            default: {
                void pos$iv;
                int msg$iv = this.p.getCurPos();
                String msg$iv2 = "Can't begin reading element";
                throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv + ": " + msg$iv2);
            }
        }
        return jsonElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonElement readFully() {
        void this_$iv;
        JsonElement r = this.read();
        Parser parser = this.p;
        byte expected$iv = 12;
        if (this_$iv.getTc() != expected$iv) {
            void pos$iv$iv;
            int n = this_$iv.getTokenPos();
            String msg$iv$iv = "Input wasn't consumed fully";
            throw (Throwable)new IllegalArgumentException("JSON at " + (int)pos$iv$iv + ": " + msg$iv$iv);
        }
        return r;
    }

    public JsonTreeParser(@NotNull Parser p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        this.p = p;
    }

    public JsonTreeParser(@NotNull String input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        this(new Parser(input));
    }
}

