/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u0007\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\u0001H\u0086\bJ&\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u0007\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006J'\u0010\f\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u0007\"\b\b\u0000\u0010\t*\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u0001H\t\u00a2\u0006\u0002\u0010\u000eJ,\u0010\u000f\u001a\u00020\u0010\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\t0\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007J\"\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u0007\"\b\b\u0000\u0010\t*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\t0\u0006R\"\u0010\u0004\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkotlinx/serialization/SerialContext;", "", "parentContext", "(Lkotlinx/serialization/SerialContext;)V", "classMap", "", "Lkotlin/reflect/KClass;", "Lkotlinx/serialization/KSerializer;", "getSerializer", "T", "getSerializerByClass", "klass", "getSerializerByValue", "value", "(Ljava/lang/Object;)Lkotlinx/serialization/KSerializer;", "registerSerializer", "", "forClass", "serializer", "kotlinx-serialization-runtime"})
public final class SerialContext {
    private final Map<KClass<?>, KSerializer<?>> classMap;
    private final SerialContext parentContext;

    public final <T> void registerSerializer(@NotNull KClass<T> forClass, @NotNull KSerializer<T> serializer) {
        Intrinsics.checkParameterIsNotNull(forClass, (String)"forClass");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.classMap.put(forClass, serializer);
    }

    @Nullable
    public final <T> KSerializer<T> getSerializer(@NotNull KClass<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return this.getSerializerByClass($receiver);
    }

    @Nullable
    public final <T> KSerializer<T> getSerializerByValue(@Nullable T value) {
        if (value == null) {
            throw (Throwable)new SerializationException("Cannot determine class for value " + value);
        }
        T t = value;
        KClass klass = Reflection.getOrCreateKotlinClass(t.getClass());
        KSerializer<T> kSerializer = this.getSerializerByClass(klass);
        if (!(kSerializer instanceof KSerializer)) {
            kSerializer = null;
        }
        return kSerializer;
    }

    private final <T> KSerializer<T> getSerializer() {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.getSerializerByClass(Reflection.getOrCreateKotlinClass(Object.class));
    }

    @Nullable
    public final <T> KSerializer<T> getSerializerByClass(@NotNull KClass<T> klass) {
        KSerializer<Object> kSerializer;
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        KSerializer<?> kSerializer2 = this.classMap.get(klass);
        if (!(kSerializer2 instanceof KSerializer)) {
            kSerializer2 = kSerializer = null;
        }
        if (kSerializer2 == null) {
            SerialContext serialContext = this.parentContext;
            kSerializer = serialContext != null ? serialContext.getSerializerByClass(klass) : null;
        }
        return kSerializer;
    }

    public SerialContext(@Nullable SerialContext parentContext) {
        this.parentContext = parentContext;
        SerialContext serialContext = this;
        HashMap hashMap = new HashMap();
        serialContext.classMap = hashMap;
    }

    public /* synthetic */ SerialContext(SerialContext serialContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            serialContext = null;
        }
        this(serialContext);
    }

    public SerialContext() {
        this(null, 1, null);
    }
}

