/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.CompositeDecoder;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicClassDescriptor;
import kotlinx.serialization.PolymorphicKt;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00032\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0002H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lkotlinx/serialization/PolymorphicSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "baseClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "getBaseClass", "()Lkotlin/reflect/KClass;", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "findPolymorphicSerializer", "Lkotlinx/serialization/CompositeDecoder;", "klassName", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "serialize", "", "obj", "kotlinx-serialization-runtime"})
public final class PolymorphicSerializer<T>
implements KSerializer<Object> {
    @NotNull
    private final SerialDescriptor descriptor;
    @NotNull
    private final KClass<T> baseClass;

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        KSerializer<T> actualSerializer = this.findPolymorphicSerializer(encoder2, obj);
        CompositeEncoder compositeEncoder = encoder2.beginStructure(this.getDescriptor(), new KSerializer[0]);
        compositeEncoder.encodeStringElement(this.getDescriptor(), 0, actualSerializer.getDescriptor().getName());
        KSerializer<T> kSerializer = actualSerializer;
        if (kSerializer == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
        }
        compositeEncoder.encodeSerializableElement(this.getDescriptor(), 1, (SerializationStrategy)kSerializer, obj);
        compositeEncoder.endStructure(this.getDescriptor());
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Decoder decoder) {
        Object value;
        Object klassName;
        CompositeDecoder compositeDecoder;
        block6: {
            int index;
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            compositeDecoder = decoder.beginStructure(this.getDescriptor(), new KSerializer[0]);
            klassName = null;
            value = null;
            while (true) {
                KSerializer<T> serializer2;
                if ((index = compositeDecoder.decodeElementIndex(this.getDescriptor())) == -2) {
                    klassName = compositeDecoder.decodeStringElement(this.getDescriptor(), 0);
                    serializer2 = this.findPolymorphicSerializer(compositeDecoder, (String)klassName);
                    value = compositeDecoder.decodeSerializableElement(this.getDescriptor(), 1, serializer2);
                    break block6;
                }
                if (index == -1) break block6;
                if (index == 0) {
                    klassName = compositeDecoder.decodeStringElement(this.getDescriptor(), index);
                    continue;
                }
                if (index != 1) break;
                serializer2 = klassName;
                boolean bl = false;
                boolean bl2 = false;
                if (serializer2 == null) {
                    boolean bl3 = false;
                    String string = "Cannot read polymorphic value before its type token";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                KSerializer<T> kSerializer = serializer2;
                klassName = kSerializer;
                serializer2 = this.findPolymorphicSerializer(compositeDecoder, (String)klassName);
                value = compositeDecoder.decodeSerializableElement(this.getDescriptor(), index, serializer2);
            }
            StringBuilder stringBuilder = new StringBuilder().append("Invalid index in polymorphic deserialization of ");
            Object object = klassName;
            if (object == null) {
                object = "unknown class";
            }
            throw (Throwable)new SerializationException(stringBuilder.append((String)object).append(" with base ").append(this.baseClass).append("\n Expected 0, 1, READ_ALL(-2) or READ_DONE(-1), but found ").append(index).toString(), null, 2, null);
        }
        compositeDecoder.endStructure(this.getDescriptor());
        boolean bl = false;
        boolean bl4 = false;
        if (value == null) {
            boolean bl5 = false;
            String string = "Polymorphic value have not been read for class " + (String)klassName;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return value;
    }

    @NotNull
    public final KSerializer<? extends T> findPolymorphicSerializer(@NotNull CompositeDecoder decoder, @NotNull String klassName) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)klassName, (String)"klassName");
        KSerializer<T> kSerializer = decoder.getContext().getPolymorphic(this.baseClass, klassName);
        if (kSerializer == null) {
            Void void_ = PolymorphicKt.access$throwSubtypeNotRegistered(klassName, this.baseClass);
            throw null;
        }
        return kSerializer;
    }

    @NotNull
    public final KSerializer<? extends T> findPolymorphicSerializer(@NotNull Encoder encoder2, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        KSerializer<Object> kSerializer = encoder2.getContext().getPolymorphic(this.baseClass, value);
        if (kSerializer == null) {
            Void void_ = PolymorphicKt.access$throwSubtypeNotRegistered(Reflection.getOrCreateKotlinClass(value.getClass()), this.baseClass);
            throw null;
        }
        return kSerializer;
    }

    @NotNull
    public final KClass<T> getBaseClass() {
        return this.baseClass;
    }

    public PolymorphicSerializer(@NotNull KClass<T> baseClass) {
        Intrinsics.checkParameterIsNotNull(baseClass, (String)"baseClass");
        this.baseClass = baseClass;
        this.descriptor = PolymorphicClassDescriptor.INSTANCE;
    }

    @Override
    @NotNull
    public Object patch(@NotNull Decoder decoder, @NotNull Object old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        return KSerializer.DefaultImpls.patch(this, decoder, old);
    }
}

