/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.Serializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.NamedMapClassDescriptor;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.internal.JsonElementSerializer;
import org.jetbrains.annotations.NotNull;

@Serializer(forClass=JsonObject.class)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/json/internal/JsonObjectSerializer;", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/serialization/json/JsonObject;", "()V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "obj", "kotlinx-serialization-runtime"})
public final class JsonObjectSerializer
implements KSerializer<JsonObject> {
    @NotNull
    private static final SerialDescriptor descriptor;
    public static final JsonObjectSerializer INSTANCE;

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull JsonObject obj) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        new LinkedHashMapSerializer(StringSerializer.INSTANCE, JsonElementSerializer.INSTANCE).serialize(encoder2, obj.getContent());
    }

    @Override
    @NotNull
    public JsonObject deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        return new JsonObject((Map)new LinkedHashMapSerializer(StringSerializer.INSTANCE, JsonElementSerializer.INSTANCE).deserialize(decoder));
    }

    private JsonObjectSerializer() {
    }

    static {
        JsonObjectSerializer jsonObjectSerializer;
        INSTANCE = jsonObjectSerializer = new JsonObjectSerializer();
        descriptor = new NamedMapClassDescriptor("JsonObject", StringSerializer.INSTANCE.getDescriptor(), JsonElementSerializer.INSTANCE.getDescriptor());
    }

    @Override
    @NotNull
    public JsonObject patch(@NotNull Decoder decoder, @NotNull JsonObject old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        return KSerializer.DefaultImpls.patch(this, decoder, old);
    }
}

