/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.Serializer;
import kotlinx.serialization.UnionKind;
import kotlinx.serialization.internal.SerialClassDescImpl;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonInput;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonArraySerializer;
import kotlinx.serialization.json.internal.JsonObjectSerializer;
import kotlinx.serialization.json.internal.JsonPrimitiveSerializer;
import org.jetbrains.annotations.NotNull;

@Serializer(forClass=JsonElement.class)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/json/internal/JsonElementSerializer;", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/serialization/json/JsonElement;", "()V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "obj", "kotlinx-serialization-runtime"})
public final class JsonElementSerializer
implements KSerializer<JsonElement> {
    @NotNull
    private static final SerialDescriptor descriptor;
    public static final JsonElementSerializer INSTANCE;

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull JsonElement obj) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        JsonElement jsonElement = obj;
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitiveSerializer.INSTANCE.serialize(encoder2, (JsonPrimitive)obj);
        } else if (jsonElement instanceof JsonObject) {
            JsonObjectSerializer.INSTANCE.serialize(encoder2, (JsonObject)obj);
        } else if (jsonElement instanceof JsonArray) {
            JsonArraySerializer.INSTANCE.serialize(encoder2, (JsonArray)obj);
        }
    }

    @Override
    @NotNull
    public JsonElement deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Decoder decoder2 = decoder;
        if (!(decoder2 instanceof JsonInput)) {
            decoder2 = null;
        }
        JsonInput jsonInput = (JsonInput)decoder2;
        if (jsonInput == null) {
            String string = "JsonElement is deserializable only when used by Json";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        JsonInput input = jsonInput;
        return input.decodeJson();
    }

    private JsonElementSerializer() {
    }

    static {
        JsonElementSerializer jsonElementSerializer;
        INSTANCE = jsonElementSerializer = new JsonElementSerializer();
        descriptor = new SerialClassDescImpl("JsonElementSerializer"){

            @NotNull
            public SerialKind getKind() {
                return UnionKind.SEALED.INSTANCE;
            }
            {
                SerialClassDescImpl.addElement$default(this, "JsonElement", false, 2, null);
            }
        };
    }

    @Override
    @NotNull
    public JsonElement patch(@NotNull Decoder decoder, @NotNull JsonElement old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        return KSerializer.DefaultImpls.patch(this, decoder, old);
    }
}

