/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.html.stream;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.html.Entities;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import kotlinx.html.Unsafe;
import kotlinx.html.stream.StreamKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.events.Event;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001 \u0001*\u00060\u0002j\u0002`\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\r\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\"\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0016J!\u0010(\u001a\u00020\u00182\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180*\u00a2\u0006\u0002\b+H\u0016J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J,\u0010-\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00180*H\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u00061"}, d2={"Lkotlinx/html/stream/HTMLStreamBuilder;", "O", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "Lkotlinx/html/TagConsumer;", "out", "prettyPrint", "", "xhtmlCompatible", "(Ljava/lang/Appendable;ZZ)V", "UnsafeImpl", "Lkotlinx/html/Unsafe;", "getUnsafeImpl", "()Lkotlinx/html/Unsafe;", "level", "", "ln", "getOut", "()Ljava/lang/Appendable;", "Ljava/lang/Appendable;", "getPrettyPrint", "()Z", "getXhtmlCompatible", "appenln", "", "finalize", "indent", "onTagAttributeChange", "tag", "Lkotlinx/html/Tag;", "attribute", "", "value", "onTagComment", "content", "", "onTagContent", "onTagContentEntity", "entity", "Lkotlinx/html/Entities;", "onTagContentUnsafe", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "onTagEnd", "onTagEvent", "event", "Lorg/w3c/dom/events/Event;", "onTagStart", "kotlinx-html-jvm"})
public final class HTMLStreamBuilder<O extends Appendable>
implements TagConsumer<O> {
    private int level;
    private boolean ln;
    @NotNull
    private final Unsafe UnsafeImpl;
    @NotNull
    private final O out;
    private final boolean prettyPrint;
    private final boolean xhtmlCompatible;

    /*
     * WARNING - void declaration
     */
    @Override
    public void onTagStart(@NotNull Tag tag) {
        Map<String, String> map2;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.prettyPrint && !tag.getInlineTag()) {
            this.indent();
        }
        int n = this.level;
        this.level = n + 1;
        this.out.append("<");
        this.out.append(tag.getTagName());
        if (tag.getNamespace() != null) {
            this.out.append(" xmlns=\"");
            this.out.append(tag.getNamespace());
            this.out.append("\"");
        }
        if (!(map2 = tag.getAttributes()).isEmpty()) {
            Iterable $receiver$iv = tag.getAttributesEntries();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void e;
                int n2 = index$iv++;
                Map.Entry entry = (Map.Entry)item$iv;
                int $noName_0 = n2;
                if (!StreamKt.access$isValidXmlAttributeName((String)e.getKey())) {
                    throw (Throwable)new IllegalArgumentException("Tag " + tag.getTagName() + " has invalid attribute name " + (String)e.getKey());
                }
                this.out.append(' ');
                this.out.append((CharSequence)e.getKey());
                this.out.append("=\"");
                StreamKt.access$escapeAppend(this.out, (CharSequence)e.getValue());
                this.out.append('\"');
            }
        }
        if (this.xhtmlCompatible && tag.getEmptyTag()) {
            this.out.append("/");
        }
        this.out.append(">");
        this.ln = false;
    }

    @Override
    public void onTagAttributeChange(@NotNull Tag tag, @NotNull String attribute, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        throw (Throwable)new UnsupportedOperationException("tag attribute can't be changed as it was already written to the stream. Use with DelayedConsumer to be able to modify attributes");
    }

    @Override
    public void onTagEvent(@NotNull Tag tag, @NotNull String event, @NotNull Function1<? super Event, Unit> value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        throw (Throwable)new UnsupportedOperationException("you can't assign lambda event handler when building text");
    }

    @Override
    public void onTagEnd(@NotNull Tag tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        int n = this.level;
        this.level = n + -1;
        if (this.ln) {
            this.indent();
        }
        if (!tag.getEmptyTag()) {
            this.out.append("</");
            this.out.append(tag.getTagName());
            this.out.append(">");
        }
        if (this.prettyPrint && !tag.getInlineTag()) {
            this.appenln();
        }
    }

    @Override
    public void onTagContent(@NotNull CharSequence content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        StreamKt.access$escapeAppend(this.out, content);
        this.ln = false;
    }

    @Override
    public void onTagContentEntity(@NotNull Entities entity) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
        this.out.append(entity.getText());
        this.ln = false;
    }

    @Override
    @NotNull
    public O finalize() {
        return this.out;
    }

    @Override
    public void onTagContentUnsafe(@NotNull Function1<? super Unsafe, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        block.invoke((Object)this.UnsafeImpl);
    }

    @Override
    public void onTagComment(@NotNull CharSequence content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (this.prettyPrint) {
            this.indent();
        }
        this.out.append("<!--");
        StreamKt.access$escapeComment(this.out, content);
        this.out.append("-->");
        this.ln = false;
    }

    @NotNull
    public final Unsafe getUnsafeImpl() {
        return this.UnsafeImpl;
    }

    private final void appenln() {
        if (this.prettyPrint && !this.ln) {
            this.out.append("\n");
            this.ln = true;
        }
    }

    private final void indent() {
        if (this.prettyPrint) {
            int remaining;
            if (!this.ln) {
                this.out.append("\n");
            }
            for (remaining = this.level; remaining >= 4; remaining -= 4) {
                this.out.append("        ");
            }
            while (remaining >= 2) {
                this.out.append("    ");
                remaining -= 2;
            }
            if (remaining > 0) {
                this.out.append("  ");
            }
            this.ln = false;
        }
    }

    @NotNull
    public final O getOut() {
        return this.out;
    }

    public final boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public final boolean getXhtmlCompatible() {
        return this.xhtmlCompatible;
    }

    public HTMLStreamBuilder(@NotNull O out, boolean prettyPrint, boolean xhtmlCompatible) {
        Intrinsics.checkParameterIsNotNull(out, (String)"out");
        this.out = out;
        this.prettyPrint = prettyPrint;
        this.xhtmlCompatible = xhtmlCompatible;
        this.ln = true;
        this.UnsafeImpl = new Unsafe(this){
            final /* synthetic */ HTMLStreamBuilder this$0;

            public void unaryPlus(@NotNull String $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                this.this$0.getOut().append($receiver);
            }
            {
                this.this$0 = $outer;
            }

            public void unaryPlus(@NotNull Entities $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
                Unsafe.DefaultImpls.unaryPlus(this, $receiver);
            }

            public void raw(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                Unsafe.DefaultImpls.raw((Unsafe)this, s);
            }

            public void raw(@NotNull Entities entity) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
                Unsafe.DefaultImpls.raw((Unsafe)this, entity);
            }

            public void raw(@NotNull Number n) {
                Intrinsics.checkParameterIsNotNull((Object)n, (String)"n");
                Unsafe.DefaultImpls.raw((Unsafe)this, n);
            }
        };
    }

    @Override
    public void onTagError(@NotNull Tag tag, @NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        TagConsumer.DefaultImpls.onTagError(this, tag, exception);
    }
}

