package kotlinx.html

import kotlinx.html.*
import kotlinx.html.impl.*
import kotlinx.html.attributes.*

/*******************************************************************************
    DO NOT EDIT
    This file was generated by module generate
*******************************************************************************/

/**
 * Anchor
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.a(href : String? = null, target : String? = null, classes : String? = null, block : A.() -> Unit = {}) : T = A(attributesMapOf("href", href,"target", target,"class", classes), this).visitAndFinalize(this, block)

/**
 * Abbreviated form (e.g., WWW, HTTP,etc.)
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.abbr(classes : String? = null, block : ABBR.() -> Unit = {}) : T = ABBR(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Information on author
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.address(classes : String? = null, block : ADDRESS.() -> Unit = {}) : T = ADDRESS(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Client-side image map area
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.area(shape : AreaShape? = null, alt : String? = null, classes : String? = null, block : AREA.() -> Unit = {}) : T = AREA(attributesMapOf("Shape", shape?.enumEncode(),"alt", alt,"class", classes), this).visitAndFinalize(this, block)

/**
 * Self-contained syndicatable or reusable composition
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.article(classes : String? = null, block : ARTICLE.() -> Unit = {}) : T = ARTICLE(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Sidebar for tangentially related content
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.aside(classes : String? = null, block : ASIDE.() -> Unit = {}) : T = ASIDE(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Audio player
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.audio(classes : String? = null, block : AUDIO.() -> Unit = {}) : T = AUDIO(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Bold text style
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.b(classes : String? = null, block : B.() -> Unit = {}) : T = B(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Document base URI
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.base(classes : String? = null, block : BASE.() -> Unit = {}) : T = BASE(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Text directionality isolation
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.bdi(classes : String? = null, block : BDI.() -> Unit = {}) : T = BDI(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * I18N BiDi over-ride
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.bdo(classes : String? = null, block : BDO.() -> Unit = {}) : T = BDO(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Long quotation
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.blockQuote(classes : String? = null, block : BLOCKQUOTE.() -> Unit = {}) : T = BLOCKQUOTE(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Document body
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.body(classes : String? = null, block : BODY.() -> Unit = {}) : T = BODY(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Forced line break
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.br(classes : String? = null, block : BR.() -> Unit = {}) : T = BR(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Push button
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.button(formEncType : ButtonFormEncType? = null, formMethod : ButtonFormMethod? = null, name : String? = null, type : ButtonType? = null, classes : String? = null, block : BUTTON.() -> Unit = {}) : T = BUTTON(attributesMapOf("formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"type", type?.enumEncode(),"class", classes), this).visitAndFinalize(this, block)

/**
 * Scriptable bitmap canvas
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.canvas(classes : String? = null, content : String = "") : T = CANVAS(attributesMapOf("class", classes), this).visitAndFinalize(this, {+content})
/**
 * Scriptable bitmap canvas
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.canvas(classes : String? = null, block : CANVAS.() -> Unit = {}) : T = CANVAS(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Table caption
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.caption(classes : String? = null, block : CAPTION.() -> Unit = {}) : T = CAPTION(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Citation
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.cite(classes : String? = null, block : CITE.() -> Unit = {}) : T = CITE(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Computer code fragment
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.code(classes : String? = null, block : CODE.() -> Unit = {}) : T = CODE(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Table column
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.col(classes : String? = null, block : COL.() -> Unit = {}) : T = COL(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Table column group
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.colGroup(classes : String? = null, block : COLGROUP.() -> Unit = {}) : T = COLGROUP(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.command(type : CommandType? = null, classes : String? = null, block : COMMAND.() -> Unit = {}) : T = COMMAND(attributesMapOf("type", type?.enumEncode(),"class", classes), this).visitAndFinalize(this, block)

/**
 * Container for options for 
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.dataList(classes : String? = null, block : DATALIST.() -> Unit = {}) : T = DATALIST(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Definition description
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.dd(classes : String? = null, block : DD.() -> Unit = {}) : T = DD(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Deleted text
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.del(classes : String? = null, block : DEL.() -> Unit = {}) : T = DEL(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Disclosure control for hiding details
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.details(classes : String? = null, block : DETAILS.() -> Unit = {}) : T = DETAILS(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Instance definition
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.dfn(classes : String? = null, block : DFN.() -> Unit = {}) : T = DFN(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Dialog box or window
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.dialog(classes : String? = null, block : DIALOG.() -> Unit = {}) : T = DIALOG(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Generic language/style container
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.div(classes : String? = null, block : DIV.() -> Unit = {}) : T = DIV(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Definition list
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.dl(classes : String? = null, block : DL.() -> Unit = {}) : T = DL(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Definition term
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.dt(classes : String? = null, block : DT.() -> Unit = {}) : T = DT(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Emphasis
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.em(classes : String? = null, block : EM.() -> Unit = {}) : T = EM(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Plugin
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.embed(classes : String? = null, block : EMBED.() -> Unit = {}) : T = EMBED(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Form control group
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.fieldSet(classes : String? = null, block : FIELDSET.() -> Unit = {}) : T = FIELDSET(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Caption for 
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.figcaption(classes : String? = null, block : FIGCAPTION.() -> Unit = {}) : T = FIGCAPTION(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Figure with optional caption
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.figure(classes : String? = null, block : FIGURE.() -> Unit = {}) : T = FIGURE(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Footer for a page or section
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.footer(classes : String? = null, block : FOOTER.() -> Unit = {}) : T = FOOTER(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Interactive form
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.form(action : String? = null, encType : FormEncType? = null, method : FormMethod? = null, classes : String? = null, block : FORM.() -> Unit = {}) : T = FORM(attributesMapOf("action", action,"enctype", encType?.enumEncode(),"method", method?.enumEncode(),"class", classes), this).visitAndFinalize(this, block)

/**
 * Heading
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.h1(classes : String? = null, block : H1.() -> Unit = {}) : T = H1(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Heading
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.h2(classes : String? = null, block : H2.() -> Unit = {}) : T = H2(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Heading
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.h3(classes : String? = null, block : H3.() -> Unit = {}) : T = H3(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Heading
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.h4(classes : String? = null, block : H4.() -> Unit = {}) : T = H4(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Heading
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.h5(classes : String? = null, block : H5.() -> Unit = {}) : T = H5(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Heading
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.h6(classes : String? = null, block : H6.() -> Unit = {}) : T = H6(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

@Deprecated("This tag doesn't support content or requires unsafe (try unsafe {})")
@Suppress("DEPRECATION")
/**
 * Document head
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.head(content : String = "") : T = HEAD(emptyMap, this).visitAndFinalize(this, {+content})
/**
 * Document head
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.head(block : HEAD.() -> Unit = {}) : T = HEAD(emptyMap, this).visitAndFinalize(this, block)

/**
 * Introductory or navigational aids for a page or section
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.header(classes : String? = null, block : HEADER.() -> Unit = {}) : T = HEADER(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.hGroup(classes : String? = null, block : HGROUP.() -> Unit = {}) : T = HGROUP(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Horizontal rule
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.hr(classes : String? = null, block : HR.() -> Unit = {}) : T = HR(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

@Deprecated("This tag doesn't support content or requires unsafe (try unsafe {})")
@Suppress("DEPRECATION")
/**
 * Document root element
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.html(content : String = "", namespace : String? = null) : T = HTML(emptyMap, this, namespace).visitAndFinalize(this, {+content})
/**
 * Document root element
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.html(namespace : String? = null, block : HTML.() -> Unit = {}) : T = HTML(emptyMap, this, namespace).visitAndFinalize(this, block)

/**
 * Italic text style
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.i(classes : String? = null, block : I.() -> Unit = {}) : T = I(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Inline subwindow
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.iframe(sandbox : IframeSandbox? = null, classes : String? = null, content : String = "") : T = IFRAME(attributesMapOf("sandbox", sandbox?.enumEncode(),"class", classes), this).visitAndFinalize(this, {+content})
/**
 * Inline subwindow
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.iframe(sandbox : IframeSandbox? = null, classes : String? = null, block : IFRAME.() -> Unit = {}) : T = IFRAME(attributesMapOf("sandbox", sandbox?.enumEncode(),"class", classes), this).visitAndFinalize(this, block)

/**
 * Embedded image
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.img(alt : String? = null, src : String? = null, classes : String? = null, block : IMG.() -> Unit = {}) : T = IMG(attributesMapOf("alt", alt,"src", src,"class", classes), this).visitAndFinalize(this, block)

/**
 * Form control
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.input(type : InputType? = null, formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, block : INPUT.() -> Unit = {}) : T = INPUT(attributesMapOf("type", type?.enumEncode(),"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), this).visitAndFinalize(this, block)

/**
 * Inserted text
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.ins(classes : String? = null, block : INS.() -> Unit = {}) : T = INS(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Text to be entered by the user
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.kbd(classes : String? = null, block : KBD.() -> Unit = {}) : T = KBD(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Cryptographic key-pair generator form control
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.keyGen(keyType : KeyGenKeyType? = null, classes : String? = null, block : KEYGEN.() -> Unit = {}) : T = KEYGEN(attributesMapOf("keytype", keyType?.enumEncode(),"class", classes), this).visitAndFinalize(this, block)

/**
 * Form field label text
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.label(classes : String? = null, block : LABEL.() -> Unit = {}) : T = LABEL(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Fieldset legend
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.legend(classes : String? = null, block : LEGEND.() -> Unit = {}) : T = LEGEND(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * List item
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.li(classes : String? = null, block : LI.() -> Unit = {}) : T = LI(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * A media-independent link
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.link(href : String? = null, rel : String? = null, type : String? = null, block : LINK.() -> Unit = {}) : T = LINK(attributesMapOf("href", href,"rel", rel,"type", type), this).visitAndFinalize(this, block)

/**
 * Container for the dominant contents of another element
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.main(classes : String? = null, block : MAIN.() -> Unit = {}) : T = MAIN(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Client-side image map
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.map(name : String? = null, classes : String? = null, block : MAP.() -> Unit = {}) : T = MAP(attributesMapOf("name", name,"class", classes), this).visitAndFinalize(this, block)

/**
 * Highlight
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.mark(classes : String? = null, block : MARK.() -> Unit = {}) : T = MARK(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.math(classes : String? = null, block : MATH.() -> Unit = {}) : T = MATH(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.mathml(classes : String? = null, content : String = "") : T = MATHML(attributesMapOf("class", classes), this).visitAndFinalize(this, {+content})
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.mathml(classes : String? = null, block : MATHML.() -> Unit = {}) : T = MATHML(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Generic metainformation
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.meta(name : String? = null, content : String? = null, charset : String? = null, block : META.() -> Unit = {}) : T = META(attributesMapOf("name", name,"content", content,"charset", charset), this).visitAndFinalize(this, block)

/**
 * Gauge
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.meter(classes : String? = null, block : METER.() -> Unit = {}) : T = METER(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Section with navigational links
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.nav(classes : String? = null, block : NAV.() -> Unit = {}) : T = NAV(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Generic metainformation
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.noScript(classes : String? = null, block : NOSCRIPT.() -> Unit = {}) : T = NOSCRIPT(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Generic embedded object
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.htmlObject(classes : String? = null, block : OBJECT.() -> Unit = {}) : T = OBJECT(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Ordered list
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.ol(classes : String? = null, block : OL.() -> Unit = {}) : T = OL(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Option group
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.optGroup(label : String? = null, classes : String? = null, block : OPTGROUP.() -> Unit = {}) : T = OPTGROUP(attributesMapOf("label", label,"class", classes), this).visitAndFinalize(this, block)

/**
 * Selectable choice
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.option(classes : String? = null, content : String = "") : T = OPTION(attributesMapOf("class", classes), this).visitAndFinalize(this, {+content})
/**
 * Selectable choice
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.option(classes : String? = null, block : OPTION.() -> Unit = {}) : T = OPTION(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Calculated output value
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.output(classes : String? = null, block : OUTPUT.() -> Unit = {}) : T = OUTPUT(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Paragraph
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.p(classes : String? = null, block : P.() -> Unit = {}) : T = P(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Named property value
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.param(name : String? = null, value : String? = null, block : PARAM.() -> Unit = {}) : T = PARAM(attributesMapOf("name", name,"value", value), this).visitAndFinalize(this, block)

/**
 * Preformatted text
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.pre(classes : String? = null, block : PRE.() -> Unit = {}) : T = PRE(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Progress bar
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.progress(classes : String? = null, block : PROGRESS.() -> Unit = {}) : T = PROGRESS(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Short inline quotation
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.q(classes : String? = null, block : Q.() -> Unit = {}) : T = Q(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Parenthesis for ruby annotation text
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.rp(classes : String? = null, block : RP.() -> Unit = {}) : T = RP(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Ruby annotation text
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.rt(classes : String? = null, block : RT.() -> Unit = {}) : T = RT(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Ruby annotation(s)
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.ruby(classes : String? = null, block : RUBY.() -> Unit = {}) : T = RUBY(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Strike-through text style
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.samp(classes : String? = null, block : SAMP.() -> Unit = {}) : T = SAMP(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

@Deprecated("This tag doesn't support content or requires unsafe (try unsafe {})")
@Suppress("DEPRECATION")
/**
 * Script statements
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.script(type : String? = null, src : String? = null, content : String = "") : T = SCRIPT(attributesMapOf("type", type,"src", src), this).visitAndFinalize(this, {+content})
/**
 * Script statements
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.script(type : String? = null, src : String? = null, block : SCRIPT.() -> Unit = {}) : T = SCRIPT(attributesMapOf("type", type,"src", src), this).visitAndFinalize(this, block)

/**
 * Generic document or application section
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.section(classes : String? = null, block : SECTION.() -> Unit = {}) : T = SECTION(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Option selector
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.select(classes : String? = null, block : SELECT.() -> Unit = {}) : T = SELECT(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Small text style
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.small(classes : String? = null, block : SMALL.() -> Unit = {}) : T = SMALL(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Media source for 
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.source(classes : String? = null, block : SOURCE.() -> Unit = {}) : T = SOURCE(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Generic language/style container
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.span(classes : String? = null, block : SPAN.() -> Unit = {}) : T = SPAN(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Strong emphasis
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.strong(classes : String? = null, block : STRONG.() -> Unit = {}) : T = STRONG(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

@Deprecated("This tag doesn't support content or requires unsafe (try unsafe {})")
@Suppress("DEPRECATION")
/**
 * Style info
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.style(type : String? = null, content : String = "") : T = STYLE(attributesMapOf("type", type), this).visitAndFinalize(this, {+content})
/**
 * Style info
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.style(type : String? = null, block : STYLE.() -> Unit = {}) : T = STYLE(attributesMapOf("type", type), this).visitAndFinalize(this, block)

/**
 * Subscript
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.sub(classes : String? = null, block : SUB.() -> Unit = {}) : T = SUB(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Superscript
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.sup(classes : String? = null, block : SUP.() -> Unit = {}) : T = SUP(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.svg(classes : String? = null, content : String = "") : T = SVG(attributesMapOf("class", classes), this).visitAndFinalize(this, {+content})
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.svg(classes : String? = null, block : SVG.() -> Unit = {}) : T = SVG(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * 
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.table(classes : String? = null, block : TABLE.() -> Unit = {}) : T = TABLE(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Table body
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.tbody(classes : String? = null, block : TBODY.() -> Unit = {}) : T = TBODY(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Table data cell
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.td(classes : String? = null, block : TD.() -> Unit = {}) : T = TD(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Multi-line text field
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.textArea(rows : String? = null, cols : String? = null, wrap : TextAreaWrap? = null, classes : String? = null, content : String = "") : T = TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", wrap?.enumEncode(),"class", classes), this).visitAndFinalize(this, {+content})
/**
 * Multi-line text field
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.textArea(rows : String? = null, cols : String? = null, wrap : TextAreaWrap? = null, classes : String? = null, block : TEXTAREA.() -> Unit = {}) : T = TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", wrap?.enumEncode(),"class", classes), this).visitAndFinalize(this, block)

/**
 * Table footer
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.tfoot(classes : String? = null, block : TFOOT.() -> Unit = {}) : T = TFOOT(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Table header cell
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.th(scope : ThScope? = null, classes : String? = null, block : TH.() -> Unit = {}) : T = TH(attributesMapOf("scope", scope?.enumEncode(),"class", classes), this).visitAndFinalize(this, block)

/**
 * Table header
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.thead(classes : String? = null, block : THEAD.() -> Unit = {}) : T = THEAD(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Machine-readable equivalent of date- or time-related data
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.time(classes : String? = null, block : TIME.() -> Unit = {}) : T = TIME(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Document title
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.title(content : String = "") : T = TITLE(emptyMap, this).visitAndFinalize(this, {+content})
/**
 * Document title
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.title(block : TITLE.() -> Unit = {}) : T = TITLE(emptyMap, this).visitAndFinalize(this, block)

/**
 * Table row
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.tr(classes : String? = null, block : TR.() -> Unit = {}) : T = TR(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Unordered list
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.ul(classes : String? = null, block : UL.() -> Unit = {}) : T = UL(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Unordered list
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.htmlVar(classes : String? = null, block : VAR.() -> Unit = {}) : T = VAR(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

/**
 * Video player
 */
@HtmlTagMarker
fun <T, C : TagConsumer<T>> C.video(classes : String? = null, block : VIDEO.() -> Unit = {}) : T = VIDEO(attributesMapOf("class", classes), this).visitAndFinalize(this, block)

