/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.CharIterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt$WhenMappings;
import kotlin.reflect.jvm.internal.impl.name.State;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FqNamesUtilKt {
    public static final boolean isSubpackageOf(FqName $receiver, @NotNull FqName packageName) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        if (Intrinsics.areEqual((Object)$receiver, (Object)packageName)) {
            bl = true;
        } else if (packageName.isRoot()) {
            bl = true;
        } else {
            String string = $receiver.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.asString()");
            String string2 = packageName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"packageName.asString()");
            bl = FqNamesUtilKt.isSubpackageOf(string, string2);
        }
        return bl;
    }

    private static final boolean isSubpackageOf(String subpackageNameStr, String packageNameStr) {
        return StringsKt.startsWith$default((String)subpackageNameStr, (String)packageNameStr, (boolean)false, (int)2) && subpackageNameStr.charAt(CollectionsKt.length((CharSequence)packageNameStr)) == '.';
    }

    public static final boolean isOneSegmentFQN(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return !$receiver.isRoot() && $receiver.parent().isRoot();
    }

    @NotNull
    public static final FqName tail(FqName $receiver, @NotNull FqName prefix) {
        FqName fqName2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        if (!FqNamesUtilKt.isSubpackageOf($receiver, prefix) || prefix.isRoot()) {
            fqName2 = $receiver;
        } else if (Intrinsics.areEqual((Object)$receiver, (Object)prefix)) {
            FqName fqName3 = FqName.ROOT;
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"FqName.ROOT");
        } else {
            fqName2 = new FqName(StringsKt.substring((String)$receiver.asString(), (int)(CollectionsKt.length((CharSequence)prefix.asString()) + 1)));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"when {\n        !isSubpac\u2026ng().length() + 1))\n    }");
        return fqName2;
    }

    @Nullable
    public static final FqName parentOrNull(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.isRoot() ? (FqName)null : $receiver.parent();
    }

    public static final boolean isValidJavaFqName(@Nullable String qualifiedName) {
        if (qualifiedName == null) {
            return false;
        }
        State state = State.BEGINNING;
        CharIterator charIterator = StringsKt.iterator((CharSequence)qualifiedName);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            switch (FqNamesUtilKt$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierPart(c)) {
                        return false;
                    }
                    state = State.MIDDLE;
                    break;
                }
                case 3: {
                    if (c == '.') {
                        state = State.AFTER_DOT;
                        break;
                    }
                    if (Character.isJavaIdentifierPart(c)) break;
                    return false;
                }
            }
        }
        return Intrinsics.areEqual((Object)((Object)state), (Object)((Object)State.AFTER_DOT)) ^ true;
    }
}

