/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.jetbrains.kotlinx.serialization.compiler.backend.common;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import shadow.org.jetbrains.kotlinx.serialization.compiler.backend.common.SerialTypeInfo;
import shadow.org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt;
import shadow.org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt$anonymousInitializers$;
import shadow.org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt$bodyPropertiesDescriptorsMap$;
import shadow.org.jetbrains.kotlinx.serialization.compiler.backend.jvm.JVMCodegenUtilKt;
import shadow.org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import shadow.org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;
import shadow.org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationPackages;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0011\u001a\u001e\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001e\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00190\u0013*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u0005\u00a8\u0006\u001c"}, d2={"findEnumTypeSerializer", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "kType", "Lorg/jetbrains/kotlin/types/KotlinType;", "findPolymorphicSerializer", "findStandardKotlinTypeSerializer", "findTypeSerializer", "findTypeSerializerOrContext", "getSerialTypeInfo", "Lshadow/org/jetbrains/kotlinx/serialization/compiler/backend/common/SerialTypeInfo;", "property", "Lshadow/org/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "anonymousInitializers", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "bodyPropertiesDescriptorsMap", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "primaryPropertiesDescriptorsMap", "Lorg/jetbrains/kotlin/psi/KtParameter;", "requiresPolymorphism", "", "kotlinx-serialization-compiler-plugin"})
public final class TypeUtilKt {
    @NotNull
    public static final SerialTypeInfo getSerialTypeInfo(@NotNull SerializableProperty property) {
        SerialTypeInfo serialTypeInfo;
        ClassDescriptor serializableWith;
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        KotlinType T = property.getType();
        KotlinType kotlinType = property.getSerializableWith();
        Object object = serializableWith = kotlinType != null ? KSerializationUtilKt.toClassDescriptor(kotlinType) : null;
        if (serializableWith != null) {
            return new SerialTypeInfo(property, property.getType().isMarkedNullable() ? "Nullable" : "", serializableWith, false, 8, null);
        }
        if (TypeUtilsKt.isTypeParameter((KotlinType)T)) {
            serialTypeInfo = new SerialTypeInfo(property, property.getType().isMarkedNullable() ? "Nullable" : "", null, false, 8, null);
        } else if (TypeUtilsKt.isPrimitiveNumberType((KotlinType)T) | TypeUtilsKt.isBoolean((KotlinType)T)) {
            serialTypeInfo = new SerialTypeInfo(property, StringsKt.removePrefix((String)org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.getJetTypeFqName((KotlinType)T, (boolean)false), (CharSequence)"kotlin."), null, false, 12, null);
        } else if (KotlinBuiltIns.isString((KotlinType)T)) {
            serialTypeInfo = new SerialTypeInfo(property, "String", null, false, 12, null);
        } else if (KotlinBuiltIns.isUnit((KotlinType)T)) {
            serialTypeInfo = new SerialTypeInfo(property, "Unit", null, true, 4, null);
        } else {
            if (KotlinBuiltIns.isPrimitiveArray((KotlinType)T)) {
                String string = "primitive arrays are not supported yet";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor(T);
            if (classDescriptor == null) {
                Intrinsics.throwNpe();
            }
            if (KotlinBuiltIns.isNonPrimitiveArray((ClassDescriptor)classDescriptor)) {
                KotlinType kotlinType2 = property.getSerializableWith();
                if (kotlinType2 == null || (kotlinType2 = KSerializationUtilKt.toClassDescriptor(kotlinType2)) == null) {
                    kotlinType2 = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)property.getModule(), (ClassId)JVMCodegenUtilKt.getReferenceArraySerializerId());
                }
                KotlinType serializer = kotlinType2;
                serialTypeInfo = new SerialTypeInfo(property, property.getType().isMarkedNullable() ? "Nullable" : "", (ClassDescriptor)serializer, false, 8, null);
            } else {
                ClassDescriptor classDescriptor2 = KSerializationUtilKt.toClassDescriptor(T);
                if ((classDescriptor2 != null ? classDescriptor2.getKind() : null) == ClassKind.ENUM_CLASS) {
                    ClassDescriptor serializer = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)property.getModule(), (ClassId)JVMCodegenUtilKt.getEnumSerializerId());
                    serialTypeInfo = new SerialTypeInfo(property, property.getType().isMarkedNullable() ? "Nullable" : "", serializer, false, 8, null);
                } else {
                    ClassDescriptor serializer = TypeUtilKt.findTypeSerializerOrContext(property.getModule(), property.getType());
                    serialTypeInfo = new SerialTypeInfo(property, property.getType().isMarkedNullable() ? "Nullable" : "", serializer, false, 8, null);
                }
            }
        }
        return serialTypeInfo;
    }

    @Nullable
    public static final ClassDescriptor findTypeSerializerOrContext(@NotNull ModuleDescriptor module, @NotNull KotlinType kType) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)kType, (String)"kType");
        ClassDescriptor classDescriptor = TypeUtilKt.findTypeSerializer(module, kType);
        if (classDescriptor == null) {
            classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)JVMCodegenUtilKt.getContextSerializerId());
        }
        return classDescriptor;
    }

    @Nullable
    public static final ClassDescriptor findTypeSerializer(@NotNull ModuleDescriptor module, @NotNull KotlinType kType) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)kType, (String)"kType");
        KotlinType userOverride = KSerializationUtilKt.getOverridenSerializer(kType);
        if (userOverride != null) {
            return KSerializationUtilKt.toClassDescriptor(userOverride);
        }
        if (TypeUtilKt.requiresPolymorphism(kType)) {
            return TypeUtilKt.findPolymorphicSerializer(module);
        }
        if (TypeUtilsKt.isTypeParameter((KotlinType)kType)) {
            return null;
        }
        if (KotlinBuiltIns.isArray((KotlinType)kType)) {
            return KSerializationUtilKt.getClassFromInternalSerializationPackage(module, "ReferenceArraySerializer");
        }
        ClassDescriptor classDescriptor2 = KSerializationUtilKt.toClassDescriptor(KSerializationUtilKt.getTypeSerializer(kType));
        if (classDescriptor2 == null) {
            classDescriptor2 = classDescriptor = TypeUtilKt.findStandardKotlinTypeSerializer(module, kType);
        }
        if (classDescriptor2 == null) {
            classDescriptor = TypeUtilKt.findEnumTypeSerializer(module, kType);
        }
        return classDescriptor;
    }

    @Nullable
    public static final ClassDescriptor findStandardKotlinTypeSerializer(@NotNull ModuleDescriptor module, @NotNull KotlinType kType) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)kType, (String)"kType");
        switch (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.getJetTypeFqName((KotlinType)kType, (boolean)false)) {
            case "kotlin.Unit": {
                string = "UnitSerializer";
                break;
            }
            case "kotlin.Boolean": 
            case "Z": {
                string = "BooleanSerializer";
                break;
            }
            case "B": 
            case "kotlin.Byte": {
                string = "ByteSerializer";
                break;
            }
            case "S": 
            case "kotlin.Short": {
                string = "ShortSerializer";
                break;
            }
            case "I": 
            case "kotlin.Int": {
                string = "IntSerializer";
                break;
            }
            case "J": 
            case "kotlin.Long": {
                string = "LongSerializer";
                break;
            }
            case "F": 
            case "kotlin.Float": {
                string = "FloatSerializer";
                break;
            }
            case "D": 
            case "kotlin.Double": {
                string = "DoubleSerializer";
                break;
            }
            case "C": 
            case "kotlin.Char": {
                string = "CharSerializer";
                break;
            }
            case "kotlin.String": {
                string = "StringSerializer";
                break;
            }
            case "kotlin.Pair": {
                string = "PairSerializer";
                break;
            }
            case "kotlin.Triple": {
                string = "TripleSerializer";
                break;
            }
            case "kotlin.collections.Collection": 
            case "kotlin.collections.ArrayList": 
            case "kotlin.collections.List": 
            case "kotlin.collections.MutableList": {
                string = "ArrayListSerializer";
                break;
            }
            case "kotlin.collections.Set": 
            case "kotlin.collections.LinkedHashSet": 
            case "kotlin.collections.MutableSet": {
                string = "LinkedHashSetSerializer";
                break;
            }
            case "kotlin.collections.HashSet": {
                string = "HashSetSerializer";
                break;
            }
            case "kotlin.collections.MutableMap": 
            case "kotlin.collections.Map": 
            case "kotlin.collections.LinkedHashMap": {
                string = "LinkedHashMapSerializer";
                break;
            }
            case "kotlin.collections.HashMap": {
                string = "HashMapSerializer";
                break;
            }
            case "kotlin.collections.Map.Entry": {
                string = "MapEntrySerializer";
                break;
            }
            default: {
                return null;
            }
        }
        String name2 = string;
        return FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)new ClassId(SerializationPackages.INSTANCE.getInternalPackageFqName$kotlinx_serialization_compiler_plugin(), Name.identifier((String)name2)));
    }

    @Nullable
    public static final ClassDescriptor findEnumTypeSerializer(@NotNull ModuleDescriptor module, @NotNull KotlinType kType) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)kType, (String)"kType");
        ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor(kType);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        return classDescriptor2.getKind() == ClassKind.ENUM_CLASS ? FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)JVMCodegenUtilKt.getEnumSerializerId()) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean requiresPolymorphism(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor($receiver);
        if (classDescriptor != null && (classDescriptor = DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)classDescriptor)) != null) {
            if (KSerializationUtilKt.isInternalSerializable(classDescriptor)) return true;
        }
        ClassDescriptor classDescriptor2 = KSerializationUtilKt.toClassDescriptor($receiver);
        if ((classDescriptor2 != null ? classDescriptor2.getModality() : null) != Modality.FINAL) {
            ClassDescriptor classDescriptor3 = KSerializationUtilKt.toClassDescriptor($receiver);
            if ((classDescriptor3 != null ? classDescriptor3.getUnsubstitutedPrimaryConstructor() : null) != null) return true;
        }
        if (!TypeUtilsKt.containsTypeProjectionsInTopLevelArguments((KotlinType)$receiver)) return false;
        return true;
    }

    @NotNull
    public static final ClassDescriptor findPolymorphicSerializer(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)JVMCodegenUtilKt.getPolymorphicSerializerId());
        if (classDescriptor == null) {
            String string = "Can't locate polymorphic serializer definition";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<PropertyDescriptor, KtProperty> bodyPropertiesDescriptorsMap(@NotNull KtPureClassOrObject $receiver, @NotNull BindingContext bindingContext) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        List list = $receiver.getDeclarations();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"declarations");
        Sequence $receiver$iv = CollectionsKt.asSequence((Iterable)list);
        Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)bodyPropertiesDescriptorsMap$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        $receiver$iv = SequencesKt.filter((Sequence)sequence2, (Function1)bodyPropertiesDescriptorsMap.1.INSTANCE);
        Sequence $i$f$filterIsInstance = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PropertyDescriptor propertyDescriptor;
            void it;
            KtProperty ktProperty = (KtProperty)element$iv$iv;
            Map map = destination$iv$iv;
            Object object = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)it);
            if (!(object instanceof PropertyDescriptor)) {
                object = null;
            }
            if ((PropertyDescriptor)object == null) {
                Intrinsics.throwNpe();
            }
            map.put(propertyDescriptor, element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<PropertyDescriptor, KtParameter> primaryPropertiesDescriptorsMap(@NotNull KtPureClassOrObject $receiver, @NotNull BindingContext bindingContext) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        List list = $receiver.getPrimaryConstructorParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"primaryConstructorParameters");
        Sequence $receiver$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)primaryPropertiesDescriptorsMap.1.INSTANCE);
        Sequence sequence2 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            KtParameter ktParameter = (KtParameter)element$iv$iv;
            Map map = destination$iv$iv;
            Object object = bindingContext.get((ReadOnlySlice)BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, (Object)it);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object;
            map.put(propertyDescriptor, element$iv$iv);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final List<KtExpression> anonymousInitializers(@NotNull KtPureClassOrObject $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        List list = $receiver.getDeclarations();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"declarations");
        Sequence $receiver$iv = CollectionsKt.asSequence((Iterable)list);
        Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)anonymousInitializers$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)sequence2, (Function1)anonymousInitializers.1.INSTANCE));
    }
}

