/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.util;

import java.util.Arrays;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u001a\u001c\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u001a$\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u001a\u001d\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f\u00a2\u0006\u0002\u0010\u0010\u001a\u0012\u0010\u0011\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u0012\u0010\u0013\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u0012\u0010\u0014\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0012\u0010\u0016\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u00a8\u0006\u0017"}, d2={"nTabs", "", "amount", "", "printMillisec", "", "message", "body", "Lkotlin/Function0;", "profile", "profileIf", "condition", "", "getValueOrNull", "T", "Lkotlin/Lazy;", "(Lkotlin/Lazy;)Ljava/lang/Object;", "prefixBaseNameIfNot", "prefix", "prefixIfNot", "removeSuffixIfPresent", "suffix", "suffixIfNot", "kotlin-native-shared"})
public final class UtilKt {
    public static final void printMillisec(@NotNull String message, @NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        long start$iv = System.currentTimeMillis();
        body.invoke();
        long msec = System.currentTimeMillis() - start$iv;
        String string = message + ": " + msec + " msec";
        System.out.println((Object)string);
    }

    public static final void profile(@NotNull String message, @NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        String string = System.getProperty("konan.profile");
        UtilKt.profileIf(string != null ? string.equals("true") : false, message, body);
    }

    public static final void profileIf(boolean condition, @NotNull String message, @NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        if (condition) {
            UtilKt.printMillisec(message, body);
        } else {
            body.invoke();
        }
    }

    @NotNull
    public static final String nTabs(int amount) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%1$-" + (amount + 1) * 4 + 's';
        Object[] objectArray = new Object[]{""};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @NotNull
    public static final String prefixIfNot(@NotNull String $receiver, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return StringsKt.startsWith$default((String)$receiver, (String)prefix, (boolean)false, (int)2, null) ? $receiver : prefix + $receiver;
    }

    @NotNull
    public static final String prefixBaseNameIfNot(@NotNull String $receiver, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        File file = new File($receiver).getAbsoluteFile();
        String name2 = file.getName();
        String directory = file.getParent();
        return directory + '/' + UtilKt.prefixIfNot(name2, prefix);
    }

    @NotNull
    public static final String suffixIfNot(@NotNull String $receiver, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        return StringsKt.endsWith$default((String)$receiver, (String)suffix, (boolean)false, (int)2, null) ? $receiver : $receiver + suffix;
    }

    @NotNull
    public static final String removeSuffixIfPresent(@NotNull String $receiver, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        return StringsKt.endsWith$default((String)$receiver, (String)suffix, (boolean)false, (int)2, null) ? StringsKt.dropLast((String)$receiver, (int)suffix.length()) : $receiver;
    }

    @Nullable
    public static final <T> T getValueOrNull(@NotNull Lazy<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return (T)($receiver.isInitialized() ? $receiver.getValue() : null);
    }
}

