/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.target;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.AndroidConfigurables;
import org.jetbrains.kotlin.konan.target.AndroidLinker;
import org.jetbrains.kotlin.konan.target.AppleConfigurables;
import org.jetbrains.kotlin.konan.target.Configurables;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.LinkerFlags;
import org.jetbrains.kotlin.konan.target.LinuxBasedLinker;
import org.jetbrains.kotlin.konan.target.LinuxConfigurables;
import org.jetbrains.kotlin.konan.target.LinuxMIPSConfigurables;
import org.jetbrains.kotlin.konan.target.MacOSBasedLinker;
import org.jetbrains.kotlin.konan.target.MingwConfigurables;
import org.jetbrains.kotlin.konan.target.MingwLinker;
import org.jetbrains.kotlin.konan.target.WasmConfigurables;
import org.jetbrains.kotlin.konan.target.WasmLinker;
import org.jetbrains.kotlin.konan.target.ZephyrConfigurables;
import org.jetbrains.kotlin.konan.target.ZephyrLinker;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003*\n\u0010\u0004\"\u00020\u00052\u00020\u0005*\n\u0010\u0006\"\u00020\u00052\u00020\u0005\u00a8\u0006\u0007"}, d2={"linker", "Lorg/jetbrains/kotlin/konan/target/LinkerFlags;", "configurables", "Lorg/jetbrains/kotlin/konan/target/Configurables;", "ExecutableFile", "", "ObjectFile", "kotlin-native-shared"})
public final class LinkerKt {
    @NotNull
    public static final LinkerFlags linker(@NotNull Configurables configurables) {
        LinkerFlags linkerFlags;
        Intrinsics.checkParameterIsNotNull((Object)configurables, (String)"configurables");
        KonanTarget konanTarget = configurables.getTarget();
        if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_ARM32_HFP.INSTANCE)) {
            linkerFlags = new LinuxBasedLinker((LinuxConfigurables)configurables);
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_MIPS32.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_MIPSEL32.INSTANCE)) {
            linkerFlags = new LinuxBasedLinker((LinuxMIPSConfigurables)configurables);
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.IOS_ARM32.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.IOS_ARM64.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.IOS_X64.INSTANCE)) {
            linkerFlags = new MacOSBasedLinker((AppleConfigurables)configurables);
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.ANDROID_ARM32.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.ANDROID_ARM64.INSTANCE)) {
            linkerFlags = new AndroidLinker((AndroidConfigurables)configurables);
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE)) {
            linkerFlags = new MingwLinker((MingwConfigurables)configurables);
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.WASM32.INSTANCE)) {
            linkerFlags = new WasmLinker((WasmConfigurables)configurables);
        } else if (konanTarget instanceof KonanTarget.ZEPHYR) {
            linkerFlags = new ZephyrLinker((ZephyrConfigurables)configurables);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return linkerFlags;
    }
}

