/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.target;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.TargetManager;
import org.jetbrains.kotlin.konan.target.TargetManagerImpl;
import org.jetbrains.kotlin.konan.target.TargetSupportException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0016J\u0012\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0016J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0012\u0010\rR\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000b0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/konan/target/HostManager;", "", "distribution", "Lorg/jetbrains/kotlin/konan/target/Distribution;", "(Lorg/jetbrains/kotlin/konan/target/Distribution;)V", "configurableSubtargets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget$ZEPHYR;", "getDistribution", "()Lorg/jetbrains/kotlin/konan/target/Distribution;", "enabled", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getEnabled", "()Ljava/util/List;", "enabled$delegate", "Lkotlin/Lazy;", "predefinedTargets", "targetValues", "getTargetValues", "targetValues$delegate", "targets", "", "", "getTargets", "()Ljava/util/Map;", "zephyrSubtargets", "isEnabled", "", "target", "known", "name", "targetByName", "targetManager", "Lorg/jetbrains/kotlin/konan/target/TargetManager;", "userRequest", "toKonanTargets", "names", "", "Companion", "kotlin-native-shared"})
public class HostManager {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final List<KonanTarget> predefinedTargets;
    private final List<KonanTarget.ZEPHYR> zephyrSubtargets;
    private final List<KonanTarget.ZEPHYR> configurableSubtargets;
    @NotNull
    private final Lazy targetValues$delegate;
    @NotNull
    private final Map<String, KonanTarget> targets;
    @NotNull
    private final Lazy enabled$delegate;
    @NotNull
    private final Distribution distribution;
    @NotNull
    private static final KonanTarget host;
    private static final boolean hostIsMac;
    private static final boolean hostIsLinux;
    private static final boolean hostIsMingw;
    @NotNull
    private static final List<String> knownTargetTemplates;
    private static final Map<String, String> targetAliasResolutions;
    private static final Lazy targetAliases$delegate;
    public static final Companion Companion;

    static {
        KonanTarget konanTarget;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HostManager.class), "targetValues", "getTargetValues()Ljava/util/List;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HostManager.class), "enabled", "getEnabled()Ljava/util/List;"))};
        Companion = new Companion(null);
        switch (Companion.host_os()) {
            case "osx": {
                konanTarget = KonanTarget.MACOS_X64.INSTANCE;
                break;
            }
            case "linux": {
                konanTarget = KonanTarget.LINUX_X64.INSTANCE;
                break;
            }
            case "windows": {
                konanTarget = KonanTarget.MINGW_X64.INSTANCE;
                break;
            }
            default: {
                throw (Throwable)new TargetSupportException("Unknown host target: " + Companion.host_os() + ' ' + Companion.host_arch(), null, 2, null);
            }
        }
        host = konanTarget;
        hostIsMac = Intrinsics.areEqual((Object)host, (Object)KonanTarget.MACOS_X64.INSTANCE);
        hostIsLinux = Intrinsics.areEqual((Object)host, (Object)KonanTarget.LINUX_X64.INSTANCE);
        hostIsMingw = Intrinsics.areEqual((Object)host, (Object)KonanTarget.MINGW_X64.INSTANCE);
        knownTargetTemplates = CollectionsKt.listOf((Object)"zephyr");
        targetAliasResolutions = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"linux", (Object)"linux_x64"), TuplesKt.to((Object)"macbook", (Object)"macos_x64"), TuplesKt.to((Object)"macos", (Object)"macos_x64"), TuplesKt.to((Object)"imac", (Object)"macos_x64"), TuplesKt.to((Object)"raspberrypi", (Object)"linux_arm32_hfp"), TuplesKt.to((Object)"iphone32", (Object)"ios_arm32"), TuplesKt.to((Object)"iphone", (Object)"ios_arm64"), TuplesKt.to((Object)"ipad", (Object)"ios_arm64"), TuplesKt.to((Object)"ios", (Object)"ios_arm64"), TuplesKt.to((Object)"iphone_sim", (Object)"ios_x64"), TuplesKt.to((Object)"mingw", (Object)"mingw_x64")});
        targetAliases$delegate = LazyKt.lazy((Function0)Companion.targetAliases.2.INSTANCE);
    }

    @NotNull
    public final TargetManager targetManager(@Nullable String userRequest) {
        return new TargetManagerImpl(userRequest, this);
    }

    @NotNull
    public static /* synthetic */ TargetManager targetManager$default(HostManager hostManager, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: targetManager");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return hostManager.targetManager(string);
    }

    @NotNull
    public final List<KonanTarget> getTargetValues() {
        Lazy lazy = this.targetValues$delegate;
        HostManager hostManager = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (List)lazy.getValue();
    }

    @NotNull
    public final Map<String, KonanTarget> getTargets() {
        return this.targets;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KonanTarget> toKonanTargets(@NotNull Iterable<String> names) {
        void $receiver$iv$iv;
        Iterable<String> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(names, (String)"names");
        Iterable<String> iterable = $receiver$iv = names;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            KonanTarget konanTarget;
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            if (Intrinsics.areEqual((Object)it, (Object)"host")) {
                konanTarget = host;
            } else {
                KonanTarget konanTarget2 = this.targets.get(this.known(Companion.resolveAlias((String)it)));
                if (konanTarget2 == null) {
                    Intrinsics.throwNpe();
                }
                konanTarget = konanTarget2;
            }
            KonanTarget konanTarget3 = konanTarget;
            collection.add(konanTarget3);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String known(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (this.targets.get(name2) == null) {
            throw (Throwable)new TargetSupportException("Unknown target: " + name2 + ". Use -list_targets to see the list of available targets", null, 2, null);
        }
        return name2;
    }

    @NotNull
    public final KonanTarget targetByName(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (Intrinsics.areEqual((Object)name2, (Object)"host")) {
            return host;
        }
        KonanTarget target2 = this.targets.get(Companion.resolveAlias(name2));
        if (target2 == null) {
            throw (Throwable)new TargetSupportException("Unknown target name: " + name2, null, 2, null);
        }
        return target2;
    }

    @NotNull
    public final List<KonanTarget> getEnabled() {
        Lazy lazy = this.enabled$delegate;
        HostManager hostManager = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (List)lazy.getValue();
    }

    public final boolean isEnabled(@NotNull KonanTarget target2) {
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        return this.getEnabled().contains(target2);
    }

    @NotNull
    protected final Distribution getDistribution() {
        return this.distribution;
    }

    /*
     * WARNING - void declaration
     */
    public HostManager(@NotNull Distribution distribution) {
        void $receiver$iv$iv;
        Object object;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)distribution, (String)"distribution");
        this.distribution = distribution;
        this.predefinedTargets = CollectionsKt.listOf((Object[])new KonanTarget[]{KonanTarget.ANDROID_ARM32.INSTANCE, KonanTarget.ANDROID_ARM64.INSTANCE, KonanTarget.IOS_ARM32.INSTANCE, KonanTarget.IOS_ARM64.INSTANCE, KonanTarget.IOS_X64.INSTANCE, KonanTarget.LINUX_X64.INSTANCE, KonanTarget.LINUX_ARM32_HFP.INSTANCE, KonanTarget.LINUX_MIPS32.INSTANCE, KonanTarget.LINUX_MIPSEL32.INSTANCE, KonanTarget.MINGW_X64.INSTANCE, KonanTarget.MACOS_X64.INSTANCE, KonanTarget.WASM32.INSTANCE});
        Iterable iterable = this.distribution.availableSubTarget("zephyr");
        HostManager hostManager = this;
        void var3_4 = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            KonanTarget.ZEPHYR zEPHYR = new KonanTarget.ZEPHYR((String)it, null, 2, null);
            object.add(zEPHYR);
        }
        object = (List)destination$iv$iv;
        hostManager.zephyrSubtargets = object;
        this.configurableSubtargets = this.zephyrSubtargets;
        this.targetValues$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends KonanTarget>>(this){
            final /* synthetic */ HostManager this$0;

            @NotNull
            public final List<KonanTarget> invoke() {
                return CollectionsKt.plus((Collection)HostManager.access$getPredefinedTargets$p(this.this$0), (Iterable)HostManager.access$getConfigurableSubtargets$p(this.this$0));
            }
            {
                this.this$0 = hostManager;
                super(0);
            }
        }));
        $receiver$iv = this.getTargetValues();
        hostManager = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map = destination$iv$iv2;
            KonanTarget it = (KonanTarget)element$iv$iv;
            Pair pair = TuplesKt.to((Object)it.getVisibleName(), (Object)it);
            map.put(pair.getFirst(), pair.getSecond());
        }
        hostManager.targets = object = destination$iv$iv2;
        this.enabled$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends KonanTarget>>(this){
            final /* synthetic */ HostManager this$0;

            @NotNull
            public final List<KonanTarget> invoke() {
                List list;
                KonanTarget konanTarget = HostManager.Companion.getHost();
                if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) {
                    list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new KonanTarget[]{KonanTarget.LINUX_X64.INSTANCE, KonanTarget.LINUX_ARM32_HFP.INSTANCE, KonanTarget.LINUX_MIPS32.INSTANCE, KonanTarget.LINUX_MIPSEL32.INSTANCE, KonanTarget.ANDROID_ARM32.INSTANCE, KonanTarget.ANDROID_ARM64.INSTANCE, KonanTarget.WASM32.INSTANCE}), (Iterable)HostManager.access$getZephyrSubtargets$p(this.this$0));
                } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE)) {
                    list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new KonanTarget[]{KonanTarget.MINGW_X64.INSTANCE, KonanTarget.WASM32.INSTANCE}), (Iterable)HostManager.access$getZephyrSubtargets$p(this.this$0));
                } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE)) {
                    list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new KonanTarget[]{KonanTarget.MACOS_X64.INSTANCE, KonanTarget.IOS_ARM32.INSTANCE, KonanTarget.IOS_ARM64.INSTANCE, KonanTarget.IOS_X64.INSTANCE, KonanTarget.ANDROID_ARM32.INSTANCE, KonanTarget.ANDROID_ARM64.INSTANCE, KonanTarget.WASM32.INSTANCE}), (Iterable)HostManager.access$getZephyrSubtargets$p(this.this$0));
                } else {
                    throw (Throwable)new TargetSupportException("Unknown host platform: " + HostManager.Companion.getHost(), null, 2, null);
                }
                return list;
            }
            {
                this.this$0 = hostManager;
                super(0);
            }
        }));
    }

    public /* synthetic */ HostManager(Distribution distribution, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            distribution = new Distribution(false, null, null, 7, null);
        }
        this(distribution);
    }

    public HostManager() {
        this(null, 1, null);
    }

    @NotNull
    public static final /* synthetic */ List access$getPredefinedTargets$p(HostManager $this) {
        return $this.predefinedTargets;
    }

    @NotNull
    public static final /* synthetic */ List access$getConfigurableSubtargets$p(HostManager $this) {
        return $this.configurableSubtargets;
    }

    @NotNull
    public static final /* synthetic */ List access$getZephyrSubtargets$p(HostManager $this) {
        return $this.zephyrSubtargets;
    }

    @JvmStatic
    @NotNull
    public static final String simpleOsName() {
        return Companion.simpleOsName();
    }

    @NotNull
    public static final String getHostName() {
        return Companion.getHostName();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010#\u001a\u00020\u0010J\u0006\u0010$\u001a\u00020\u0010J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010&\u001a\u00020\u0010J\u000e\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0010J\b\u0010)\u001a\u00020\u0010H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\u00020\u00108FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00190\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 \u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/konan/target/HostManager$Companion;", "", "()V", "host", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getHost", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "hostIsLinux", "", "getHostIsLinux", "()Z", "hostIsMac", "getHostIsMac", "hostIsMingw", "getHostIsMingw", "hostName", "", "hostName$annotations", "getHostName", "()Ljava/lang/String;", "hostSuffix", "getHostSuffix", "jniHostPlatformIncludeDir", "getJniHostPlatformIncludeDir", "knownTargetTemplates", "", "getKnownTargetTemplates", "()Ljava/util/List;", "targetAliasResolutions", "", "targetAliases", "getTargetAliases", "()Ljava/util/Map;", "targetAliases$delegate", "Lkotlin/Lazy;", "host_arch", "host_os", "listAliases", "target", "resolveAlias", "request", "simpleOsName", "kotlin-native-shared"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "targetAliases", "getTargetAliases()Ljava/util/Map;"))};
        }

        @NotNull
        public final String host_os() {
            String string;
            String javaOsName = System.getProperty("os.name");
            if (Intrinsics.areEqual((Object)javaOsName, (Object)"Mac OS X")) {
                string = "osx";
            } else if (Intrinsics.areEqual((Object)javaOsName, (Object)"Linux")) {
                string = "linux";
            } else {
                String string2 = javaOsName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"javaOsName");
                if (StringsKt.startsWith$default((String)string2, (String)"Windows", (boolean)false, (int)2, null)) {
                    string = "windows";
                } else {
                    throw (Throwable)new TargetSupportException("Unknown operating system: " + javaOsName, null, 2, null);
                }
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String simpleOsName() {
            String hostOs = this.host_os();
            return Intrinsics.areEqual((Object)hostOs, (Object)"osx") ? "macos" : hostOs;
        }

        @NotNull
        public final String getJniHostPlatformIncludeDir() {
            String string;
            KonanTarget konanTarget = Companion.getHost();
            if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE)) {
                string = "darwin";
            } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) {
                string = "linux";
            } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE)) {
                string = "win32";
            } else {
                throw (Throwable)new TargetSupportException("Unknown host: " + Companion.getHost() + '.', null, 2, null);
            }
            return string;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final String host_arch() {
            String javaArch;
            String string = javaArch = System.getProperty("os.arch");
            if (string == null) throw (Throwable)new TargetSupportException("Unknown hardware platform: " + javaArch, null, 2, null);
            switch (string) {
                case "x86_64": {
                    return "x86_64";
                }
                case "amd64": {
                    return "x86_64";
                }
                case "arm64": {
                    return "arm64";
                }
                default: {
                    throw (Throwable)new TargetSupportException("Unknown hardware platform: " + javaArch, null, 2, null);
                }
            }
        }

        @NotNull
        public final KonanTarget getHost() {
            return host;
        }

        public final boolean getHostIsMac() {
            return hostIsMac;
        }

        public final boolean getHostIsLinux() {
            return hostIsLinux;
        }

        public final boolean getHostIsMingw() {
            return hostIsMingw;
        }

        @NotNull
        public final String getHostSuffix() {
            return Companion.getHost().getName();
        }

        @JvmStatic
        public static /* synthetic */ void hostName$annotations() {
        }

        @NotNull
        public final String getHostName() {
            return Companion.getHost().getName();
        }

        @NotNull
        public final List<String> getKnownTargetTemplates() {
            return knownTargetTemplates;
        }

        private final Map<String, List<String>> getTargetAliases() {
            Lazy lazy = targetAliases$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (Map)lazy.getValue();
        }

        @NotNull
        public final String resolveAlias(@NotNull String request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            String string = (String)targetAliasResolutions.get(request);
            if (string == null) {
                string = request;
            }
            return string;
        }

        @NotNull
        public final List<String> listAliases(@NotNull String target2) {
            Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
            List list = this.getTargetAliases().get(target2);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

