/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinChunk$Companion$calculateTargetDependencies$;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheStatus;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\u0018\u0000 I2\u00020\u0001:\u0001IB!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0002J\u0016\u0010<\u001a\u0002082\u000e\b\u0002\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00000>J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BJ \u0010C\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020;0D2\b\b\u0002\u0010E\u001a\u00020\u0013J\u0006\u0010F\u001a\u000208J\u0006\u0010G\u001a\u00020\u0013J\b\u0010H\u001a\u00020.H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u00058F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001bR\u001b\u0010'\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0011\u001a\u0004\b'\u0010\u001bR\u001b\u0010)\u001a\u00020\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0011\u001a\u0004\b*\u0010+R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b2\u00100R\u0015\u00103\u001a\u0006\u0012\u0002\b\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\"\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "", "context", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "targets", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;Ljava/util/List;)V", "_dependencies", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Dependency;", "_dependents", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "apiVersion$delegate", "Lkotlin/Lazy;", "areChunkDependenciesCalculated", "", "compilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "getCompilerArguments", "()Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "compilerArguments$delegate", "containsTests", "getContainsTests", "()Z", "getContext", "()Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "defaultLanguageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "dependencies", "getDependencies", "()Ljava/util/List;", "dependents", "getDependents", "haveSameCompiler", "getHaveSameCompiler", "isEnabled", "isEnabled$delegate", "langVersion", "getLangVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "langVersion$delegate", "presentableModulesToCompilersList", "", "getPresentableModulesToCompilersList", "()Ljava/lang/String;", "presentableShortName", "getPresentableShortName", "representativeTarget", "getRepresentativeTarget", "()Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "getTargets", "addDependentCaches", "", "targetsCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "collectDependentChunksRecursivelyExportedOnly", "result", "", "compilerArgumentsFile", "Ljava/nio/file/Path;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "loadCaches", "", "loadDependent", "saveVersions", "shouldRebuild", "toString", "Companion", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nKotlinChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinChunk.kt\norg/jetbrains/kotlin/jps/build/KotlinChunk\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1747#2,3:239\n1726#2,3:242\n1855#2,2:246\n1855#2,2:248\n1855#2,2:250\n1855#2,2:252\n1855#2:254\n1855#2,2:255\n1856#2:257\n1#3:245\n*S KotlinDebug\n*F\n+ 1 KotlinChunk.kt\norg/jetbrains/kotlin/jps/build/KotlinChunk\n*L\n27#1:239,3\n112#1:242,3\n142#1:246,2\n166#1:248,2\n171#1:250,2\n178#1:252,2\n207#1:254\n208#1:255,2\n207#1:257\n*E\n"})
public final class KotlinChunk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinCompileContext context;
    @NotNull
    private final List<KotlinModuleBuildTarget<?>> targets;
    private final boolean containsTests;
    private boolean areChunkDependenciesCalculated;
    @NotNull
    private final List<KotlinModuleBuildTarget.Dependency> _dependencies;
    @NotNull
    private final List<KotlinModuleBuildTarget.Dependency> _dependents;
    private final boolean haveSameCompiler;
    @NotNull
    private final LanguageVersion defaultLanguageVersion;
    @NotNull
    private final Lazy compilerArguments$delegate;
    @NotNull
    private final Lazy langVersion$delegate;
    @NotNull
    private final Lazy apiVersion$delegate;
    @NotNull
    private final Lazy isEnabled$delegate;

    /*
     * WARNING - void declaration
     */
    public KotlinChunk(@NotNull KotlinCompileContext context, @NotNull List<? extends KotlinModuleBuildTarget<?>> targets) {
        boolean bl;
        boolean bl2;
        block7: {
            void $this$all$iv;
            KotlinModuleBuildTarget it;
            boolean bl3;
            Iterable $this$any$iv;
            KotlinChunk kotlinChunk;
            block6: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(targets, (String)"targets");
                this.context = context;
                this.targets = targets;
                Iterable iterable = this.targets;
                kotlinChunk = this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KotlinModuleBuildTarget)element$iv;
                        boolean bl4 = false;
                        if (!it.isTests()) continue;
                        bl3 = true;
                        break block6;
                    }
                    bl3 = false;
                }
            }
            kotlinChunk.containsTests = bl2 = bl3;
            this._dependencies = new ArrayList();
            this._dependents = new ArrayList();
            $this$any$iv = this.targets;
            kotlinChunk = this;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (KotlinModuleBuildTarget)element$iv;
                    boolean bl5 = false;
                    if (Intrinsics.areEqual(it.getClass(), this.getRepresentativeTarget().getClass())) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        kotlinChunk.haveSameCompiler = bl2 = bl;
        this.defaultLanguageVersion = LanguageVersion.LATEST_STABLE;
        this.compilerArguments$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CommonCompilerArguments>(this){
            final /* synthetic */ KotlinChunk this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CommonCompilerArguments invoke() {
                JpsModule jpsModule = this.this$0.getRepresentativeTarget().getJpsModuleBuildTarget().getModule();
                Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"representativeTarget.jpsModuleBuildTarget.module");
                CommonCompilerArguments commonCompilerArguments = ModuleSettingsKt.getKotlinCompilerArguments(jpsModule);
                KotlinChunk kotlinChunk = this.this$0;
                CommonCompilerArguments it = commonCompilerArguments;
                boolean bl = false;
                it.setReportOutputFiles(true);
                it.setVersion(true);
                if (it.getLanguageVersion() == null) {
                    it.setLanguageVersion(KotlinChunk.access$getDefaultLanguageVersion$p(kotlinChunk).getVersionString());
                }
                return commonCompilerArguments;
            }
        }));
        this.langVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LanguageVersion>(this){
            final /* synthetic */ KotlinChunk this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LanguageVersion invoke() {
                Object object;
                block3: {
                    block2: {
                        object = this.this$0.getCompilerArguments().getLanguageVersion();
                        if (object == null) break block2;
                        String it = object;
                        boolean bl = false;
                        LanguageVersion languageVersion = LanguageVersion.Companion.fromVersionString(it);
                        object = languageVersion;
                        if (languageVersion != null) break block3;
                    }
                    object = KotlinChunk.access$getDefaultLanguageVersion$p(this.this$0);
                }
                return object;
            }
        }));
        this.apiVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ApiVersion>(this){
            final /* synthetic */ KotlinChunk this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ApiVersion invoke() {
                Object object;
                block3: {
                    block2: {
                        object = this.this$0.getCompilerArguments().getApiVersion();
                        if (object == null) break block2;
                        String it = object;
                        boolean bl = false;
                        ApiVersion apiVersion2 = ApiVersion.Companion.parse(it);
                        object = apiVersion2;
                        if (apiVersion2 != null) break block3;
                    }
                    object = ApiVersion.Companion.createByLanguageVersion(this.this$0.getLangVersion());
                }
                return object;
            }
        }));
        this.isEnabled$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ KotlinChunk this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getRepresentativeTarget().isEnabled((Lazy<CommonCompilerArguments>)LazyKt.lazy((Function0)((Function0)new Function0<CommonCompilerArguments>(this.this$0){
                    final /* synthetic */ KotlinChunk this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final CommonCompilerArguments invoke() {
                        return this.this$0.getCompilerArguments();
                    }
                })));
            }
        }));
    }

    @NotNull
    public final KotlinCompileContext getContext() {
        return this.context;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget<?>> getTargets() {
        return this.targets;
    }

    public final boolean getContainsTests() {
        return this.containsTests;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget.Dependency> getDependencies() {
        List<KotlinModuleBuildTarget.Dependency> list;
        List<KotlinModuleBuildTarget.Dependency> it = list = this._dependencies;
        boolean bl = false;
        List<KotlinModuleBuildTarget.Dependency> list2 = this.areChunkDependenciesCalculated ? list : null;
        if (list2 == null) {
            throw new IllegalStateException("Chunk dependencies are not calculated yet".toString());
        }
        return list2;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget.Dependency> getDependents() {
        List<KotlinModuleBuildTarget.Dependency> list;
        List<KotlinModuleBuildTarget.Dependency> it = list = this._dependents;
        boolean bl = false;
        List<KotlinModuleBuildTarget.Dependency> list2 = this.areChunkDependenciesCalculated ? list : null;
        if (list2 == null) {
            throw new IllegalStateException("Chunk dependents are not calculated yet".toString());
        }
        return list2;
    }

    @NotNull
    public final KotlinModuleBuildTarget<?> getRepresentativeTarget() {
        return (KotlinModuleBuildTarget)kotlin.collections.CollectionsKt.first(this.targets);
    }

    @NotNull
    public final String getPresentableModulesToCompilersList() {
        return kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.targets, null, null, null, (int)0, null, (Function1)presentableModulesToCompilersList.1.INSTANCE, (int)31, null);
    }

    public final boolean getHaveSameCompiler() {
        return this.haveSameCompiler;
    }

    @NotNull
    public final CommonCompilerArguments getCompilerArguments() {
        Lazy lazy = this.compilerArguments$delegate;
        return (CommonCompilerArguments)lazy.getValue();
    }

    @NotNull
    public final LanguageVersion getLangVersion() {
        Lazy lazy = this.langVersion$delegate;
        return (LanguageVersion)lazy.getValue();
    }

    @NotNull
    public final ApiVersion getApiVersion() {
        Lazy lazy = this.apiVersion$delegate;
        return (ApiVersion)lazy.getValue();
    }

    public final boolean isEnabled() {
        Lazy lazy = this.isEnabled$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean shouldRebuild() {
        Iterable $this$forEach$iv = this.targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            if (target.isVersionChanged(this, this.getCompilerArguments())) {
                KotlinBuilder.Companion.getLOG().info(target + " version changed, rebuilding " + this);
                return true;
            }
            if (target.getInitialLocalCacheAttributesDiff().getStatus() != CacheStatus.INVALID) continue;
            TestingBuildLogger testingBuildLogger = this.context.getTestingLogger();
            if (testingBuildLogger != null) {
                testingBuildLogger.invalidOrUnusedCache(this, null, target.getInitialLocalCacheAttributesDiff());
            }
            KotlinBuilder.Companion.getLOG().info(target + " cache is invalid " + target.getInitialLocalCacheAttributesDiff() + ", rebuilding " + this);
            return true;
        }
        return false;
    }

    @NotNull
    public final Path compilerArgumentsFile(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path path = this.context.getDataPaths().getTargetDataRoot((BuildTarget)target).toPath().resolve(this.getRepresentativeTarget().getCompilerArgumentsFileName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"context.dataPaths\n      \u2026ompilerArgumentsFileName)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveVersions() {
        this.context.ensureLookupsCacheAttributesSaved();
        Iterable $this$forEach$iv = this.targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            CacheAttributesManager.writeVersion$default(it.getInitialLocalCacheAttributesDiff().getManager(), null, 1, null);
        }
        String serializedCompilerArguments = this.getRepresentativeTarget().getBuildMetaInfo().serializeArgsToString(this.getCompilerArguments());
        Iterable $this$forEach$iv2 = this.targets;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            OutputStream outputStream = Files.newOutputStream(this.compilerArgumentsFile(target.getJpsModuleBuildTarget()), new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(compiler\u2026et.jpsModuleBuildTarget))");
            Closeable closeable = outputStream;
            Object object = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object = null;
            try {
                BufferedWriter it = (BufferedWriter)closeable;
                boolean bl2 = false;
                it.append(serializedCompilerArguments);
                writer = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
    }

    public final void collectDependentChunksRecursivelyExportedOnly(@NotNull Set<KotlinChunk> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Iterable $this$forEach$iv = this.getDependents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget.Dependency it = (KotlinModuleBuildTarget.Dependency)element$iv;
            boolean bl = false;
            if (!result.add(it.getSrc().getChunk()) || !it.getExported()) continue;
            it.getSrc().getChunk().collectDependentChunksRecursivelyExportedOnly(result);
        }
    }

    public static /* synthetic */ void collectDependentChunksRecursivelyExportedOnly$default(KotlinChunk kotlinChunk, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = new LinkedHashSet();
        }
        kotlinChunk.collectDependentChunksRecursivelyExportedOnly(set);
    }

    @NotNull
    public final Map<KotlinModuleBuildTarget<?>, JpsIncrementalCache> loadCaches(boolean loadDependent) {
        BuildDataManager dataManager = this.context.getDataManager();
        Map<KotlinModuleBuildTarget<?>, JpsIncrementalCache> cacheByChunkTarget2 = CollectionsKt.keysToMapExceptNulls((Iterable)this.targets, (Function1)new Function1<KotlinModuleBuildTarget<?>, JpsIncrementalCache>(dataManager){
            final /* synthetic */ BuildDataManager $dataManager;
            {
                this.$dataManager = $dataManager;
                super(1);
            }

            @Nullable
            public final JpsIncrementalCache invoke(@NotNull KotlinModuleBuildTarget<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                BuildDataManager buildDataManager = this.$dataManager;
                Intrinsics.checkNotNullExpressionValue((Object)buildDataManager, (String)"dataManager");
                return JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
            }
        });
        if (loadDependent) {
            this.addDependentCaches(cacheByChunkTarget2.values());
        }
        return cacheByChunkTarget2;
    }

    public static /* synthetic */ Map loadCaches$default(KotlinChunk kotlinChunk, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return kotlinChunk.loadCaches(bl);
    }

    private final void addDependentCaches(Collection<? extends JpsIncrementalCache> targetsCaches) {
        Set dependentChunks = new LinkedHashSet();
        this.collectDependentChunksRecursivelyExportedOnly(dependentChunks);
        BuildDataManager dataManager = this.context.getDataManager();
        Iterable $this$forEach$iv = dependentChunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk decedentChunk = (KotlinChunk)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = decedentChunk.targets;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dataManager, (String)"dataManager");
                JpsIncrementalCache dependentCache = JpsIncrementalCacheKt.getKotlinCache(dataManager, it);
                if (dependentCache == null) continue;
                for (JpsIncrementalCache jpsIncrementalCache : targetsCaches) {
                    jpsIncrementalCache.addJpsDependentCache(dependentCache);
                }
            }
        }
    }

    @NotNull
    public final String getPresentableShortName() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_presentableShortName__u24lambda_u2411 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.containsTests) {
            $this$_get_presentableShortName__u24lambda_u2411.append("tests of ");
        }
        $this$_get_presentableShortName__u24lambda_u2411.append(((KotlinModuleBuildTarget)kotlin.collections.CollectionsKt.first(this.targets)).getModule().getName());
        if (this.targets.size() > 1) {
            String andXMore = " and " + (this.targets.size() - 1) + " more";
            String other = ", " + SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)this.targets), (int)1), null, null, null, (int)0, null, null, (int)63, null);
            $this$_get_presentableShortName__u24lambda_u2411.append(other.length() < andXMore.length() ? other : andXMore);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return "KotlinChunk<" + this.getRepresentativeTarget().getClass().getSimpleName() + ">(" + kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.targets, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null) + ')';
    }

    public static final /* synthetic */ LanguageVersion access$getDefaultLanguageVersion$p(KotlinChunk $this) {
        return $this.defaultLanguageVersion;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tJ2\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinChunk$Companion;", "", "()V", "calculateChunkDependencies", "", "chunks", "", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "byJpsModuleBuildTarget", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "calculateTargetDependencies", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Dependency;", "srcTarget", "jps-plugin"})
    @SourceDebugExtension(value={"SMAP\nKotlinChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinChunk.kt\norg/jetbrains/kotlin/jps/build/KotlinChunk$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,238:1\n1855#2:239\n1856#2:241\n1855#2:242\n1855#2,2:243\n1856#2:245\n1#3:240\n473#4:246\n*S KotlinDebug\n*F\n+ 1 KotlinChunk.kt\norg/jetbrains/kotlin/jps/build/KotlinChunk$Companion\n*L\n58#1:239\n58#1:241\n62#1:242\n70#1:243,2\n62#1:245\n84#1:246\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void calculateChunkDependencies(@NotNull List<KotlinChunk> chunks, @NotNull Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> byJpsModuleBuildTarget) {
            KotlinChunk chunk;
            Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
            Intrinsics.checkNotNullParameter(byJpsModuleBuildTarget, (String)"byJpsModuleBuildTarget");
            Iterable $this$forEach$iv = chunks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                chunk = (KotlinChunk)element$iv;
                boolean bl = false;
                if (!(!chunk.areChunkDependenciesCalculated)) {
                    boolean $i$a$-check-KotlinChunk$Companion$calculateChunkDependencies$1$22 = false;
                    String $i$a$-check-KotlinChunk$Companion$calculateChunkDependencies$1$22 = "Chunk dependencies should be calculated only once";
                    throw new IllegalStateException($i$a$-check-KotlinChunk$Companion$calculateChunkDependencies$1$22.toString());
                }
                chunk.areChunkDependenciesCalculated = true;
            }
            $this$forEach$iv = chunks;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                chunk = (KotlinChunk)element$iv;
                boolean bl = false;
                chunk._dependencies.addAll(SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMapIterable((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)chunk.getTargets()), (Function1)new Function1<KotlinModuleBuildTarget<?>, List<? extends KotlinModuleBuildTarget.Dependency>>(byJpsModuleBuildTarget){
                    final /* synthetic */ Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> $byJpsModuleBuildTarget;
                    {
                        this.$byJpsModuleBuildTarget = $byJpsModuleBuildTarget;
                        super(1);
                    }

                    @NotNull
                    public final List<KotlinModuleBuildTarget.Dependency> invoke(@NotNull KotlinModuleBuildTarget<?> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return org.jetbrains.kotlin.jps.build.KotlinChunk$Companion.access$calculateTargetDependencies(KotlinChunk.Companion, it, this.$byJpsModuleBuildTarget);
                    }
                }))));
                Iterable $this$forEach$iv2 = chunk._dependencies;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    KotlinModuleBuildTarget.Dependency dependency = (KotlinModuleBuildTarget.Dependency)element$iv2;
                    boolean bl2 = false;
                    dependency.getTarget().getChunk()._dependents.add(dependency);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<KotlinModuleBuildTarget.Dependency> calculateTargetDependencies(KotlinModuleBuildTarget<?> srcTarget, Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> byJpsModuleBuildTarget) {
            KotlinModuleBuildTarget<?> srcProductionTarget;
            void $this$filterIsInstance$iv;
            JpsJavaClasspathKind compileClasspathKind = JpsJavaClasspathKind.compile((boolean)srcTarget.isTests());
            JpsJavaExtensionService jpsJavaExtensionService = JpsJavaExtensionService.getInstance();
            List list = srcTarget.getModule().getDependenciesList().getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"srcTarget.module.dependenciesList.dependencies");
            Sequence sequence = kotlin.collections.CollectionsKt.asSequence((Iterable)list);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$calculateTargetDependencies$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            List dependencies2 = SequencesKt.toMutableList((Sequence)SequencesKt.mapNotNull((Sequence)sequence2, (Function1)((Function1)new Function1<JpsModuleDependency, KotlinModuleBuildTarget.Dependency>(jpsJavaExtensionService, compileClasspathKind, byJpsModuleBuildTarget, srcTarget){
                final /* synthetic */ JpsJavaExtensionService $jpsJavaExtensionService;
                final /* synthetic */ JpsJavaClasspathKind $compileClasspathKind;
                final /* synthetic */ Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> $byJpsModuleBuildTarget;
                final /* synthetic */ KotlinModuleBuildTarget<?> $srcTarget;
                {
                    this.$jpsJavaExtensionService = $jpsJavaExtensionService;
                    this.$compileClasspathKind = $compileClasspathKind;
                    this.$byJpsModuleBuildTarget = $byJpsModuleBuildTarget;
                    this.$srcTarget = $srcTarget;
                    super(1);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final KotlinModuleBuildTarget.Dependency invoke(@NotNull JpsModuleDependency dep) {
                    Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
                    JpsJavaDependencyExtension jpsJavaDependencyExtension = this.$jpsJavaExtensionService.getDependencyExtension((JpsDependencyElement)dep);
                    if (jpsJavaDependencyExtension == null) return null;
                    Object object = jpsJavaDependencyExtension;
                    Object object2 = this.$compileClasspathKind;
                    JpsJavaDependencyExtension it = object;
                    boolean bl = false;
                    if (!it.getScope().isIncludedIn((JpsJavaClasspathKind)object2)) return null;
                    JpsJavaDependencyExtension jpsJavaDependencyExtension2 = object;
                    Object object3 = jpsJavaDependencyExtension2;
                    if (object3 == null) return null;
                    JpsJavaDependencyExtension extension = object3;
                    JpsModule jpsModule = dep.getModule();
                    if (jpsModule == null) return null;
                    object3 = jpsModule;
                    object = this.$byJpsModuleBuildTarget;
                    object2 = this.$srcTarget;
                    it = object3;
                    boolean bl2 = false;
                    KotlinModuleBuildTarget kotlinModuleBuildTarget = (KotlinModuleBuildTarget)object.get(JpsUtilKt.ModuleBuildTarget((JpsModule)it, ((KotlinModuleBuildTarget)object2).isTests()));
                    if (kotlinModuleBuildTarget == null) return null;
                    object3 = kotlinModuleBuildTarget;
                    object = this.$srcTarget;
                    Object it2 = object3;
                    boolean bl3 = false;
                    KotlinModuleBuildTarget.Dependency dependency = new KotlinModuleBuildTarget.Dependency((KotlinModuleBuildTarget<?>)object, (KotlinModuleBuildTarget<?>)it2, extension.isExported());
                    return dependency;
                }
            })));
            if (srcTarget.isTests() && (srcProductionTarget = byJpsModuleBuildTarget.get(JpsUtilKt.ModuleBuildTarget(srcTarget.getModule(), false))) != null) {
                dependencies2.add(new KotlinModuleBuildTarget.Dependency(srcTarget, srcProductionTarget, true));
            }
            return dependencies2;
        }

        public static final /* synthetic */ List access$calculateTargetDependencies(Companion $this, KotlinModuleBuildTarget srcTarget, Map byJpsModuleBuildTarget) {
            return $this.calculateTargetDependencies(srcTarget, byJpsModuleBuildTarget);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

