/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/EnumDeclaringClassDeprecationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class EnumDeclaringClassDeprecationChecker
implements CallChecker {
    @NotNull
    public static final EnumDeclaringClassDeprecationChecker INSTANCE = new EnumDeclaringClassDeprecationChecker();

    private EnumDeclaringClassDeprecationChecker() {
    }

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor resultingDescriptor = resolvedCall.getResultingDescriptor();
        if (!(resultingDescriptor instanceof PropertyDescriptor) || ((PropertyDescriptor)resultingDescriptor).getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = ((PropertyDescriptor)resultingDescriptor).getExtensionReceiverParameter();
        ReceiverValue receiverValue = receiverParameterDescriptor != null ? receiverParameterDescriptor.getValue() : null;
        ExtensionReceiver extensionReceiver = receiverValue instanceof ExtensionReceiver ? (ExtensionReceiver)receiverValue : null;
        if (extensionReceiver == null) {
            return;
        }
        ExtensionReceiver extensionReceiver2 = extensionReceiver;
        if (!Intrinsics.areEqual((Object)((PropertyDescriptor)resultingDescriptor).getName().asString(), (Object)"declaringClass")) {
            return;
        }
        if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getClassId(extensionReceiver2.getType().getConstructor().getDeclarationDescriptor()), (Object)StandardClassIds.INSTANCE.getEnum())) {
            return;
        }
        context.getTrace().report((Diagnostic)ErrorsJvm.ENUM_DECLARING_CLASS_DEPRECATED.on(context.getLanguageVersionSettings(), reportOn));
    }
}

