/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J$\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmArrayVariableInLoopAssignmentChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "isOuterForLoopRangeVariable", "", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "frontend.java"})
public final class JvmArrayVariableInLoopAssignmentChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final JvmArrayVariableInLoopAssignmentChecker INSTANCE = new JvmArrayVariableInLoopAssignmentChecker();

    private JvmArrayVariableInLoopAssignmentChecker() {
    }

    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        KtSimpleNameExpression ktSimpleNameExpression;
        KtBinaryExpression ktBinaryExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (c.languageVersionSettings.supportsFeature(LanguageFeature.ProperForInArrayLoopRangeVariableAssignmentSemantic)) {
            return;
        }
        KtBinaryExpression ktBinaryExpression2 = ktBinaryExpression = expression2 instanceof KtBinaryExpression ? (KtBinaryExpression)expression2 : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.EQ)) {
            return;
        }
        KtExpression ktExpression = binaryExpression.getLeft();
        KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression lhsExpression = ktSimpleNameExpression;
        KtElement ktElement = (KtElement)lhsExpression;
        BindingContext bindingContext = c.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"c.trace.bindingContext");
        ktExpression = CallUtilKt.getResolvedCall((KtElement)ktElement, (BindingContext)bindingContext);
        if (ktExpression == null) {
            return;
        }
        KtExpression resolvedCall = ktExpression;
        Annotated annotated = resolvedCall.getResultingDescriptor();
        LocalVariableDescriptor localVariableDescriptor = bindingContext = annotated instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)annotated : null;
        if (bindingContext == null) {
            return;
        }
        BindingContext variableDescriptor = bindingContext;
        if (variableDescriptor instanceof SyntheticFieldDescriptor) {
            return;
        }
        if (variableDescriptor.isDelegated()) {
            return;
        }
        annotated = variableDescriptor.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"variableDescriptor.returnType");
        Annotated variableType = annotated;
        if (!KotlinBuiltIns.isArrayOrPrimitiveArray((KotlinType)variableType)) {
            return;
        }
        if (!this.isOuterForLoopRangeVariable(expression2, (CallableDescriptor)variableDescriptor, c)) {
            return;
        }
        DataFlowValue.Kind dataFlowValueKind = c.dataFlowValueFactory.createDataFlowValue((KtExpression)lhsExpression, (KotlinType)variableType, c).getKind();
        if (dataFlowValueKind != DataFlowValue.Kind.STABLE_VARIABLE) {
            return;
        }
        c.trace.report((Diagnostic)ErrorsJvm.ASSIGNMENT_TO_ARRAY_LOOP_VARIABLE.on((PsiElement)lhsExpression));
    }

    private final boolean isOuterForLoopRangeVariable(KtExpression expression2, CallableDescriptor variableDescriptor, ResolutionContext<?> c) {
        for (PsiElement parent : PsiUtilsKt.getParents((PsiElement)((PsiElement)expression2))) {
            KtExpression rangeResolvedCall;
            KtSimpleNameExpression ktSimpleNameExpression;
            if (!(parent instanceof KtForExpression)) continue;
            KtExpression ktExpression = ((KtForExpression)parent).getLoopRange();
            KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
            if (ktSimpleNameExpression == null) continue;
            KtSimpleNameExpression rangeExpression = ktSimpleNameExpression;
            KtElement ktElement = (KtElement)rangeExpression;
            BindingContext bindingContext = c.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"c.trace.bindingContext");
            ktExpression = CallUtilKt.getResolvedCall((KtElement)ktElement, (BindingContext)bindingContext);
            if (ktExpression == null || !Intrinsics.areEqual((Object)(rangeResolvedCall = ktExpression).getResultingDescriptor(), (Object)variableDescriptor)) continue;
            return true;
        }
        return false;
    }

    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        AdditionalTypeChecker.DefaultImpls.checkReceiver((AdditionalTypeChecker)this, (ReceiverParameterDescriptor)receiverParameter, (ReceiverValue)receiverArgument, (boolean)safeAccess, c);
    }
}

