/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.load.java.JavaNullabilityAnnotationSettingsKt;
import org.jetbrains.kotlin.load.java.JavaTypeEnhancementState;
import org.jetbrains.kotlin.load.java.Jsr305Settings;
import org.jetbrains.kotlin.load.java.NullabilityAnnotationStates;
import org.jetbrains.kotlin.load.java.NullabilityAnnotationStatesImpl;
import org.jetbrains.kotlin.load.java.ReportLevel;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J?\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J \u0010\u0016\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0002J\u001d\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0018\u0010#\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/cli/common/arguments/JavaTypeEnhancementStateParser;", "", "collector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "kotlinVersion", "Lkotlin/KotlinVersion;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lkotlin/KotlinVersion;)V", "parse", "Lorg/jetbrains/kotlin/load/java/JavaTypeEnhancementState;", "jsr305Args", "", "", "supportCompatqualCheckerFrameworkAnnotations", "jspecifyState", "nullabilityAnnotations", "([Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlin/load/java/JavaTypeEnhancementState;", "parseAnnotationWithReportLevel", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/load/java/ReportLevel;", "item", "sourceCompilerOption", "parseJspecifyReportLevel", "nullabilityAnnotationReportLevels", "Lorg/jetbrains/kotlin/load/java/NullabilityAnnotationStates;", "parseJsr305State", "Lorg/jetbrains/kotlin/load/java/Jsr305Settings;", "args", "([Ljava/lang/String;)Lorg/jetbrains/kotlin/load/java/Jsr305Settings;", "parseNullabilityAnnotationReportLevels", "([Ljava/lang/String;)Lorg/jetbrains/kotlin/load/java/NullabilityAnnotationStates;", "reportDuplicateAnnotation", "", "first", "second", "reportUnrecognizedReportLevel", "Companion", "cli-common"})
public final class JavaTypeEnhancementStateParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageCollector collector;
    @NotNull
    private final KotlinVersion kotlinVersion;
    @NotNull
    private static final JavaTypeEnhancementStateParser DEFAULT = new JavaTypeEnhancementStateParser(MessageCollector.Companion.getNONE(), KotlinVersion.CURRENT);
    @NotNull
    private static final String NULLABILITY_ANNOTATIONS_COMPILER_OPTION = "-Xnullability-annotations";

    public JavaTypeEnhancementStateParser(@NotNull MessageCollector collector, @NotNull KotlinVersion kotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
        this.collector = collector;
        this.kotlinVersion = kotlinVersion;
    }

    @NotNull
    public final JavaTypeEnhancementState parse(@Nullable String[] jsr305Args, @Nullable String supportCompatqualCheckerFrameworkAnnotations, @Nullable String jspecifyState, @Nullable String[] nullabilityAnnotations) {
        ReportLevel reportLevel;
        NullabilityAnnotationStates<ReportLevel> nullabilityAnnotationReportLevels = this.parseNullabilityAnnotationReportLevels(nullabilityAnnotations);
        String string = supportCompatqualCheckerFrameworkAnnotations;
        if (Intrinsics.areEqual((Object)string, (Object)"enable")) {
            reportLevel = ReportLevel.STRICT;
        } else if (Intrinsics.areEqual((Object)string, (Object)"disable")) {
            reportLevel = ReportLevel.IGNORE;
        } else if (string == null) {
            reportLevel = JavaNullabilityAnnotationSettingsKt.getReportLevelForAnnotation(JavaNullabilityAnnotationSettingsKt.getCHECKER_FRAMEWORK_COMPATQUAL_ANNOTATIONS_PACKAGE(), nullabilityAnnotationReportLevels, this.kotlinVersion);
        } else {
            MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.ERROR, "Unrecognized -Xsupport-compatqual-checker-framework-annotations option: " + supportCompatqualCheckerFrameworkAnnotations + ". Possible values are 'enable'/'disable'", null, 4, null);
            reportLevel = JavaNullabilityAnnotationSettingsKt.getReportLevelForAnnotation(JavaNullabilityAnnotationSettingsKt.getCHECKER_FRAMEWORK_COMPATQUAL_ANNOTATIONS_PACKAGE(), nullabilityAnnotationReportLevels, this.kotlinVersion);
        }
        ReportLevel compatqualCheckerFrameworkAnnotationsReportLevel = reportLevel;
        Jsr305Settings jsr305Settings = this.parseJsr305State(jsr305Args);
        ReportLevel jspecifyReportLevel = this.parseJspecifyReportLevel(jspecifyState, nullabilityAnnotationReportLevels);
        return new JavaTypeEnhancementState(jsr305Settings, (Function1<? super FqName, ? extends ReportLevel>)((Function1)new Function1<FqName, ReportLevel>(jspecifyReportLevel, compatqualCheckerFrameworkAnnotationsReportLevel, nullabilityAnnotationReportLevels, this){
            final /* synthetic */ ReportLevel $jspecifyReportLevel;
            final /* synthetic */ ReportLevel $compatqualCheckerFrameworkAnnotationsReportLevel;
            final /* synthetic */ NullabilityAnnotationStates<ReportLevel> $nullabilityAnnotationReportLevels;
            final /* synthetic */ JavaTypeEnhancementStateParser this$0;
            {
                this.$jspecifyReportLevel = $jspecifyReportLevel;
                this.$compatqualCheckerFrameworkAnnotationsReportLevel = $compatqualCheckerFrameworkAnnotationsReportLevel;
                this.$nullabilityAnnotationReportLevels = $nullabilityAnnotationReportLevels;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ReportLevel invoke(@NotNull FqName it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FqNamesUtilKt.isSubpackageOf(it, JavaNullabilityAnnotationSettingsKt.getJSPECIFY_ANNOTATIONS_PACKAGE()) ? this.$jspecifyReportLevel : (FqNamesUtilKt.isSubpackageOf(it, JavaNullabilityAnnotationSettingsKt.getCHECKER_FRAMEWORK_COMPATQUAL_ANNOTATIONS_PACKAGE()) ? this.$compatqualCheckerFrameworkAnnotationsReportLevel : JavaNullabilityAnnotationSettingsKt.getReportLevelForAnnotation(it, this.$nullabilityAnnotationReportLevels, JavaTypeEnhancementStateParser.access$getKotlinVersion$p(this.this$0)));
            }
        }));
    }

    private final Pair<FqName, ReportLevel> parseNullabilityAnnotationReportLevels(String item) {
        if (!StringsKt.startsWith$default((String)item, (String)"@", (boolean)false, (int)2, null)) {
            this.reportUnrecognizedReportLevel(item, NULLABILITY_ANNOTATIONS_COMPILER_OPTION);
            return null;
        }
        Pair<FqName, ReportLevel> pair = this.parseAnnotationWithReportLevel(item, NULLABILITY_ANNOTATIONS_COMPILER_OPTION);
        if (pair == null) {
            return null;
        }
        Pair<FqName, ReportLevel> pair2 = pair;
        FqName name = (FqName)pair2.component1();
        ReportLevel state = (ReportLevel)((Object)pair2.component2());
        return TuplesKt.to((Object)name, (Object)((Object)state));
    }

    private final NullabilityAnnotationStates<ReportLevel> parseNullabilityAnnotationReportLevels(String[] nullabilityAnnotations) {
        String[] stringArray = nullabilityAnnotations;
        if (stringArray == null || stringArray.length == 0) {
            return NullabilityAnnotationStates.Companion.getEMPTY();
        }
        Map annotationsWithReportLevels = new LinkedHashMap();
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])nullabilityAnnotations);
        while (iterator2.hasNext()) {
            String item = (String)iterator2.next();
            Pair<FqName, ReportLevel> pair = this.parseNullabilityAnnotationReportLevels(item);
            if (pair == null) continue;
            Pair<FqName, ReportLevel> pair2 = pair;
            FqName name = (FqName)pair2.component1();
            ReportLevel state = (ReportLevel)((Object)pair2.component2());
            ReportLevel current = (ReportLevel)((Object)annotationsWithReportLevels.get(name));
            if (current == null) {
                Map map = annotationsWithReportLevels;
                map.put(name, state);
                continue;
            }
            if (current == state) continue;
            this.reportDuplicateAnnotation("" + '@' + name + ':' + current.getDescription(), item, NULLABILITY_ANNOTATIONS_COMPILER_OPTION);
        }
        return new NullabilityAnnotationStatesImpl(annotationsWithReportLevels);
    }

    private final ReportLevel parseJspecifyReportLevel(String jspecifyState, NullabilityAnnotationStates<? extends ReportLevel> nullabilityAnnotationReportLevels) {
        if (jspecifyState == null) {
            return JavaNullabilityAnnotationSettingsKt.getReportLevelForAnnotation(JavaNullabilityAnnotationSettingsKt.getJSPECIFY_ANNOTATIONS_PACKAGE(), nullabilityAnnotationReportLevels, this.kotlinVersion);
        }
        ReportLevel reportLevel = ReportLevel.Companion.findByDescription(jspecifyState);
        if (reportLevel == null) {
            MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.ERROR, "Unrecognized -Xjspecify-annotations option: " + jspecifyState + ". Possible values are 'disable'/'warn'/'strict'", null, 4, null);
            return JavaNullabilityAnnotationSettingsKt.getReportLevelForAnnotation(JavaNullabilityAnnotationSettingsKt.getJSPECIFY_ANNOTATIONS_PACKAGE(), nullabilityAnnotationReportLevels, this.kotlinVersion);
        }
        return reportLevel;
    }

    private final Jsr305Settings parseJsr305State(String[] args) {
        Map map;
        ReportLevel global = null;
        ReportLevel migration = null;
        Map userDefined = new LinkedHashMap();
        String compilerOption = "-Xjsr305";
        Jsr305Settings defaultSettings = JavaNullabilityAnnotationSettingsKt.getDefaultJsr305Settings(this.kotlinVersion);
        String[] stringArray = args;
        if (stringArray != null) {
            String[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            for (String element$iv : $this$forEach$iv) {
                String item = element$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)item, (String)"@", (boolean)false, (int)2, null)) {
                    Pair<FqName, ReportLevel> pair = this.parseAnnotationWithReportLevel(item, compilerOption);
                    if (pair == null) continue;
                    Pair<FqName, ReportLevel> pair2 = pair;
                    FqName name = (FqName)pair2.component1();
                    ReportLevel state = (ReportLevel)((Object)pair2.component2());
                    ReportLevel current = (ReportLevel)((Object)userDefined.get(name));
                    if (current != null) continue;
                    Map map2 = userDefined;
                    map2.put(name, state);
                    continue;
                }
                if (StringsKt.startsWith$default((String)item, (String)"under-migration", (boolean)false, (int)2, null)) {
                    ReportLevel state = JavaTypeEnhancementStateParser.parseJsr305State$parseJsr305UnderMigration(this, compilerOption, item);
                    if (migration != null) continue;
                    migration = state;
                    continue;
                }
                if (Intrinsics.areEqual((Object)item, (Object)"enable")) {
                    MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.STRONG_WARNING, "Option 'enable' for -Xjsr305 flag is deprecated. Please use 'strict' instead", null, 4, null);
                    if (global != null) continue;
                    global = ReportLevel.STRICT;
                    continue;
                }
                if (global != null) continue;
                global = ReportLevel.Companion.findByDescription(item);
            }
        }
        Object object = global;
        ReportLevel globalLevel = object == null ? defaultSettings.getGlobalLevel() : object;
        object = migration;
        Map map3 = map = userDefined;
        ReportLevel reportLevel = object == null ? JavaNullabilityAnnotationSettingsKt.getDefaultMigrationJsr305ReportLevelForGivenGlobal(globalLevel) : object;
        ReportLevel reportLevel2 = globalLevel;
        boolean bl = false;
        boolean bl2 = !map3.isEmpty();
        object = bl2 ? map : null;
        Object object2 = object == null ? defaultSettings.getUserDefinedLevelForSpecificAnnotation() : object;
        ReportLevel reportLevel3 = reportLevel;
        ReportLevel reportLevel4 = reportLevel2;
        return new Jsr305Settings(reportLevel4, reportLevel3, (Map<FqName, ? extends ReportLevel>)object2);
    }

    private final void reportUnrecognizedReportLevel(String item, String sourceCompilerOption) {
        MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.ERROR, "Unrecognized " + sourceCompilerOption + " value: " + item, null, 4, null);
    }

    private final void reportDuplicateAnnotation(String first, String second, String sourceCompilerOption) {
        MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.ERROR, "Conflict duplicating " + sourceCompilerOption + " value: " + first + ", " + second, null, 4, null);
    }

    private final Pair<FqName, ReportLevel> parseAnnotationWithReportLevel(String item, String sourceCompilerOption) {
        Object object;
        String string = item.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        Object object2 = new String[]{":"};
        Object it = object2 = StringsKt.split$default((CharSequence)string, (String[])object2, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Object object3 = object = it.size() == 2 ? object2 : null;
        if (object == null) {
            object2 = this;
            JavaTypeEnhancementStateParser $this$parseAnnotationWithReportLevel_u24lambda_u2d5 = (JavaTypeEnhancementStateParser)object2;
            boolean bl2 = false;
            $this$parseAnnotationWithReportLevel_u24lambda_u2d5.reportUnrecognizedReportLevel(item, sourceCompilerOption);
            return null;
        }
        Object object4 = object;
        String name = (String)object4.get(0);
        String rawState = (String)object4.get(1);
        ReportLevel reportLevel = ReportLevel.Companion.findByDescription(rawState);
        if (reportLevel == null) {
            JavaTypeEnhancementStateParser javaTypeEnhancementStateParser;
            JavaTypeEnhancementStateParser $this$parseAnnotationWithReportLevel_u24lambda_u2d6 = javaTypeEnhancementStateParser = this;
            boolean bl3 = false;
            $this$parseAnnotationWithReportLevel_u24lambda_u2d6.reportUnrecognizedReportLevel(item, sourceCompilerOption);
            return null;
        }
        ReportLevel state = reportLevel;
        return TuplesKt.to((Object)new FqName(name), (Object)((Object)state));
    }

    private static final ReportLevel parseJsr305State$parseJsr305UnderMigration(JavaTypeEnhancementStateParser this$0, String compilerOption, String item) {
        Object object;
        Object object2 = new String[]{":"};
        Object it = object2 = StringsKt.split$default((CharSequence)item, (String[])object2, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Object object3 = it.size() == 2 ? object2 : null;
        String rawState = object3 == null ? null : (String)object3.get(1);
        if ((object3 = ReportLevel.Companion.findByDescription(rawState)) == null) {
            this$0.reportUnrecognizedReportLevel(item, compilerOption);
            it = object2 = Unit.INSTANCE;
            boolean bl2 = false;
            object = null;
        } else {
            object = object3;
        }
        return object;
    }

    public static final /* synthetic */ KotlinVersion access$getKotlinVersion$p(JavaTypeEnhancementStateParser $this) {
        return $this.kotlinVersion;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/cli/common/arguments/JavaTypeEnhancementStateParser$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/cli/common/arguments/JavaTypeEnhancementStateParser;", "NULLABILITY_ANNOTATIONS_COMPILER_OPTION", "", "parsePlainNullabilityAnnotationReportLevels", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/load/java/ReportLevel;", "nullabilityAnnotations", "cli-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<FqName, ReportLevel> parsePlainNullabilityAnnotationReportLevels(@NotNull String nullabilityAnnotations) {
            Intrinsics.checkNotNullParameter((Object)nullabilityAnnotations, (String)"nullabilityAnnotations");
            Pair pair = DEFAULT.parseNullabilityAnnotationReportLevels(nullabilityAnnotations);
            Intrinsics.checkNotNull((Object)pair);
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

