/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.SourceProvider;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollector;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollectorKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.android.AndroidBaseSourceSetName;
import org.jetbrains.kotlin.gradle.plugin.sources.android.AndroidVariantTypeKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetFactory;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayout;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayoutExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetNaming;
import org.jetbrains.kotlin.gradle.utils.AndroidExtensionUitlsKt;
import org.jetbrains.kotlin.gradle.utils.FailuresKt;
import org.jetbrains.kotlin.gradle.utils.ForEachAndroidVariantKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSets;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "applyKotlinAndroidSourceSetLayout", "", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "layout", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinAndroidSourceSets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAndroidSourceSets.kt\norg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSets\n+ 2 runProjectConfigurationHealthCheck.kt\norg/jetbrains/kotlin/gradle/utils/RunProjectConfigurationHealthCheckKt\n*L\n1#1,64:1\n59#2,6:65\n*S KotlinDebug\n*F\n+ 1 KotlinAndroidSourceSets.kt\norg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSets\n*L\n31#1:65,6\n*E\n"})
public final class KotlinAndroidSourceSets {
    @NotNull
    public static final KotlinAndroidSourceSets INSTANCE = new KotlinAndroidSourceSets();
    private static final Logger logger = Logging.getLogger(INSTANCE.getClass());

    private KotlinAndroidSourceSets() {
    }

    public final void applyKotlinAndroidSourceSetLayout(@NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        logger.debug("Applying " + KotlinAndroidSourceSetLayout.class.getSimpleName() + ": " + layout.getName());
        Project project = target2.getProject();
        BaseExtension android = AndroidExtensionUitlsKt.getAndroidExtension(project);
        KotlinToolingDiagnosticsCollector diagnosticsCollector = KotlinToolingDiagnosticsCollectorKt.getKotlinToolingDiagnosticsCollector(project);
        KotlinAndroidSourceSetFactory factory2 = new KotlinAndroidSourceSetFactory(target2, KotlinProjectExtensionKt.getKotlinExtension(project), layout, diagnosticsCollector);
        Project $this$runProjectConfigurationHealthCheck$iv = project;
        boolean $i$f$runProjectConfigurationHealthCheck = false;
        if (!(!((Collection)FailuresKt.getFailures($this$runProjectConfigurationHealthCheck$iv)).isEmpty())) {
            Project $this$applyKotlinAndroidSourceSetLayout_u24lambda_u240 = $this$runProjectConfigurationHealthCheck$iv;
            boolean bl = false;
            layout.getChecker().checkBeforeLayoutApplied(diagnosticsCollector, target2, layout);
        }
        android.getSourceSets().all(new Action(layout, target2, factory2){
            final /* synthetic */ KotlinAndroidSourceSetLayout $layout;
            final /* synthetic */ KotlinAndroidTarget $target;
            final /* synthetic */ KotlinAndroidSourceSetFactory $factory;
            {
                this.$layout = $layout;
                this.$target = $target;
                this.$factory = $factory;
            }

            public final void execute(AndroidSourceSet androidSourceSet) {
                AndroidBaseSourceSetName androidBaseSourceSetName = AndroidBaseSourceSetName.Companion.byName(androidSourceSet.getName());
                String string = this.$layout.getNaming().kotlinSourceSetName(this.$target.getDisambiguationClassifier(), androidSourceSet.getName(), androidBaseSourceSetName != null ? AndroidVariantTypeKt.getVariantType(androidBaseSourceSetName) : null);
                if (string == null) {
                    return;
                }
                String kotlinSourceSetName = string;
                Intrinsics.checkNotNullExpressionValue((Object)androidSourceSet, (String)"androidSourceSet");
                this.$factory.getOrCreateConfiguredKotlinSourceSet(kotlinSourceSetName, androidSourceSet);
            }
        });
        ForEachAndroidVariantKt.forAllAndroidVariants(project, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>(android, layout, target2, factory2){
            final /* synthetic */ BaseExtension $android;
            final /* synthetic */ KotlinAndroidSourceSetLayout $layout;
            final /* synthetic */ KotlinAndroidTarget $target;
            final /* synthetic */ KotlinAndroidSourceSetFactory $factory;
            {
                this.$android = $android;
                this.$layout = $layout;
                this.$target = $target;
                this.$factory = $factory;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(BaseVariant variant) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                List list = variant.getSourceSets();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.sourceSets");
                Iterable iterable = list;
                BaseExtension baseExtension = this.$android;
                KotlinAndroidSourceSetLayout kotlinAndroidSourceSetLayout = this.$layout;
                KotlinAndroidTarget kotlinAndroidTarget = this.$target;
                KotlinAndroidSourceSetFactory kotlinAndroidSourceSetFactory = this.$factory;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String kotlinSourceSetName;
                    AndroidSourceSet androidSourceSet;
                    SourceProvider sourceProvider = (SourceProvider)element$iv;
                    boolean bl = false;
                    if ((AndroidSourceSet)baseExtension.getSourceSets().findByName(sourceProvider.getName()) == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)androidSourceSet, (String)"android.sourceSets.findB\u2026r.name) ?: return@forEach");
                    KotlinAndroidSourceSetNaming kotlinAndroidSourceSetNaming = kotlinAndroidSourceSetLayout.getNaming();
                    String string = kotlinAndroidTarget.getDisambiguationClassifier();
                    String string2 = sourceProvider.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourceProvider.name");
                    if (kotlinAndroidSourceSetNaming.kotlinSourceSetName(string, string2, AndroidVariantTypeKt.getType(variant)) == null) continue;
                    KotlinSourceSet kotlinSourceSet = kotlinAndroidSourceSetFactory.getOrCreateConfiguredKotlinSourceSet(kotlinSourceSetName, androidSourceSet);
                    kotlinAndroidSourceSetLayout.getSourceSetConfigurator().configureWithVariant(kotlinAndroidTarget, kotlinSourceSet, variant);
                }
            }
        }));
    }

    public static /* synthetic */ void applyKotlinAndroidSourceSetLayout$default(KotlinAndroidSourceSets kotlinAndroidSourceSets, KotlinAndroidTarget kotlinAndroidTarget, KotlinAndroidSourceSetLayout kotlinAndroidSourceSetLayout, int n, Object object) {
        if ((n & 2) != 0) {
            kotlinAndroidSourceSetLayout = KotlinAndroidSourceSetLayoutExtensionKt.getKotlinAndroidSourceSetLayout(kotlinAndroidTarget.getProject());
        }
        kotlinAndroidSourceSets.applyKotlinAndroidSourceSetLayout(kotlinAndroidTarget, kotlinAndroidSourceSetLayout);
    }
}

