/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.VersionKind;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.gradle.internal.config.AnalysisFlag;
import org.jetbrains.kotlin.gradle.internal.config.ExplicitApiMode;
import org.jetbrains.kotlin.gradle.internal.config.LanguageFeature;
import org.jetbrains.kotlin.gradle.internal.config.LanguageOrApiVersion;
import org.jetbrains.kotlin.gradle.internal.config.LanguageVersion;
import org.jetbrains.kotlin.gradle.internal.config.LanguageVersionSettings;
import org.jetbrains.kotlin.gradle.internal.config.LanguageVersionSettingsImpl;

@Metadata(k=2, mv={2, 0, 0}, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a1\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\u0004\u0010\n\u001a+\u0010\u0010\u001a\u00020\u000f*\u00020\u00002\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a!\u0010\u0012\u001a\u00020\u000f*\u00020\u00002\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a+\u0010\u0016\u001a\u00020\u000f*\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0011\u001a5\u0010\u001a\u001a\u0018\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a#\u0010\u001c\u001a\u00020\u000f*\u00020\u00002\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0013\u001a\u001b\u0010\u001d\u001a\u00020\u000f*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a\u001b\u0010\u001f\u001a\u00020\u000b*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u001f\u0010 \u001a/\u0010$\u001a\u0004\u0018\u00010\u000b*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010#\u001a\u00020!H\u0002\u00a2\u0006\u0004\b$\u0010%\u001a1\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0&*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b'\u0010(\u001a%\u0010+\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0&*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "collector", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersionSettings;", "toLanguageVersionSettings", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersionSettings;", "", "Lorg/jetbrains/kotlin/gradle/internal/config/AnalysisFlag;", "", "additionalAnalysisFlags", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/Map;)Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersion;", "languageVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "apiVersion", "", "checkApiVersionIsNotGreaterThenLanguageVersion", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "checkLanguageVersionIsStable", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersion;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "language", "api", "checkOutdatedVersions", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageOrApiVersion;", "Lorg/jetbrains/kotlin/cli/common/arguments/VersionKind;", "findOutdatedVersion", "(Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;)Lkotlin/Triple;", "checkProgressiveMode", "checkExplicitApiAndExplicitReturnTypesAtTheSameTime", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "parseOrConfigureLanguageVersion", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersion;", "", "value", "versionOf", "parseVersion", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/lang/String;Ljava/lang/String;)Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersion;", "", "configureAnalysisFlags", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersion;)Ljava/util/Map;", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageFeature;", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageFeature$State;", "configureLanguageFeatures", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Ljava/util/Map;", "cli-common"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
@SourceDebugExtension(value={"SMAP\nCommonCompilerArgumentsConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonCompilerArgumentsConfigurator.kt\norg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArgumentsConfiguratorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n827#2:360\n855#2,2:361\n1563#2:363\n1634#2,3:364\n*S KotlinDebug\n*F\n+ 1 CommonCompilerArgumentsConfigurator.kt\norg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArgumentsConfiguratorKt\n*L\n346#1:360\n346#1:361,2\n346#1:363\n346#1:364,3\n*E\n"})
public final class CommonCompilerArgumentsConfiguratorKt {
    @NotNull
    public static final LanguageVersionSettings toLanguageVersionSettings(@NotNull CommonCompilerArguments $this$toLanguageVersionSettings, @NotNull MessageCollector collector) {
        Intrinsics.checkNotNullParameter((Object)$this$toLanguageVersionSettings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        return CommonCompilerArgumentsConfiguratorKt.toLanguageVersionSettings($this$toLanguageVersionSettings, collector, MapsKt.emptyMap());
    }

    @NotNull
    public static final LanguageVersionSettings toLanguageVersionSettings(@NotNull CommonCompilerArguments $this$toLanguageVersionSettings, @NotNull MessageCollector collector, @NotNull Map<AnalysisFlag<?>, ? extends Object> additionalAnalysisFlags) {
        Intrinsics.checkNotNullParameter((Object)$this$toLanguageVersionSettings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter(additionalAnalysisFlags, (String)"additionalAnalysisFlags");
        LanguageVersion languageVersion2 = CommonCompilerArgumentsConfiguratorKt.parseOrConfigureLanguageVersion($this$toLanguageVersionSettings, collector);
        LanguageVersion languageVersion3 = CommonCompilerArgumentsConfiguratorKt.parseVersion($this$toLanguageVersionSettings, collector, $this$toLanguageVersionSettings.getApiVersion(), "API");
        if (languageVersion3 == null) {
            languageVersion3 = languageVersion2;
        }
        ApiVersion apiVersion2 = ApiVersion.Companion.createByLanguageVersion(languageVersion3);
        CommonCompilerArgumentsConfiguratorKt.checkApiVersionIsNotGreaterThenLanguageVersion($this$toLanguageVersionSettings, languageVersion2, apiVersion2, collector);
        LanguageVersionSettingsImpl languageVersionSettings = new LanguageVersionSettingsImpl(languageVersion2, apiVersion2, MapsKt.plus(CommonCompilerArgumentsConfiguratorKt.configureAnalysisFlags($this$toLanguageVersionSettings, collector, languageVersion2), additionalAnalysisFlags), CommonCompilerArgumentsConfiguratorKt.configureLanguageFeatures($this$toLanguageVersionSettings, collector));
        CommonCompilerArgumentsConfiguratorKt.checkLanguageVersionIsStable($this$toLanguageVersionSettings, languageVersion2, collector);
        CommonCompilerArgumentsConfiguratorKt.checkOutdatedVersions($this$toLanguageVersionSettings, languageVersion2, apiVersion2, collector);
        CommonCompilerArgumentsConfiguratorKt.checkProgressiveMode($this$toLanguageVersionSettings, languageVersion2, collector);
        CommonCompilerArgumentsConfiguratorKt.checkExplicitApiAndExplicitReturnTypesAtTheSameTime($this$toLanguageVersionSettings, collector);
        return languageVersionSettings;
    }

    private static final void checkApiVersionIsNotGreaterThenLanguageVersion(CommonCompilerArguments $this$checkApiVersionIsNotGreaterThenLanguageVersion, LanguageVersion languageVersion2, ApiVersion apiVersion2, MessageCollector collector) {
        if (apiVersion2.compareTo(ApiVersion.Companion.createByLanguageVersion(languageVersion2)) > 0) {
            if (!$this$checkApiVersionIsNotGreaterThenLanguageVersion.getSuppressApiVersionGreaterThanLanguageVersionError()) {
                MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, "-api-version (" + apiVersion2.getVersionString() + ") cannot be greater than -language-version (" + languageVersion2.getVersionString() + ')', null, 4, null);
            }
        } else if ($this$checkApiVersionIsNotGreaterThenLanguageVersion.getSuppressApiVersionGreaterThanLanguageVersionError()) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.WARNING, "Useless suppress -Xsuppress-api-version-greater-than-language-version-error", null, 4, null);
        }
    }

    public static final void checkLanguageVersionIsStable(@NotNull CommonCompilerArguments $this$checkLanguageVersionIsStable, @NotNull LanguageVersion languageVersion2, @NotNull MessageCollector collector) {
        Intrinsics.checkNotNullParameter((Object)$this$checkLanguageVersionIsStable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)languageVersion2, (String)"languageVersion");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        if (!languageVersion2.isStable() && !$this$checkLanguageVersionIsStable.getSuppressVersionWarnings()) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.STRONG_WARNING, "Language version " + languageVersion2.getVersionString() + " is experimental, there are no backwards compatibility guarantees for new language and library features", null, 4, null);
        }
    }

    private static final void checkOutdatedVersions(CommonCompilerArguments $this$checkOutdatedVersions, LanguageVersion language, ApiVersion api, MessageCollector collector) {
        Triple<LanguageOrApiVersion, LanguageOrApiVersion, VersionKind> triple = CommonCompilerArgumentsConfiguratorKt.findOutdatedVersion(language, api);
        if (triple == null) {
            return;
        }
        Triple<LanguageOrApiVersion, LanguageOrApiVersion, VersionKind> triple2 = triple;
        LanguageOrApiVersion version2 = (LanguageOrApiVersion)triple2.component1();
        LanguageOrApiVersion supportedVersion = (LanguageOrApiVersion)triple2.component2();
        VersionKind versionKind = (VersionKind)((Object)triple2.component3());
        if (version2.isUnsupported()) {
            StringBuilder stringBuilder = new StringBuilder().append(versionKind.getText()).append(" version ").append(version2.getVersionString()).append(" is no longer supported; please, use version ");
            LanguageOrApiVersion languageOrApiVersion = supportedVersion;
            Intrinsics.checkNotNull((Object)languageOrApiVersion);
            MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, stringBuilder.append(languageOrApiVersion.getVersionString()).append(" or greater.").toString(), null, 4, null);
        } else if (version2.isDeprecated() && !$this$checkOutdatedVersions.getSuppressVersionWarnings()) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.STRONG_WARNING, versionKind.getText() + " version " + version2.getVersionString() + " is deprecated and its support will be removed in a future version of Kotlin", null, 4, null);
        }
    }

    private static final Triple<LanguageOrApiVersion, LanguageOrApiVersion, VersionKind> findOutdatedVersion(LanguageVersion language, ApiVersion api) {
        return language.isUnsupported() ? new Triple((Object)language, (Object)LanguageVersion.FIRST_SUPPORTED, (Object)VersionKind.LANGUAGE) : (api.isUnsupported() ? new Triple((Object)api, (Object)ApiVersion.FIRST_SUPPORTED, (Object)VersionKind.API) : (language.isDeprecated() ? new Triple((Object)language, null, (Object)VersionKind.LANGUAGE) : (api.isDeprecated() ? new Triple((Object)api, null, (Object)VersionKind.API) : null)));
    }

    private static final void checkProgressiveMode(CommonCompilerArguments $this$checkProgressiveMode, LanguageVersion languageVersion2, MessageCollector collector) {
        if ($this$checkProgressiveMode.getProgressiveMode() && languageVersion2.compareTo((Enum)LanguageVersion.LATEST_STABLE) < 0 && !$this$checkProgressiveMode.getSuppressVersionWarnings()) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.STRONG_WARNING, "'-progressive' is meaningful only for the latest language version (" + LanguageVersion.LATEST_STABLE + "), while this build uses " + languageVersion2 + "\nCompiler behavior in such mode is undefined; please, consider moving to the latest stable version or turning off progressive mode.", null, 4, null);
        }
    }

    private static final void checkExplicitApiAndExplicitReturnTypesAtTheSameTime(CommonCompilerArguments $this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime, MessageCollector collector) {
        if (Intrinsics.areEqual((Object)$this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitApi(), (Object)ExplicitApiMode.DISABLED.getState()) || Intrinsics.areEqual((Object)$this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitReturnTypes(), (Object)ExplicitApiMode.DISABLED.getState())) {
            return;
        }
        if (!Intrinsics.areEqual((Object)$this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitApi(), (Object)$this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitReturnTypes())) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, StringsKt.trimIndent((String)("\n                    '-Xexplicit-api' and '-XXexplicit-return-types' flags cannot have different values at the same time.\n                    Consider use only one of those flags\n                    Passed:\n                      '-Xexplicit-api=" + $this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitApi() + "'\n                      '-XXexplicit-return-types=" + $this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitReturnTypes() + "'\n                    ")), null, 4, null);
        }
    }

    private static final LanguageVersion parseOrConfigureLanguageVersion(CommonCompilerArguments $this$parseOrConfigureLanguageVersion, MessageCollector collector) {
        LanguageVersion languageVersion2;
        if ($this$parseOrConfigureLanguageVersion.getUseK2()) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, "Compiler flag -Xuse-k2 is no more supported. Compiler versions 2.0+ use K2 by default, unless the language version is set to 1.9 or earlier", null, 4, null);
        }
        if ((languageVersion2 = CommonCompilerArgumentsConfiguratorKt.parseVersion($this$parseOrConfigureLanguageVersion, collector, $this$parseOrConfigureLanguageVersion.getLanguageVersion(), "language")) == null) {
            languageVersion2 = LanguageVersion.LATEST_STABLE;
        }
        return languageVersion2;
    }

    /*
     * WARNING - void declaration
     */
    private static final LanguageVersion parseVersion(CommonCompilerArguments $this$parseVersion, MessageCollector collector, String value2, String versionOf) {
        LanguageVersion languageVersion2;
        if (value2 == null) {
            languageVersion2 = null;
        } else {
            languageVersion2 = LanguageVersion.Companion.fromVersionString(value2);
            if (languageVersion2 == null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                LanguageVersion p0;
                void $this$filterNotTo$iv$iv;
                CommonCompilerArguments $this$parseVersion_u24lambda_u240 = $this$parseVersion;
                boolean bl = false;
                Iterable $this$filterNot$iv = (Iterable)LanguageVersion.getEntries();
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    p0 = (LanguageVersion)element$iv$iv;
                    boolean bl2 = false;
                    if (p0.isUnsupported()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    p0 = (LanguageVersion)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(p0.getDescription());
                }
                List versionStrings = (List)destination$iv$iv;
                String message2 = "Unknown " + versionOf + " version: " + value2 + "\nSupported " + versionOf + " versions: " + CollectionsKt.joinToString$default((Iterable)versionStrings, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                collector.report(CompilerMessageSeverity.ERROR, message2, null);
                languageVersion2 = null;
            }
        }
        return languageVersion2;
    }

    @NotNull
    public static final Map<AnalysisFlag<?>, Object> configureAnalysisFlags(@NotNull CommonCompilerArguments $this$configureAnalysisFlags, @NotNull MessageCollector collector, @NotNull LanguageVersion languageVersion2) {
        Intrinsics.checkNotNullParameter((Object)$this$configureAnalysisFlags, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)languageVersion2, (String)"languageVersion");
        return $this$configureAnalysisFlags.getConfigurator().configureAnalysisFlags($this$configureAnalysisFlags, collector, languageVersion2);
    }

    @NotNull
    public static final Map<LanguageFeature, LanguageFeature.State> configureLanguageFeatures(@NotNull CommonCompilerArguments $this$configureLanguageFeatures, @NotNull MessageCollector collector) {
        Intrinsics.checkNotNullParameter((Object)$this$configureLanguageFeatures, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        return $this$configureLanguageFeatures.getConfigurator().configureLanguageFeatures($this$configureLanguageFeatures, collector);
    }
}

