/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.npm;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCompilationsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJsCompilation;
import org.jetbrains.kotlin.gradle.targets.js.dsl.KotlinJsTargetDsl;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsEnv;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootExtension;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootPlugin;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProject;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjectModules;
import org.jetbrains.kotlin.gradle.targets.js.npm.tasks.KotlinPackageJsonTask;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u0000 J2\u00020\u0001:\u0001JB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010<\u001a\u00020\bH\u0002J\u000e\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\bJ\u0017\u0010?\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b@J\b\u0010A\u001a\u00020\bH\u0016J4\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\b2\u000e\b\u0002\u0010G\u001a\b\u0012\u0004\u0012\u00020\b0H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\b0HR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0010\u001a\u0004\b\u001b\u0010\nR\u001b\u0010\u001d\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0010\u001a\u0004\b\u001e\u0010\nR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000eR\u0011\u0010&\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000eR\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\nR#\u0010.\u001a\n /*\u0004\u0018\u00010\b0\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u0010\u001a\u0004\b0\u0010\nR\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\nR\u0011\u00108\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProject;", "Ljava/io/Serializable;", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;)V", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "compilationName", "", "getCompilationName", "()Ljava/lang/String;", "dir", "Ljava/io/File;", "getDir", "()Ljava/io/File;", "dir$delegate", "Lkotlin/Lazy;", "dist", "getDist", "extension", "main", "getMain", "modules", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProjectModules;", "getModules$kotlin_gradle_plugin_common", "()Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProjectModules;", "name", "getName", "name$delegate", "nodeExecutable", "getNodeExecutable", "nodeExecutable$delegate", "nodeJs", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsRootExtension;", "getNodeJs", "()Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsRootExtension;", "nodeModulesDir", "getNodeModulesDir", "packageJsonFile", "getPackageJsonFile", "packageJsonTask", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/tasks/KotlinPackageJsonTask;", "getPackageJsonTask", "()Lorg/jetbrains/kotlin/gradle/targets/js/npm/tasks/KotlinPackageJsonTask;", "packageJsonTaskName", "getPackageJsonTaskName", "packageJsonTaskPath", "kotlin.jvm.PlatformType", "getPackageJsonTaskPath", "packageJsonTaskPath$delegate", "project", "Lorg/gradle/api/Project;", "getProject", "()Lorg/gradle/api/Project;", "publicPackageJsonTaskName", "getPublicPackageJsonTaskName", "target", "Lorg/jetbrains/kotlin/gradle/targets/js/dsl/KotlinJsTargetDsl;", "getTarget", "()Lorg/jetbrains/kotlin/gradle/targets/js/dsl/KotlinJsTargetDsl;", "buildNpmProjectName", "require", "request", "resolve", "resolve$kotlin_gradle_plugin_common", "toString", "useTool", "", "exec", "Lorg/gradle/process/ExecSpec;", "tool", "nodeArgs", "", "args", "Companion", "kotlin-gradle-plugin_common"})
public class NpmProject
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final transient KotlinJsCompilation compilation;
    @NotNull
    private final String compilationName;
    @NotNull
    private final String extension;
    @NotNull
    private final Lazy name$delegate;
    @NotNull
    private final transient NodeJsRootExtension nodeJs;
    @NotNull
    private final Lazy dir$delegate;
    @NotNull
    private final Lazy packageJsonTaskPath$delegate;
    @NotNull
    private final NpmProjectModules modules;
    @NotNull
    private final Lazy nodeExecutable$delegate;
    @NotNull
    public static final String PACKAGE_JSON = "package.json";
    @NotNull
    public static final String NODE_MODULES = "node_modules";
    @NotNull
    public static final String DIST_FOLDER = "kotlin";
    @NotNull
    private static final Regex DECAMELIZE_REGEX = new Regex("([A-Z])");

    public NpmProject(@NotNull KotlinJsCompilation compilation2) {
        Intrinsics.checkNotNullParameter((Object)compilation2, (String)"compilation");
        this.compilation = compilation2;
        this.compilationName = this.compilation.getDisambiguatedName();
        this.extension = this.compilation.getPlatformType() == KotlinPlatformType.wasm ? ".mjs" : ".js";
        this.name$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NpmProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NpmProject.access$buildNpmProjectName(this.this$0);
            }
        }));
        Project project = this.getProject().getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
        this.nodeJs = NodeJsRootPlugin.Companion.getKotlinNodeJsExtension(project);
        this.dir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ NpmProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return FilesKt.resolve((File)this.this$0.getNodeJs().getProjectPackagesDir(), (String)this.this$0.getName());
            }
        }));
        this.packageJsonTaskPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NpmProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return this.this$0.getPackageJsonTask().getPath();
            }
        }));
        this.modules = new NpmProjectModules(this.getDir(), null, null, null, 14, null);
        this.nodeExecutable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NpmProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ((NodeJsEnv)this.this$0.getNodeJs().requireConfigured()).getNodeExecutable();
            }
        }));
    }

    @NotNull
    public final KotlinJsCompilation getCompilation() {
        return this.compilation;
    }

    @NotNull
    public final String getCompilationName() {
        return this.compilationName;
    }

    @NotNull
    public final String getName() {
        Lazy lazy = this.name$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final NodeJsRootExtension getNodeJs() {
        return this.nodeJs;
    }

    @NotNull
    public final File getDir() {
        Lazy lazy = this.dir$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final KotlinJsTargetDsl getTarget() {
        KotlinTarget kotlinTarget = this.compilation.getTarget();
        Intrinsics.checkNotNull((Object)kotlinTarget, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.targets.js.dsl.KotlinJsTargetDsl");
        return (KotlinJsTargetDsl)kotlinTarget;
    }

    @NotNull
    public final Project getProject() {
        return this.getTarget().getProject();
    }

    @NotNull
    public final File getNodeModulesDir() {
        return FilesKt.resolve((File)this.getDir(), (String)NODE_MODULES);
    }

    @NotNull
    public final File getPackageJsonFile() {
        return FilesKt.resolve((File)this.getDir(), (String)PACKAGE_JSON);
    }

    @NotNull
    public final String getPackageJsonTaskName() {
        return KotlinCompilationsKt.disambiguateName(this.compilation, "packageJson");
    }

    @NotNull
    public final KotlinPackageJsonTask getPackageJsonTask() {
        Task task2 = this.getProject().getTasks().getByName(this.getPackageJsonTaskName());
        Intrinsics.checkNotNull((Object)task2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.targets.js.npm.tasks.KotlinPackageJsonTask");
        return (KotlinPackageJsonTask)task2;
    }

    public final String getPackageJsonTaskPath() {
        Lazy lazy = this.packageJsonTaskPath$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final File getDist() {
        return FilesKt.resolve((File)this.getDir(), (String)DIST_FOLDER);
    }

    @NotNull
    public final String getMain() {
        return DIST_FOLDER + File.separator + this.getName() + this.extension;
    }

    @NotNull
    public final String getPublicPackageJsonTaskName() {
        return KotlinCompilationsKt.disambiguateName(this.compilation, "publicPackageJson");
    }

    @NotNull
    public final NpmProjectModules getModules$kotlin_gradle_plugin_common() {
        return this.modules;
    }

    private final String getNodeExecutable() {
        Lazy lazy = this.nodeExecutable$delegate;
        return (String)lazy.getValue();
    }

    public final void useTool(@NotNull ExecSpec exec2, @NotNull String tool, @NotNull List<String> nodeArgs, @NotNull List<String> args2) {
        Intrinsics.checkNotNullParameter((Object)exec2, (String)"exec");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter(nodeArgs, (String)"nodeArgs");
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        exec2.setWorkingDir(this.getDir());
        exec2.setExecutable(this.getNodeExecutable());
        exec2.setArgs(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)nodeArgs, (Object)this.require(tool)), (Iterable)args2));
    }

    public static /* synthetic */ void useTool$default(NpmProject npmProject, ExecSpec execSpec, String string, List list2, List list3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: useTool");
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        npmProject.useTool(execSpec, string, list2, list3);
    }

    @NotNull
    public final String require(@NotNull String request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.modules.require(request);
    }

    @Nullable
    public final File resolve$kotlin_gradle_plugin_common(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return NpmProjectModules.resolve$kotlin_gradle_plugin_common$default(this.modules, name2, null, 2, null);
    }

    private final String buildNpmProjectName() {
        String string;
        Object[] objectArray;
        String compilationName;
        String string2 = this.compilation.getOutputModuleName();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return it;
        }
        Project project = this.getTarget().getProject();
        String moduleName = this.getTarget().getModuleName();
        String string3 = compilationName = !Intrinsics.areEqual((Object)this.compilation.getName(), (Object)"main") ? this.compilation.getName() : null;
        if (moduleName != null) {
            Object[] bl = new String[]{moduleName, compilationName};
            return SequencesKt.joinToString$default((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])bl)), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
        }
        String rootProjectName = project.getRootProject().getName();
        String localName = !Intrinsics.areEqual((Object)project, (Object)project.getRootProject()) ? StringsKt.replace$default((String)(rootProjectName + project.getPath()), (String)":", (String)"-", (boolean)false, (int)4, null) : rootProjectName;
        if (((CharSequence)this.getTarget().getName()).length() > 0 && !Intrinsics.areEqual((Object)CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)this.getTarget().getName()), (Object)"js")) {
            objectArray = this.getTarget().getName();
            Regex regex = DECAMELIZE_REGEX;
            Function1 function1 = buildNpmProjectName.targetName.1.INSTANCE;
            string = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)regex.replace((CharSequence)objectArray, function1));
        } else {
            string = null;
        }
        String targetName2 = string;
        objectArray = new String[]{localName, targetName2, compilationName};
        return SequencesKt.joinToString$default((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public String toString() {
        return "NpmProject(" + this.getName() + ')';
    }

    public static final /* synthetic */ String access$buildNpmProjectName(NpmProject $this) {
        return $this.buildNpmProjectName();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProject$Companion;", "", "()V", "DECAMELIZE_REGEX", "Lkotlin/text/Regex;", "DIST_FOLDER", "", "NODE_MODULES", "PACKAGE_JSON", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

