/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android.checker;

import com.android.Version;
import com.android.build.gradle.api.AndroidSourceSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.AndroidGradlePluginVersion;
import org.jetbrains.kotlin.gradle.plugin.AndroidGradlePluginVersionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayout;
import org.jetbrains.kotlin.gradle.plugin.sources.android.checker.KotlinAndroidSourceSetLayoutChecker;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/MultiplatformLayoutV2AgpRequirementChecker;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker;", "()V", "minimumRequiredAgpVersion", "Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "getMinimumRequiredAgpVersion$kotlin_gradle_plugin_common", "()Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "checkBeforeLayoutApplied", "", "diagnosticReporter", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker$DiagnosticReporter;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "layout", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;", "isAgpRequirementMet", "", "isAgpRequirementMet$kotlin_gradle_plugin_common", "AgpRequirementNotMetDiagnostic", "kotlin-gradle-plugin_common"})
public final class MultiplatformLayoutV2AgpRequirementChecker
implements KotlinAndroidSourceSetLayoutChecker {
    @NotNull
    public static final MultiplatformLayoutV2AgpRequirementChecker INSTANCE = new MultiplatformLayoutV2AgpRequirementChecker();
    @NotNull
    private static final AndroidGradlePluginVersion minimumRequiredAgpVersion = new AndroidGradlePluginVersion(7, 0, 0, null, 8, null);

    private MultiplatformLayoutV2AgpRequirementChecker() {
    }

    @NotNull
    public final AndroidGradlePluginVersion getMinimumRequiredAgpVersion$kotlin_gradle_plugin_common() {
        return minimumRequiredAgpVersion;
    }

    @Override
    public void checkBeforeLayoutApplied(@NotNull KotlinAndroidSourceSetLayoutChecker.DiagnosticReporter diagnosticReporter, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout) {
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        if (!this.isAgpRequirementMet$kotlin_gradle_plugin_common()) {
            String string = minimumRequiredAgpVersion.toString();
            String string2 = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
            diagnosticReporter.error(new AgpRequirementNotMetDiagnostic(string, string2));
            throw null;
        }
    }

    public final boolean isAgpRequirementMet$kotlin_gradle_plugin_common() {
        return AndroidGradlePluginVersionKt.isAtLeast(AndroidGradlePluginVersion.Companion.getCurrentOrNull(), minimumRequiredAgpVersion);
    }

    @Override
    public void checkCreatedSourceSet(@NotNull KotlinAndroidSourceSetLayoutChecker.DiagnosticReporter diagnosticReporter, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull AndroidSourceSet androidSourceSet) {
        KotlinAndroidSourceSetLayoutChecker.DefaultImpls.checkCreatedSourceSet(this, diagnosticReporter, target2, layout, kotlinSourceSet, androidSourceSet);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/MultiplatformLayoutV2AgpRequirementChecker$AgpRequirementNotMetDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker$Diagnostic;", "minimumRequiredAgpVersion", "", "currentAgpVersion", "(Ljava/lang/String;Ljava/lang/String;)V", "getCurrentAgpVersion", "()Ljava/lang/String;", "message", "getMessage", "getMinimumRequiredAgpVersion", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
    public static final class AgpRequirementNotMetDiagnostic
    implements KotlinAndroidSourceSetLayoutChecker.Diagnostic {
        @NotNull
        private final String minimumRequiredAgpVersion;
        @NotNull
        private final String currentAgpVersion;

        public AgpRequirementNotMetDiagnostic(@NotNull String minimumRequiredAgpVersion, @NotNull String currentAgpVersion) {
            Intrinsics.checkNotNullParameter((Object)minimumRequiredAgpVersion, (String)"minimumRequiredAgpVersion");
            Intrinsics.checkNotNullParameter((Object)currentAgpVersion, (String)"currentAgpVersion");
            this.minimumRequiredAgpVersion = minimumRequiredAgpVersion;
            this.currentAgpVersion = currentAgpVersion;
        }

        @NotNull
        public final String getMinimumRequiredAgpVersion() {
            return this.minimumRequiredAgpVersion;
        }

        @NotNull
        public final String getCurrentAgpVersion() {
            return this.currentAgpVersion;
        }

        @Override
        @NotNull
        public String getMessage() {
            return StringsKt.trimIndent((String)("\n                requires Android Gradle Plugin Version >= " + this.minimumRequiredAgpVersion + ".\n                Found " + this.currentAgpVersion + "\n            "));
        }

        @NotNull
        public final String component1() {
            return this.minimumRequiredAgpVersion;
        }

        @NotNull
        public final String component2() {
            return this.currentAgpVersion;
        }

        @NotNull
        public final AgpRequirementNotMetDiagnostic copy(@NotNull String minimumRequiredAgpVersion, @NotNull String currentAgpVersion) {
            Intrinsics.checkNotNullParameter((Object)minimumRequiredAgpVersion, (String)"minimumRequiredAgpVersion");
            Intrinsics.checkNotNullParameter((Object)currentAgpVersion, (String)"currentAgpVersion");
            return new AgpRequirementNotMetDiagnostic(minimumRequiredAgpVersion, currentAgpVersion);
        }

        public static /* synthetic */ AgpRequirementNotMetDiagnostic copy$default(AgpRequirementNotMetDiagnostic agpRequirementNotMetDiagnostic, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = agpRequirementNotMetDiagnostic.minimumRequiredAgpVersion;
            }
            if ((n & 2) != 0) {
                string2 = agpRequirementNotMetDiagnostic.currentAgpVersion;
            }
            return agpRequirementNotMetDiagnostic.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "AgpRequirementNotMetDiagnostic(minimumRequiredAgpVersion=" + this.minimumRequiredAgpVersion + ", currentAgpVersion=" + this.currentAgpVersion + ')';
        }

        public int hashCode() {
            int result2 = this.minimumRequiredAgpVersion.hashCode();
            result2 = result2 * 31 + this.currentAgpVersion.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AgpRequirementNotMetDiagnostic)) {
                return false;
            }
            AgpRequirementNotMetDiagnostic agpRequirementNotMetDiagnostic = (AgpRequirementNotMetDiagnostic)other;
            if (!Intrinsics.areEqual((Object)this.minimumRequiredAgpVersion, (Object)agpRequirementNotMetDiagnostic.minimumRequiredAgpVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.currentAgpVersion, (Object)agpRequirementNotMetDiagnostic.currentAgpVersion);
        }
    }
}

