/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.KotlinCocoapodsPluginKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.Framework;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.tasks.FatFrameworkTask;
import org.jetbrains.kotlin.gradle.tasks.FrameworkDescriptor;
import org.jetbrains.kotlin.gradle.tasks.FrameworkDsymLayout;
import org.jetbrains.kotlin.gradle.tasks.FrameworkLayout;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;
import org.jetbrains.kotlin.konan.target.Architecture;
import org.jetbrains.kotlin.konan.target.Family;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.util.VisibleNamedKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 I2\u00020\u0001:\u0002IJB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010,\u001a\u00020-H\u0005J\u0018\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\bH\u0002J\u001f\u00101\u001a\u00020-2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020302\"\u000203\u00a2\u0006\u0002\u00104J\u0014\u00101\u001a\u00020-2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002030 J\u0014\u00105\u001a\u00020-2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060 J\n\u00106\u001a\u0004\u0018\u000107H\u0002J\u0010\u00108\u001a\u00020-2\u0006\u0010/\u001a\u00020\u000eH\u0002J\b\u00109\u001a\u00020-H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010/\u001a\u00020\u000eH\u0002J\u0018\u0010<\u001a\u00020-2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\bH\u0002J5\u0010=\u001a\n ?*\u0004\u0018\u00010>0>2\u0006\u0010@\u001a\u00020\u000e2\u001b\u0010A\u001a\u0017\u0012\b\u0012\u00060CR\u00020\u0000\u0012\u0004\u0012\u00020-0B\u00a2\u0006\u0002\bDH\u0002J\u0018\u0010E\u001a\u00020-2\u0006\u0010F\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\bH\u0002J&\u0010G\u001a\n ?*\u0004\u0018\u00010>0>2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010/\u001a\u00020\u000eH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\nR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c8G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020!0 8EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0018\u0010&\u001a\u00020\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0018\u0010)\u001a\u00020\b*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/FatFrameworkTask;", "Lorg/gradle/api/DefaultTask;", "()V", "archToFramework", "", "Lorg/jetbrains/kotlin/konan/target/Architecture;", "Lorg/jetbrains/kotlin/gradle/tasks/FrameworkDescriptor;", "baseName", "", "getBaseName", "()Ljava/lang/String;", "setBaseName", "(Ljava/lang/String;)V", "destinationDir", "Ljava/io/File;", "getDestinationDir", "()Ljava/io/File;", "setDestinationDir", "(Ljava/io/File;)V", "fatFramework", "getFatFramework", "fatFrameworkLayout", "Lorg/jetbrains/kotlin/gradle/tasks/FrameworkLayout;", "getFatFrameworkLayout", "()Lorg/jetbrains/kotlin/gradle/tasks/FrameworkLayout;", "fatFrameworkName", "getFatFrameworkName", "frameworks", "", "getFrameworks", "()Ljava/util/Collection;", "inputDsymFiles", "", "Lorg/gradle/api/file/FileTree;", "getInputDsymFiles", "()Ljava/lang/Iterable;", "inputFrameworkFiles", "getInputFrameworkFiles", "clangMacro", "getClangMacro", "(Lorg/jetbrains/kotlin/konan/target/Architecture;)Ljava/lang/String;", "plistPlatform", "getPlistPlatform", "(Lorg/jetbrains/kotlin/gradle/tasks/FrameworkDescriptor;)Ljava/lang/String;", "createFatFramework", "", "createModuleFile", "outputFile", "frameworkName", "from", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;", "([Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;)V", "fromFrameworkDescriptors", "getFatFrameworkFamily", "Lorg/jetbrains/kotlin/konan/target/Family;", "mergeBinaries", "mergeDSYM", "mergeHeaders", "", "mergePlists", "processPlist", "Lorg/gradle/process/ExecResult;", "kotlin.jvm.PlatformType", "plist", "commands", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/gradle/tasks/FatFrameworkTask$PlistBuddyRunner;", "Lkotlin/ExtensionFunctionType;", "runInstallNameTool", "file", "runLipo", "inputFiles", "Companion", "PlistBuddyRunner", "kotlin-gradle-plugin_common"})
public class FatFrameworkTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Architecture, FrameworkDescriptor> archToFramework;
    @Input
    @NotNull
    private String baseName;
    @OutputDirectory
    @NotNull
    private File destinationDir;
    @NotNull
    private static final List<KonanTarget> supportedTargets;

    public FatFrameworkTask() {
        this.onlyIf(1.INSTANCE);
        this.archToFramework = new LinkedHashMap();
        String string = this.getProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        this.baseName = string;
        File file = this.getProject().getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        this.destinationDir = FilesKt.resolve((File)file, (String)"fat-framework");
    }

    @Internal
    @NotNull
    public final Collection<FrameworkDescriptor> getFrameworks() {
        return this.archToFramework.values();
    }

    @NotNull
    public final String getBaseName() {
        return this.baseName;
    }

    public final void setBaseName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.baseName = string;
    }

    @NotNull
    public final File getDestinationDir() {
        return this.destinationDir;
    }

    public final void setDestinationDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.destinationDir = file;
    }

    @Internal
    @NotNull
    public final String getFatFrameworkName() {
        return KotlinCocoapodsPluginKt.asValidFrameworkName(this.baseName);
    }

    @Internal
    @NotNull
    public final File getFatFramework() {
        return FilesKt.resolve((File)this.destinationDir, (String)(this.getFatFrameworkName() + ".framework"));
    }

    private final FrameworkLayout getFatFrameworkLayout() {
        return new FrameworkLayout(this.getFatFramework());
    }

    /*
     * WARNING - void declaration
     */
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @IgnoreEmptyDirectories
    @InputFiles
    @SkipWhenEmpty
    @NotNull
    protected final Iterable<FileTree> getInputFrameworkFiles() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getFrameworks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FrameworkDescriptor frameworkDescriptor = (FrameworkDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getProject().fileTree((Object)it.getFile()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @IgnoreEmptyDirectories
    @InputFiles
    @NotNull
    protected final Iterable<FileTree> getInputDsymFiles() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getFrameworks();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ConfigurableFileTree configurableFileTree;
            ConfigurableFileTree configurableFileTree2;
            FrameworkDsymLayout frameworkDsymLayout;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FrameworkDescriptor framework2 = (FrameworkDescriptor)element$iv$iv;
            boolean bl2 = false;
            Object object = framework2.getFiles().getDSYM();
            FrameworkDsymLayout it = object;
            boolean bl3 = false;
            FrameworkDsymLayout frameworkDsymLayout2 = frameworkDsymLayout = it.exists() ? object : null;
            if (frameworkDsymLayout != null && (object = frameworkDsymLayout.getRootDir()) != null) {
                Object object2;
                Object it2 = object2 = object;
                boolean bl4 = false;
                configurableFileTree2 = this.getProject().fileTree(it2);
            } else {
                configurableFileTree2 = null;
            }
            if (configurableFileTree2 == null) continue;
            ConfigurableFileTree it$iv$iv = configurableFileTree = configurableFileTree2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void from(Framework ... frameworks) {
        Intrinsics.checkNotNullParameter((Object)frameworks, (String)"frameworks");
        this.from(ArraysKt.toList((Object[])frameworks));
    }

    /*
     * WARNING - void declaration
     */
    public final void from(@NotNull Iterable<Framework> frameworks) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(frameworks, (String)"frameworks");
        Iterable<Framework> iterable = frameworks;
        FatFrameworkTask fatFrameworkTask2 = this;
        boolean $i$f$map = false;
        Iterator<Framework> iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Framework framework2 = (Framework)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FrameworkDescriptor((Framework)it));
        }
        fatFrameworkTask2.fromFrameworkDescriptors((List)destination$iv$iv);
        Iterable<Framework> $this$forEach$iv = frameworks;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Framework element$iv;
            Framework it = element$iv = iterator.next();
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getLinkTask()};
            this.dependsOn(objectArray);
        }
    }

    public final void fromFrameworkDescriptors(@NotNull Iterable<FrameworkDescriptor> frameworks) {
        Intrinsics.checkNotNullParameter(frameworks, (String)"frameworks");
        Iterable<FrameworkDescriptor> $this$forEach$iv = frameworks;
        boolean $i$f$forEach = false;
        Iterator<FrameworkDescriptor> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            boolean bl;
            Architecture arch;
            FrameworkDescriptor framework2;
            block11: {
                boolean bl2;
                FrameworkDescriptor element$iv;
                framework2 = element$iv = iterator.next();
                boolean bl3 = false;
                arch = framework2.getTarget().getArchitecture();
                Family family = framework2.getTarget().getFamily();
                Family fatFrameworkFamily = this.getFatFrameworkFamily();
                boolean bl4 = bl = fatFrameworkFamily == null || family == fatFrameworkFamily;
                if (!bl) {
                    boolean $i$a$-require-FatFrameworkTask$fromFrameworkDescriptors$1$32 = false;
                    StringBuilder stringBuilder = new StringBuilder().append("Cannot add a binary with platform family '").append(VisibleNamedKt.getVisibleName((Enum)family)).append("' to the fat framework:\nA fat framework must include binaries with the same platform family while this framework already includes binaries with family '");
                    Family family2 = fatFrameworkFamily;
                    Intrinsics.checkNotNull((Object)((Object)family2));
                    String $i$a$-require-FatFrameworkTask$fromFrameworkDescriptors$1$32 = stringBuilder.append(VisibleNamedKt.getVisibleName((Enum)family2)).append('\'').toString();
                    throw (Throwable)new IllegalArgumentException($i$a$-require-FatFrameworkTask$fromFrameworkDescriptors$1$32.toString());
                }
                boolean bl5 = bl = !this.archToFramework.containsKey((Object)arch);
                if (!bl) {
                    boolean $i$a$-require-FatFrameworkTask$fromFrameworkDescriptors$1$52 = false;
                    FrameworkDescriptor alreadyAdded = (FrameworkDescriptor)MapsKt.getValue(this.archToFramework, (Object)((Object)arch));
                    StringBuilder stringBuilder = new StringBuilder().append("This fat framework already has a binary for architecture `");
                    String string = arch.name();
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = string.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                    String $i$a$-require-FatFrameworkTask$fromFrameworkDescriptors$1$52 = stringBuilder.append(string2).append("` (").append(alreadyAdded.getName()).append(" for target `").append(alreadyAdded.getTarget().getName()).append("`)").toString();
                    throw (Throwable)new IllegalArgumentException($i$a$-require-FatFrameworkTask$fromFrameworkDescriptors$1$52.toString());
                }
                Map<Architecture, FrameworkDescriptor> $this$all$iv = this.archToFramework;
                boolean $i$f$all = false;
                if ($this$all$iv.isEmpty()) {
                    bl2 = true;
                } else {
                    object = $this$all$iv;
                    Iterator<Map.Entry<Architecture, FrameworkDescriptor>> iterator2 = object.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<Architecture, FrameworkDescriptor> element$iv2;
                        Map.Entry<Architecture, FrameworkDescriptor> it = element$iv2 = iterator2.next();
                        boolean bl6 = false;
                        if (it.getValue().isStatic() == framework2.isStatic()) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = bl = true;
                }
            }
            if (!bl) {
                boolean bl7 = false;
                Object $this$fromFrameworkDescriptors_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10 = object = new StringBuilder();
                boolean bl8 = false;
                ((StringBuilder)$this$fromFrameworkDescriptors_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10).append("Cannot create a fat framework from:\n");
                Map<Architecture, FrameworkDescriptor> $this$forEach$iv2 = this.archToFramework;
                boolean $i$f$forEach2 = false;
                Map<Architecture, FrameworkDescriptor> map = $this$forEach$iv2;
                Iterator<Map.Entry<Architecture, FrameworkDescriptor>> iterator3 = map.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry<Architecture, FrameworkDescriptor> element$iv;
                    Map.Entry<Architecture, FrameworkDescriptor> it = element$iv = iterator3.next();
                    boolean bl9 = false;
                    StringBuilder stringBuilder = new StringBuilder().append(it.getValue().getName()).append(" - ");
                    String string = it.getKey().name();
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    ((StringBuilder)$this$fromFrameworkDescriptors_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10).append(stringBuilder.append(string3).append(" - ").append(FatFrameworkTask.fromFrameworkDescriptors$lambda-12$lambda-11$staticName(it.getValue().isStatic())).append('\n').toString());
                }
                StringBuilder stringBuilder = new StringBuilder().append(framework2.getName()).append(" - ");
                String string = arch.name();
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                ((StringBuilder)$this$fromFrameworkDescriptors_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10).append(stringBuilder.append(string4).append(" - ").append(FatFrameworkTask.fromFrameworkDescriptors$lambda-12$lambda-11$staticName(framework2.isStatic())).append('\n').toString());
                ((StringBuilder)$this$fromFrameworkDescriptors_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10).append("All input frameworks must be either static or dynamic");
                String string5 = ((StringBuilder)object).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
                String string6 = string5;
                throw (Throwable)new IllegalArgumentException(string6.toString());
            }
            this.archToFramework.put(arch, framework2);
        }
    }

    private final Family getFatFrameworkFamily() {
        boolean bl;
        Iterable $this$distinctBy$iv = this.archToFramework.values();
        boolean $i$f$distinctBy = false;
        HashSet<Family> set$iv = new HashSet<Family>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            FrameworkDescriptor it = (FrameworkDescriptor)e$iv;
            boolean bl2 = false;
            Family key$iv = it.getTarget().getFamily();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        boolean bl3 = bl = ((List)list$iv).size() <= 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object object = (FrameworkDescriptor)CollectionsKt.firstOrNull((Iterable)this.archToFramework.values());
        return object != null && (object = ((FrameworkDescriptor)object).getTarget()) != null ? ((KonanTarget)object).getFamily() : null;
    }

    private final String getClangMacro(Architecture $this$clangMacro) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$clangMacro.ordinal()]) {
            case 1: {
                string = "__i386__";
                break;
            }
            case 2: {
                string = "__x86_64__";
                break;
            }
            case 3: {
                string = "__arm__";
                break;
            }
            case 4: {
                string = "__aarch64__";
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException(("Fat frameworks are not supported for architecture `" + $this$clangMacro.name() + '`').toString());
            }
        }
        return string;
    }

    private final String getPlistPlatform(FrameworkDescriptor $this$plistPlatform) {
        String string;
        KonanTarget konanTarget2 = $this$plistPlatform.getTarget();
        if (((Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.IOS_ARM32.INSTANCE) ? true : Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.IOS_ARM64.INSTANCE)) ? true : Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.IOS_X64.INSTANCE)) ? true : Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.IOS_SIMULATOR_ARM64.INSTANCE)) {
            string = "iPhoneOS";
        } else if ((Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.TVOS_ARM64.INSTANCE) ? true : Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.TVOS_X64.INSTANCE)) ? true : Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.TVOS_SIMULATOR_ARM64.INSTANCE)) {
            string = "AppleTVOS";
        } else if ((((Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.WATCHOS_ARM32.INSTANCE) ? true : Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.WATCHOS_ARM64.INSTANCE)) ? true : Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.WATCHOS_X86.INSTANCE)) ? true : Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.WATCHOS_X64.INSTANCE)) ? true : Intrinsics.areEqual((Object)konanTarget2, (Object)KonanTarget.WATCHOS_SIMULATOR_ARM64.INSTANCE)) {
            string = "WatchOS";
        } else {
            throw (Throwable)new IllegalStateException(("Fat frameworks are not supported for platform `" + $this$plistPlatform.getTarget().getVisibleName() + '`').toString());
        }
        return string;
    }

    private final ExecResult processPlist(File plist, Function1<? super PlistBuddyRunner, Unit> commands) {
        PlistBuddyRunner plistBuddyRunner;
        PlistBuddyRunner $this$processPlist_u24lambda_u2d14 = plistBuddyRunner = new PlistBuddyRunner(plist);
        boolean bl = false;
        commands.invoke((Object)$this$processPlist_u24lambda_u2d14);
        return plistBuddyRunner.run();
    }

    private final ExecResult runLipo(Collection<? extends File> inputFiles, File outputFile2) {
        return this.getProject().exec(new Action(inputFiles, outputFile2){
            final /* synthetic */ Collection<File> $inputFiles;
            final /* synthetic */ File $outputFile;
            {
                this.$inputFiles = $inputFiles;
                this.$outputFile = $outputFile;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(ExecSpec exec2) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                exec2.setExecutable("/usr/bin/lipo");
                SpreadBuilder spreadBuilder = new SpreadBuilder(4);
                spreadBuilder.add((Object)"-create");
                Iterable iterable = this.$inputFiles;
                SpreadBuilder spreadBuilder2 = spreadBuilder;
                ExecSpec execSpec = exec2;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getAbsolutePath());
                }
                collection = (List)destination$iv$iv;
                Collection $this$toTypedArray$iv = collection;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                spreadBuilder2.addSpread((Object)stringArray);
                spreadBuilder.add((Object)"-output");
                spreadBuilder.add((Object)this.$outputFile.getAbsolutePath());
                execSpec.setArgs(CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])));
            }
        });
    }

    private final void runInstallNameTool(File file, String frameworkName2) {
        this.getProject().exec(new Action(frameworkName2, file){
            final /* synthetic */ String $frameworkName;
            final /* synthetic */ File $file;
            {
                this.$frameworkName = $frameworkName;
                this.$file = $file;
            }

            public final void execute(ExecSpec exec2) {
                exec2.setExecutable("install_name_tool");
                Object[] objectArray = new String[]{"-id", "@rpath/" + this.$frameworkName + ".framework/" + this.$frameworkName, this.$file.getAbsolutePath()};
                exec2.setArgs(CollectionsKt.listOf((Object[])objectArray));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeBinaries(File outputFile2) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.archToFramework.values();
            FatFrameworkTask fatFrameworkTask2 = this;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FrameworkDescriptor frameworkDescriptor = (FrameworkDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getFiles().getBinary());
            }
            fatFrameworkTask2.runLipo((List)destination$iv$iv, outputFile2);
            Iterable $this$any$iv = this.archToFramework.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FrameworkDescriptor it = (FrameworkDescriptor)element$iv;
                    boolean bl3 = false;
                    if (!(!it.isStatic() && !Intrinsics.areEqual((Object)it.getName(), (Object)this.getFatFrameworkName()))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.runInstallNameTool(outputFile2, this.getFatFrameworkName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Object mergeHeaders(File outputFile2) {
        Unit unit;
        Object object = outputFile2;
        Object object2 = Charsets.UTF_8;
        Object object3 = object;
        object3 = new FileOutputStream((File)object3);
        object = new OutputStreamWriter((OutputStream)object3, (Charset)object2);
        object2 = null;
        try {
            Object object4;
            void $this$mapValuesTo$iv$iv;
            OutputStreamWriter writer = (OutputStreamWriter)object;
            boolean bl = false;
            Map<Architecture, FrameworkDescriptor> $this$mapValues$iv = this.archToFramework;
            boolean $i$f$mapValues = false;
            Map<Architecture, FrameworkDescriptor> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl3 = false;
                FrameworkDescriptor framework2 = (FrameworkDescriptor)entry2.getValue();
                String string = FilesKt.readText$default((File)framework2.getFiles().getHeader(), null, (int)1, null);
                map3.put(k, string);
            }
            Map headerContents = destination$iv$iv;
            if (CollectionsKt.distinct((Iterable)headerContents.values()).size() == 1) {
                writer.write((String)CollectionsKt.first((Iterable)headerContents.values()));
                object4 = Unit.INSTANCE;
            } else {
                Iterable $this$forEachIndexed$iv = MapsKt.toList((Map)headerContents);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Pair pair = (Pair)item$iv;
                    int i2 = n;
                    boolean bl4 = false;
                    Architecture arch = (Architecture)((Object)pair.component1());
                    String content = (String)pair.component2();
                    String macro = this.getClangMacro(arch);
                    if (i2 == 0) {
                        StringUtilsKt.appendLine(writer, "#if defined(" + macro + ")\n");
                    } else {
                        StringUtilsKt.appendLine(writer, "#elif defined(" + macro + ")\n");
                    }
                    StringUtilsKt.appendLine(writer, content);
                }
                object4 = StringUtilsKt.appendLine(writer, "#else\n#error Unsupported platform\n#endif");
            }
            unit = object4;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return unit;
    }

    private final void createModuleFile(File outputFile2, String frameworkName2) {
        FilesKt.writeText$default((File)outputFile2, (String)StringsKt.trimIndent((String)("\n            framework module " + frameworkName2 + " {\n                umbrella header \"" + frameworkName2 + ".h\"\n\n                export *\n                module * { export * }\n            }\n        ")), null, (int)2, null);
    }

    private final void mergePlists(File outputFile2, String frameworkName2) {
        boolean bl;
        boolean bl2 = bl = !this.getFrameworks().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        File baseInfo = ((FrameworkDescriptor)CollectionsKt.first((Iterable)this.getFrameworks())).getFiles().getInfoPlist();
        this.getProject().copy(new Action(baseInfo, outputFile2){
            final /* synthetic */ File $baseInfo;
            final /* synthetic */ File $outputFile;
            {
                this.$baseInfo = $baseInfo;
                this.$outputFile = $outputFile;
            }

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[]{this.$baseInfo};
                it.from(objectArray);
                it.into((Object)this.$outputFile.getParentFile());
            }
        });
        this.processPlist(outputFile2, (Function1<? super PlistBuddyRunner, Unit>)((Function1)mergePlists.2.INSTANCE));
        this.processPlist(outputFile2, (Function1<? super PlistBuddyRunner, Unit>)((Function1)new Function1<PlistBuddyRunner, Unit>(frameworkName2, this){
            final /* synthetic */ String $frameworkName;
            final /* synthetic */ FatFrameworkTask this$0;
            {
                this.$frameworkName = $frameworkName;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull PlistBuddyRunner $this$processPlist) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)$this$processPlist, (String)"$this$processPlist");
                $this$processPlist.set(":CFBundleExecutable", this.$frameworkName);
                $this$processPlist.set(":CFBundleName", this.$frameworkName);
                $this$processPlist.delete(":CFBundleSupportedPlatforms:0");
                Iterable iterable = this.this$0.getFrameworks();
                FatFrameworkTask fatFrameworkTask2 = this.this$0;
                boolean $i$f$map = false;
                Iterator<T> iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FrameworkDescriptor frameworkDescriptor = (FrameworkDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(FatFrameworkTask.access$getPlistPlatform(fatFrameworkTask2, (FrameworkDescriptor)it));
                }
                Iterable $this$forEachIndexed$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void platform;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv;
                    int index = n;
                    boolean bl = false;
                    $this$processPlist.add(":CFBundleSupportedPlatforms:" + index, (String)platform);
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeDSYM() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Object object2;
        void $this$mapValuesTo$iv$iv;
        Map<Architecture, FrameworkDescriptor> $this$mapValues$iv = this.archToFramework;
        boolean $i$f$mapValues = false;
        Map<Architecture, FrameworkDescriptor> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            object = map2;
            boolean bl2 = false;
            FrameworkDescriptor framework2 = (FrameworkDescriptor)entry2.getValue();
            FrameworkDsymLayout frameworkDsymLayout = framework2.getFiles().getDSYM();
            object.put(object2, frameworkDsymLayout);
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues22 = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        destination$iv$iv = $this$filterValues$iv;
        for (Map.Entry entry$iv : destination$iv$iv.entrySet()) {
            FrameworkDsymLayout it = (FrameworkDsymLayout)entry$iv.getValue();
            boolean bl = false;
            if (!it.exists()) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map dsymInputs = result$iv;
        if (dsymInputs.isEmpty()) {
            return;
        }
        FrameworkDsymLayout fatDsym = this.getFatFrameworkLayout().getDSYM();
        fatDsym.mkdirs();
        Iterable $i$f$filterValues22 = dsymInputs.values();
        object = this;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv$iv;
            element$iv$iv$iv = (FrameworkDsymLayout)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object2.add((File)it.getBinary());
        }
        super.runLipo((List)destination$iv$iv2, fatDsym.getBinary());
        this.getProject().copy(new Action(dsymInputs, fatDsym){
            final /* synthetic */ Map<Architecture, FrameworkDsymLayout> $dsymInputs;
            final /* synthetic */ FrameworkDsymLayout $fatDsym;
            {
                this.$dsymInputs = $dsymInputs;
                this.$fatDsym = $fatDsym;
            }

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[]{((FrameworkDsymLayout)CollectionsKt.first((Iterable)this.$dsymInputs.values())).getInfoPlist()};
                it.from(objectArray);
                it.into((Object)this.$fatDsym.getInfoPlist().getParentFile());
            }
        });
    }

    @TaskAction
    protected final void createFatFramework() {
        FrameworkLayout outFramework = this.getFatFrameworkLayout();
        outFramework.mkdirs();
        this.mergeBinaries(outFramework.getBinary());
        this.mergeHeaders(outFramework.getHeader());
        this.createModuleFile(outFramework.getModuleFile(), this.getFatFrameworkName());
        this.mergePlists(outFramework.getInfoPlist(), this.getFatFrameworkName());
        this.mergeDSYM();
    }

    private static final String fromFrameworkDescriptors$lambda-12$lambda-11$staticName(boolean isStatic) {
        return isStatic ? "static" : "dynamic";
    }

    public static final /* synthetic */ String access$getPlistPlatform(FatFrameworkTask $this, FrameworkDescriptor $receiver) {
        return $this.getPlistPlatform($receiver);
    }

    static {
        Object[] objectArray = new KonanTarget[]{KonanTarget.IOS_ARM32.INSTANCE, KonanTarget.IOS_ARM64.INSTANCE, KonanTarget.IOS_X64.INSTANCE, KonanTarget.WATCHOS_ARM32.INSTANCE, KonanTarget.WATCHOS_ARM64.INSTANCE, KonanTarget.WATCHOS_X86.INSTANCE, KonanTarget.WATCHOS_X64.INSTANCE, KonanTarget.TVOS_ARM64.INSTANCE, KonanTarget.TVOS_X64.INSTANCE};
        supportedTargets = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017J\u0016\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/FatFrameworkTask$PlistBuddyRunner;", "", "plist", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/gradle/tasks/FatFrameworkTask;Ljava/io/File;)V", "commands", "", "", "getCommands", "()Ljava/util/List;", "ignoreExitValue", "", "getIgnoreExitValue", "()Z", "setIgnoreExitValue", "(Z)V", "getPlist", "()Ljava/io/File;", "add", "entry", "value", "delete", "run", "Lorg/gradle/process/ExecResult;", "kotlin.jvm.PlatformType", "set", "kotlin-gradle-plugin_common"})
    private final class PlistBuddyRunner {
        @NotNull
        private final File plist;
        @NotNull
        private final List<String> commands;
        private boolean ignoreExitValue;

        public PlistBuddyRunner(File plist) {
            Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
            this.plist = plist;
            this.commands = new ArrayList();
        }

        @NotNull
        public final File getPlist() {
            return this.plist;
        }

        @NotNull
        public final List<String> getCommands() {
            return this.commands;
        }

        public final boolean getIgnoreExitValue() {
            return this.ignoreExitValue;
        }

        public final void setIgnoreExitValue(boolean bl) {
            this.ignoreExitValue = bl;
        }

        public final ExecResult run() {
            return FatFrameworkTask.this.getProject().exec(new Action(this){
                final /* synthetic */ PlistBuddyRunner this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void execute(ExecSpec exec2) {
                    exec2.setExecutable("/usr/libexec/PlistBuddy");
                    Object[] $this$forEach$iv = (Object[])this.this$0.getCommands();
                    boolean $i$f$forEach = false;
                    for (T t : $this$forEach$iv) {
                        String it = (String)t;
                        boolean bl = false;
                        Object[] objectArray = new Object[]{"-c", it};
                        exec2.args(objectArray);
                    }
                    $this$forEach$iv = new Object[]{this.this$0.getPlist().getAbsolutePath()};
                    exec2.args($this$forEach$iv);
                    exec2.setIgnoreExitValue(this.this$0.getIgnoreExitValue());
                    ByteArrayOutputStream dummyStream = new ByteArrayOutputStream();
                    exec2.setStandardOutput((OutputStream)dummyStream);
                    exec2.setErrorOutput((OutputStream)dummyStream);
                }
            });
        }

        public final boolean add(@NotNull String entry, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.commands.add("Add \"" + entry + "\" string \"" + value + '\"');
        }

        public final boolean set(@NotNull String entry, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.commands.add("Set \"" + entry + "\" \"" + value + '\"');
        }

        public final boolean delete(@NotNull String entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return this.commands.add("Delete \"" + entry + '\"');
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/FatFrameworkTask$Companion;", "", "()V", "supportedTargets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "isSupportedTarget", "", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeTarget;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSupportedTarget(@NotNull KotlinNativeTarget target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            return supportedTargets.contains(target2.getKonanTarget());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Architecture.values().length];
            nArray[Architecture.X86.ordinal()] = 1;
            nArray[Architecture.X64.ordinal()] = 2;
            nArray[Architecture.ARM32.ordinal()] = 3;
            nArray[Architecture.ARM64.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

