/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.report.FileReportSettings;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriter;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionDataProcessor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/report/PlainTextBuildReportWriterDataProcessor;", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionDataProcessor;", "Ljava/io/Serializable;", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/FileReportSettings;", "rootProjectName", "", "(Lorg/jetbrains/kotlin/gradle/report/FileReportSettings;Ljava/lang/String;)V", "getReportingSettings", "()Lorg/jetbrains/kotlin/gradle/report/FileReportSettings;", "getRootProjectName", "()Ljava/lang/String;", "process", "", "build", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin-gradle-plugin_common"})
public final class PlainTextBuildReportWriterDataProcessor
implements BuildExecutionDataProcessor,
Serializable {
    @NotNull
    private final FileReportSettings reportingSettings;
    @NotNull
    private final String rootProjectName;

    public PlainTextBuildReportWriterDataProcessor(@NotNull FileReportSettings reportingSettings, @NotNull String rootProjectName2) {
        Intrinsics.checkNotNullParameter((Object)reportingSettings, (String)"reportingSettings");
        Intrinsics.checkNotNullParameter((Object)rootProjectName2, (String)"rootProjectName");
        this.reportingSettings = reportingSettings;
        this.rootProjectName = rootProjectName2;
    }

    @NotNull
    public final FileReportSettings getReportingSettings() {
        return this.reportingSettings;
    }

    @NotNull
    public final String getRootProjectName() {
        return this.rootProjectName;
    }

    @Override
    public void process(@NotNull BuildExecutionData build, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        String ts = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(Calendar.getInstance().getTime());
        File reportFile = FilesKt.resolve((File)this.reportingSettings.getBuildReportDir(), (String)(this.rootProjectName + "-build-" + ts + ".txt"));
        new PlainTextBuildReportWriter(reportFile, this.reportingSettings.getIncludeMetricsInReport()).process(build, log);
    }
}

