/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\fJ\b\u0010\u0013\u001a\u00020\tH\u0002J\u0011\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleFinishBuildHandler;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "shouldReportMemoryUsage", "", "startMemory", "", "Ljava/lang/Long;", "buildFinished", "", "rootProjectBuildDir", "Ljava/io/File;", "rootProjectRootDir", "gradle", "Lorg/gradle/api/invocation/Gradle;", "buildStart", "getGcCount", "getUsedMemoryKb", "getUsedMemoryKb$kotlin_gradle_plugin_common", "()Ljava/lang/Long;", "Companion", "kotlin-gradle-plugin_common"})
public final class KotlinGradleFinishBuildHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = Logging.getLogger(this.getClass());
    @Nullable
    private Long startMemory;
    private final boolean shouldReportMemoryUsage = System.getProperty("kotlin.gradle.test.report.memory.usage") != null;
    @NotNull
    public static final String SHOULD_REPORT_MEMORY_USAGE_PROPERTY = "kotlin.gradle.test.report.memory.usage";
    @NotNull
    public static final String FORCE_SYSTEM_GC_MESSAGE = "Forcing System.gc()";

    public final void buildStart() {
        this.startMemory = this.getUsedMemoryKb$kotlin_gradle_plugin_common();
    }

    public final void buildFinished(@NotNull File rootProjectBuildDir, @NotNull File rootProjectRootDir) {
        Intrinsics.checkNotNullParameter((Object)rootProjectBuildDir, (String)"rootProjectBuildDir");
        Intrinsics.checkNotNullParameter((Object)rootProjectRootDir, (String)"rootProjectRootDir");
        TaskLoggers.INSTANCE.clear();
        TaskExecutionResults.INSTANCE.clear();
        GradleCompilerRunner.Companion.clearBuildModulesInfo$kotlin_gradle_plugin_common();
        File sessionsDir = GradleCompilerRunner.Companion.sessionsDir$kotlin_gradle_plugin_common(rootProjectBuildDir);
        if (sessionsDir.exists()) {
            File[] sessionFiles = sessionsDir.listFiles();
            if (sessionFiles.length > 1) {
                this.log.warn("w: Detected multiple Kotlin daemon sessions at " + FileUtilsKt.relativeOrCanonical(sessionsDir, rootProjectRootDir));
            }
            Intrinsics.checkNotNullExpressionValue((Object)sessionFiles, (String)"sessionFiles");
            for (File file : sessionFiles) {
                Logger $this$kotlinDebug$iv;
                file.delete();
                Intrinsics.checkNotNullExpressionValue((Object)this.log, (String)"log");
                boolean $i$f$kotlinDebug = false;
                if (!$this$kotlinDebug$iv.isDebugEnabled()) continue;
                Logger logger = $this$kotlinDebug$iv;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Deleted session-is-alive flag file: ");
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                GradleLoggingUtilsKt.kotlinDebug(logger, stringBuilder.append(FileUtilsKt.relativeOrCanonical(file, rootProjectRootDir)).toString());
            }
        }
        if (this.shouldReportMemoryUsage) {
            Long l = this.startMemory;
            Intrinsics.checkNotNull((Object)l);
            long startMem = l;
            Long l2 = this.getUsedMemoryKb$kotlin_gradle_plugin_common();
            Intrinsics.checkNotNull((Object)l2);
            long endMem = l2;
            StringBuilder stringBuilder = new StringBuilder().append("[KOTLIN][PERF] Used memory after build: ").append(endMem).append(" kb (difference since build start: ");
            String string = "%+d";
            Object[] objectArray = new Object[]{endMem - startMem};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
            this.log.lifecycle(stringBuilder.append(string2).append(" kb)").toString());
        }
    }

    public final void buildFinished(@NotNull Gradle gradle) {
        Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
        File file = gradle.getRootProject().getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"gradle.rootProject.buildDir");
        File file2 = gradle.getRootProject().getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"gradle.rootProject.rootDir");
        this.buildFinished(file, file2);
        gradle.removeListener((Object)this);
    }

    @Nullable
    public final Long getUsedMemoryKb$kotlin_gradle_plugin_common() {
        if (!this.shouldReportMemoryUsage) {
            return null;
        }
        this.log.lifecycle(FORCE_SYSTEM_GC_MESSAGE);
        long gcCountBefore = this.getGcCount();
        System.gc();
        while (this.getGcCount() == gcCountBefore) {
        }
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / (long)1024;
    }

    /*
     * WARNING - void declaration
     */
    private final long getGcCount() {
        void var3_3;
        List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getGarbageCollectorMXBeans()");
        Iterable $this$sumByLong$iv = list2;
        boolean $i$f$sumByLong = false;
        long sum$iv = 0L;
        for (Object element$iv : $this$sumByLong$iv) {
            void it;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)element$iv;
            long l = sum$iv;
            boolean bl = false;
            long l2 = Math.max(0L, it.getCollectionCount());
            sum$iv = l + l2;
        }
        return (long)var3_3;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleFinishBuildHandler$Companion;", "", "()V", "FORCE_SYSTEM_GC_MESSAGE", "", "SHOULD_REPORT_MEMORY_USAGE_PROPERTY", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

